#ifndef _h_auto 
#define _h_auto

#include "llist.h"
#include "tab_i.h"
#include "tab_d.h"

#define AUTO_STEP_ALLOC 32 

// define structure of transitions

struct transitions{  
  int n_transitions;
  Tab_i input_tags; //array of the input tags
  Tab_i output_tags;//array of output tags
  Tab_d weights; // array of weights
  Tab_i arr;  //array of the pointed states
};

typedef struct transitions * Transitions;

//define structure of a state of an automaton

struct state{
  char control; // bit 0 = initial state ; bit 1 = final state
  Transitions terminal_trans; // transitions with terminal tags
  Transitions auxiliary_trans; // transitions with auxiliary tags
};

typedef struct state * State;

// Define structure of an automaton

struct automaton{
  long n_states; // number of states in automaton
  State *states; // array of the states of the automaton
  long MAX;
};

typedef struct automaton * Automaton;

// Functions

int auto_get_n_states(Automaton aut);
Automaton auto_init_automaton();
State auto_init_state();
void auto_add_state(Automaton *aut, int index, State st);
void auto_set_initial_state(State);
void auto_set_final_state(State);
int auto_is_initial_state(State);
int auto_is_final_state(State);
Transitions auto_init_transitions();
Transitions auto_get_terminal_transitions(State);
Transitions auto_get_auxiliary_transitions(State);
int auto_get_n_transitions(Transitions);
void auto_copy_transitions(State *st, Llist term_trans,Llist aux_trans);
void auto_free(Automaton *);
int auto_print_n_free();
int auto_print_n_malloc();
void auto_print(Automaton aut,int option);
void auto_println(Automaton aut,int option);
State auto_get_state(Automaton aut,int index);
void auto_print_state(State st,int option);
#endif
