#include "alphabet.h"
#include "utilities.h"
#include <stdlib.h>

int alph_n_free = 0;
int alph_n_malloc = 0;

void* alph_malloc(int n){
  alph_n_malloc++;
  return (void *)malloc(n);
}

void alph_pfree(void *ptr){
  if(ptr == NULL) return;
  alph_n_free++;
  free(ptr);
  ptr = NULL;
}

int alph_print_n_malloc(){
  printf("alph_malloc=%d\n",alph_n_malloc);
  return alph_n_malloc;
}

int alph_print_n_free(){
  printf("alph_free=%d\n",alph_n_free);
  return alph_n_free;
}


Alphabet alph_init(){
  Alphabet alph = NULL;
  alph = (Alphabet)alph_malloc(sizeof(struct alphabet));
  if(alph == NULL) util_error("alph_init","cannot create alphabet");
  alph->equivalences = NULL;
  alph->uchar_hash = hash_init(512);
  return alph;
}

Alphabet alph_load(char *filename,int has_ascii_format){
  FILE *f;
  Ustring u,lowers,temp;
  Uchar upper,lower;
  Alphabet alph = alph_init();
  int key = 1,upper_index;
  
  f = fopen(filename,"r");
  if(f == NULL) util_error("alph_load","cannot open alphabet file");
  
  if(!has_ascii_format) ustring_read_uchar(f,has_ascii_format);
  while((u = ustring_get_line(f,has_ascii_format)) != NULL){
    upper = ustring_get_uchar(u,0);
    lower = ustring_get_uchar(u,1);
    if((upper_index = hash_get_value(alph->uchar_hash,upper)) == 0){ //WARNING: upper_index - 1
      hash_add_element(&(alph->uchar_hash),upper,key,0);
      upper_index = key;
      key++;
    }
    upper_index--;
    lowers = tab_u_get_value(alph->equivalences,upper_index);
    if(lowers != NULL) temp = ustring_allocation(lowers);
    else temp = NULL;
    ustring_append(&temp,lower);
    tab_u_assign_value(&(alph->equivalences),upper_index,temp);
    ustring_free(temp);
    ustring_free(u);
  }
  return alph;
}

int alph_uchar_are_equivalent(Uchar cu,Uchar cv,Alphabet alph){
  Ustring eq;
  int index;

  if(cu == cv) return 1;
  if((index = hash_get_value(alph->uchar_hash,cu)) == 0) return 0;
  eq = tab_u_get_value(alph->equivalences,index -1); //use of index - 1
  return ustring_contains(eq,cv);
}


//return 1 if different ustrings
//return 0 if equal ustrings

int alph_ustring_insensitive_cmp(Ustring u,Ustring v,Alphabet alph){
   int i,lu,lv;
   Uchar cu,cv;

   lu = ustring_length(u);
   lv = ustring_length(v);
   if(lu != lv) return 1;
   for(i = 0 ; i < lu ; i++){
     cu = ustring_get_uchar(u,i);
     cv = ustring_get_uchar(v,i);
     if(!alph_uchar_are_equivalent(cu,cv,alph)) return 1;
   }

  return 0;
}

void alph_apply_tree_on_text_rec(Tree_node current_node,Text t,int pos,Alphabet alph,Tab_u tokens,Llist *list){
  struct tree_cell_node *ptr; 
  Tree_node node;
  int txt_word_index,tree_word_index;
  Ustring txt_word,tree_word;

  txt_word_index = txt_get_element(t,pos);
  if(txt_word_index == -1) return;
  txt_word = tab_u_get_value(tokens,txt_word_index);

  ptr = current_node->nodes;
  while(ptr != NULL){ // for each children node
    node = ptr->n;
    if(node != NULL){
      tree_word_index = node->letter;
      tree_word = tab_u_get_value(tokens,tree_word_index);
      if((tree_word_index == txt_word_index) || !alph_ustring_insensitive_cmp(txt_word,tree_word,alph)){
	if(node->mark != -1) ll_insert(list,pos,node->mark);
	alph_apply_tree_on_text_rec(node,t,pos + 1,alph,tokens,list);
      }
    }
    ptr = ptr->next;
  }

}


Llist alph_get_indexes_insensitive_from_lexicon(Text t,int pos,Lexicon lex,Alphabet alph,Tab_u tokens){
  Tree_node root = lex_get_tree_root(lex);
  Llist res = NULL;
  alph_apply_tree_on_text_rec(root,t,pos,alph,tokens,&res);
  
  return res;
}

void alph_print(Alphabet alph){
  if(alph == NULL)return;
  tab_u_print(alph->equivalences);
  hash_print(alph->uchar_hash);
}

void alph_println(Alphabet alph){
  alph_print(alph);
}



void alph_free(Alphabet *alph){
  if(*alph == NULL) return;
  tab_u_free(&((*alph)->equivalences));
  hash_free((*alph)->uchar_hash);
  alph_pfree(*alph);
}
