#ifndef _TOPOLOGICAL_SORT_H_
#define _TOPOLOGICAL_SORT_H_

#include <outilex/wgb_color.h>

template<typename Fsa, typename OutputIterator>
void topological_order(const Fsa & fsa, int q, wgb_color * color, OutputIterator & out) {

  //std::cerr << "topological order : " << q << std::endl;

  typedef Fsa fsa_type;

  if (color[q] == black) { return; }

  if (color[q] == gray)  { throw std::runtime_error("tri topo: graph is cyclic"); }
  
  color[q] = gray;

  for (typename fsa_type::const_trans_iterator tr = fsa.trans_begin(q);
       tr != fsa.trans_end(q); ++tr) {
    //   std::cerr << "trans: " << tr->in() << ", " << tr->to() << std::endl;
    topological_order(fsa, tr->to(), color, out);
  }

  *out = q; ++out;
  color[q] = black;
}


template<typename FsaIn, typename FsaOut>
void fsa_topological_sort(const FsaIn & ifsa, FsaOut & ofsa) {

  typedef FsaIn ifsa_type;
  typedef FsaOut ofsa_type;

  int size = ifsa.size();

  if (size == 0) {
    ofsa.clear();
    return;
  }

  std::vector<int> topo_sort(size);

  wgb_color color[size];
  for (int i = 0; i< size; ++i) { color[i] = white; }

  std::vector<int>::reverse_iterator out = topo_sort.rbegin();
  topological_order(ifsa, 0, color, out);

  int state_map[size];

  for (int i = 0; i < size; ++i) {
    state_map[topo_sort[i]] = i;
  }

  ofsa.clear();
  ofsa.resize(size);

  for (int q = 0; q < size; ++q) {

    int oq = state_map[q];

    //ofsa[oq] = ifsa[q]; // copy meta-data
    ofsa.set_data(oq, ifsa.data(q)); // copy meta-data

    ofsa.set_final(oq, ifsa.final(q));

    for (typename ifsa_type::const_trans_iterator tr = ifsa.trans_begin(q);
         tr != ifsa.trans_end(q); ++tr) {
      ofsa.add_trans(oq, tr->label(), state_map[tr->to()]);
    }
  }
}

template<typename FSA>
void fsa_topological_sort(FSA & fsa) {
  FSA res;
  fsa_topological_sort(fsa, res);
  fsa.swap(res);
}


#endif
