#ifndef _FSA_PRUNE_H_
#define _FSA_PRUNE_H_

#include <vector>

namespace detail {

enum { ACCESS = 1, COACCESS = 2, USEFUL = 3 };

template<typename Fsa>
//void fill_invtrans(Fsa & fsa, std::vector<int> * invtrans) {
void fill_invtrans(Fsa & fsa, std::vector<std::vector<int> > & invtrans) {

  typedef Fsa fsa_type;

  for (int q = 0; q < fsa.size(); ++q) {
  
    for (typename fsa_type::const_trans_iterator tr = fsa.trans_begin(q);
         tr != fsa.trans_end(q); ++tr) {
      invtrans[tr->to()].push_back(q);
    }
  }
}


template<typename Fsa>
void mark_accessible(const Fsa & fsa, int q, int * access) {
  
  typedef Fsa fsa_type;

  if (access[q] & ACCESS) { return; }
  access[q] |= ACCESS;
  
  for (typename fsa_type::const_trans_iterator tr = fsa.trans_begin(q);
       tr != fsa.trans_end(q); ++tr) {
    mark_accessible(fsa, tr->to(), access);
  }
}


void mark_coaccessible(std::vector<std::vector<int> > & invtrans, int q, int * access) {

  if (access[q] & COACCESS) { return; }
  access[q] |= COACCESS;

  for (int i = 0; i < invtrans[q].size(); ++i) {
    mark_coaccessible(invtrans, invtrans[q][i], access);
  }
}

template<typename FsaIn, typename FsaOut>
void fsa_prune(FsaIn & ifsa, FsaOut & ofsa) {

  typedef FsaIn ifsa_type;
  typedef FsaOut ofsa_type;

  ofsa.clear();

  int size = ifsa.size();
  if (size == 0) { return; }

  //std::vector<int> invtrans[size];
  std::vector<std::vector<int> > invtrans(size);

  fill_invtrans(ifsa, invtrans);

  int access[size];
  for (int q = 0; q < size; ++q) { access[q] = 0; }

  mark_accessible(ifsa, 0, access);

  for (int q = 0; q < size; ++q) {
    if (ifsa.final(q)) {
      mark_coaccessible(invtrans, q, access);
    }
  }

  int nbuseful = 0;

  for (int q = 0; q < size; ++q) {
    access[q] = (access[q] == USEFUL) ? nbuseful++ : -1;
  }

  /* access[q] = -1 if q is useless
   *           = new id of q in the resulting automaton otherwise
   */

  if (nbuseful == 0) { return; }

  ofsa.resize(nbuseful);

  for (int q = 0; q < size; ++q) {

    if (access[q] != -1) {
 
      //ofsa.data(access[q]) = ifsa.data(q);
 
      //      ofsa[access[q]] = ifsa[q]; // copy meta-data
      ofsa.set_data(access[q], ifsa.data(q)); // copy meta-data

      ofsa.set_final(access[q], ifsa.final(q));
 
      for (typename ifsa_type::const_trans_iterator tr = ifsa.trans_begin(q);
           tr != ifsa.trans_end(q); ++tr) {

        if (access[tr->to()] != -1) {
          ofsa.add_trans(access[q], tr->label(), access[tr->to()]);
        }
      }
    }
  }
}



template<typename FstIn, typename FstOut>
void fst_prune(FstIn & ifst, FstOut & ofst) {

  typedef FstIn ifst_type;
  typedef FstOut ofst_type;

  int size = ifst.size();
  if (size == 0) {
    ofst.clear(); return;
  }
  std::vector<int> invtrans[size];

  fill_invtrans(ifst, invtrans);

  int access[size];
  for (int q = 0; q < size; ++q) { access[q] = 0; }

  mark_accessible(ifst, 0, access);

  for (int q = 0; q < size; ++q) {
    if (ifst.final(q)) {
      mark_coaccessible(invtrans, q, access);
    }
  }

  int nbuseful = 0;

  for (int q = 0; q < size; ++q) {
    access[q] = (access[q] == USEFUL) ? nbuseful++ : -1;
  }

  /* access[q] = -1 if q is useless
   *           = new id of q in the resulting automaton otherwise
   */

  ofst.clear();
  if (nbuseful == 0) { return; }

  ofst.resize(nbuseful);

  for (int q = 0; q < size; ++q) {

    if (access[q] != -1) {
 
      ofst.set_final(access[q], ifst.final(q));
      ofst.final_outputs(access[q]).insert(ifst.final_outputs(q).begin(), ifst.final_outputs(q).end());
 
      for (typename ifst_type::const_trans_iterator tr = ifst.trans_begin(q);
           tr != ifst.trans_end(q); ++tr) {

        if (access[tr->to()] != -1) {
          ofst.add_trans(access[q], tr->label(), access[tr->to()]);
        }
      }
    }
  }
}
}; // namespace detail

template<typename FsaIn, typename FsaOut>
inline void fsa_prune(FsaIn & ifsa, FsaOut & ofsa) {
  detail::fsa_prune(ifsa, ofsa);
}

template<typename FSA>
inline void fsa_prune(FSA & fsa) {
  FSA res;
  fsa_prune(fsa, res);
  fsa.swap(res);
}

/* fst special version
 * to keep final_outputs
 */
template<typename FstIn, typename FstOut>
inline void fst_prune(FstIn & ifsa, FstOut & ofsa) {
  detail::fst_prune(ifsa, ofsa);
}

template<typename FST>
inline void fst_prune(FST & fst) {
  FST res;
  fst_prune(fst, res);
  fst.swap(res);
}

#endif
