#ifndef _FSA_DUMP_DOT_H_
#define _FSA_DUMP_DOT_H_


#include <iostream>
#include <sstream>
#include <boost/filesystem/path.hpp>
#include <boost/filesystem/fstream.hpp>
#include <outilex/escape.h>

template<typename Fsa>
void fsa_dump_dot(const Fsa & fsa, std::ostream & os) {

  os <<
    "# fsa dump output\n"
    "\n"
    "digraph G {\n"
    "\n"
    "  graph [ center=true, rankdir=LR ];\n"
    "  node  [ shape=circle ];\n";

  for (int q = 0; q < fsa.size(); ++q) {
    
    os << "\n  " << q << " [ label=" << q;
    if (fsa.final(q)) { os << " shape=doublecircle"; }
    os << " ];\n";
  
    typename Fsa::const_trans_iterator tr = fsa.trans_begin(q), end = fsa.trans_end(q);
    for (; tr != end; ++tr) {

      std::ostringstream label;
      label << tr->label();

      os << "  " << q << " -> " << tr->to()
        << " [ label=\"" << escape(label.str(), "\"") << "\" ];\n";
    }
  }
  os << "\n}\n";
}


template<typename Fsa>
void fsa_dump_dot(const Fsa & fsa, const boost::filesystem::path & path) {
  boost::filesystem::ofstream os(path);
  fsa_dump_dot(fsa, os);
}

template<typename Fst>
void fst_dump_dot(const Fst & fst, std::ostream & os) {

  os <<
    "# fst dump output\n"
    "\n"
    "digraph G {\n"
    "\n"
    "  graph [ center=true, orientation=landscape, rankdir=LR ];\n"
    "  node  [ shape=circle ];\n";

  for (int q = 0; q < fst.size(); ++q) {
    
    os << "\n  " << q << " [ label=" << q;
    if (fst.final(q)) { os << " shape=doublecircle"; }
    os << " ];\n";
 
    typename Fst::const_trans_iterator tr;
    for (tr = fst.trans_begin(q); tr != fst.trans_end(q); ++tr) {
      os << "  " << q << " -> " << tr->to() << " [ label=\"" << tr->in() << '/' << tr->out() << "\" ];\n";
    }
    
    typename Fst::outputs_type::const_iterator it;
    for (it = fst.final_outputs(q).begin(); it != fst.final_outputs(q).end(); ++it) {
      os << "  " << q << " -> T [ label=\"" << *it << "\" ];\n";   
    }
  }
  os << "\n  T [ label=T,shape=doublecircle ];\n";
  os << "\n}\n";
}

#endif

