#ifndef _FSA_DETERMINIZE_H_
#define _FSA_DETERMINIZE_H_

#if 0
#include <iostream>
#include <iterator>
#endif

#include <vector>
#include <set>
#include <map>

namespace detail {

#if 0
// for debugging

std::ostream & operator<<(std::ostream & os, const std::set<int> & id) {
  os << "{"; std::copy(id.begin(), id.end(), std::ostream_iterator<int>(os, ","));
  os << "}";
  return os;
}

template<typename T>
std::ostream & operator<<(std::ostream & os, const std::map<T, std::set<int> > & trans) {
  os << "[";
  for (typename std::map<T, std::set<int> >::const_iterator tr = trans.begin(); 
       tr != trans.end(); ++tr) {
    os << "(" << tr->first << ", " << tr->second << "), ";
  }
  os << "]";
  return os;
}
#endif

template<typename FsaIn, typename FsaOut>
class fsa_determinizer {

public:

  typedef FsaIn  ifsa_type;
  typedef FsaOut ofsa_type;

  typedef typename ifsa_type::label_type label_type;
  
  typedef std::set<int> stateid;
  typedef std::map<stateid, int> state_map;

  typedef std::map<label_type, stateid> ndeter_transitions;
  typedef typename ndeter_transitions::iterator ndeter_transition_iterator;

  const FsaIn & ifsa;
  FsaOut & ofsa;
  std::vector<ndeter_transitions> ndeter_trans;
  state_map states_id;


  fsa_determinizer(const FsaIn & in, FsaOut & out)
    : ifsa(in), ofsa(out), ndeter_trans(), states_id() {}


  void run() {

    ofsa.clear();

    if (ifsa.empty()) { return; }

    stateid id;
    id.insert(0);
    int q = add_state(id);

    std::vector<int> stack;
    stack.push_back(q);
    
    while (! stack.empty()) {

      q = stack.back(); stack.pop_back();

      if (ndeter_trans[q].empty()) { continue; }

      ndeter_transitions trans;
      trans.swap(ndeter_trans[q]); // we retrieve the trans because of iterator invalidation in add state

      ofsa.trans_reserve(q, trans.size());

      ndeter_transition_iterator tr = trans.begin(), end = trans.end();

      for (; tr != end; ++tr) {
        int to = add_state(tr->second);
        ofsa.add_trans(q, tr->first, to);
        stack.push_back(to);
      }
    }
  }


  int add_state(const stateid & id) {
    
    {
      state_map::iterator it = states_id.find(id);
      if (it != states_id.end()) { return it->second; }
    }

    int res = ofsa.add_state();
    ndeter_trans.resize(res + 1);

    states_id[id] = res;

    for (stateid::const_iterator it = id.begin(); it != id.end(); ++it) {
 
      int q = *it;

      if (ifsa.final(q)) { ofsa.set_final(res); }

      ofsa.merge_data(res, ifsa.data(q)); // merge meta-datas

      // init ndeter_transitions
      for (typename ifsa_type::const_trans_iterator tr = ifsa.trans_begin(q);
           tr != ifsa.trans_end(q); ++tr) {
        ndeter_trans[res][tr->label()].insert(tr->to());
      }
    }
    return res;
  }
};
} // namespace "detail"


template<typename FsaIn, typename FsaOut>
void fsa_determinize(const FsaIn & ifsa, FsaOut & ofsa) {
  detail::fsa_determinizer<FsaIn, FsaOut>(ifsa, ofsa).run();
}

template<typename FSA>
void fsa_determinize(FSA & fsa) {
  FSA res;
  fsa_determinize(fsa, res);
  res.swap(fsa);
}

#endif
