#ifndef _FSA_COPY_H_
#define _FSA_COPY_H_

#include <map>
#include <vector>

#include <outilex/wgb_color.h>

namespace detail {

template<typename FsaIn, typename FsaOut>
class copy_fsa {

public:
  typedef FsaIn  fsa_in;
  typedef FsaOut fsa_out;

  copy_fsa(const fsa_in & ifsa_, fsa_out & ofsa_)
    : ifsa(ifsa_), ofsa(ofsa_), state_map(), color() {}


protected:

  void run() {

    ofsa.clear();

    std::vector<int> s;

    add_state(0);
    s.push_back(0);

    while (! s.empty()) {
 
      int qi = s.back(); s.pop_back();

      info & inf = state_map[qi];

      if (inf.color == black) { continue; }

      for (typename fsa_in::const_trans_iterator tr = ifsa.trans_begin(qi);
           tr != ifsa.trans_end(qi); ++tr) {
 
        ofsa.add_trans(inf.qo, tr->label(), add_state(tr->to()));
        s.push_back(tr->to());
      }

      inf.color = black;
    }
  }


  int add_state(int qi) {
    
    info_map::iterator it = state_map.find(qi);
    if (it != state_map.end()) { return it->second.qo; }
    
    // new state
    
    int qo = ofsa.add_state(ifsa[qi]);
    ofsa.set_final(qo, ifsa[q].final(qi));

    state_map[qi] = info(qo, white);
    return qo;
  }

protected:

  const fsa_in & ifsa;
  fsa_out & ofsa;

  struct info {
    int qo;
    wgb_color color;
    info() : qo(0), color(white) {}
    info(int q, wgb_color c) : qo(q), color(c) {}
  };

  typedef std::map<int, info> info_map;
  info_map state_map;
};

} // namespace detail


template<typename FsaIn, typename FsaOut>
inline void fsa_copy(const FsaIn & ifsa, FsaOut & ofsa) {
  detail::copy_fsa<FsaIn, FsaOut>(ifsa, ofsa).run();
}

#endif
