#include <boost/filesystem/path.hpp>
#include <boost/filesystem/convenience.hpp>
#include <outilex/unitex_grf.h>

using namespace std;
namespace fs = boost::filesystem;

int main(int argc, char ** argv) try {

  if (argc != 2) {
    cerr << "usage: " << argv[0] << " <grf>\n"; 
    exit(1);
  }

  fs::path in(argv[1]);

  fs::path out = fs::change_extension(in, ".xgrf");

  if (in == out) {
    cerr << "bad argument (.xgrf extension)\n";
    exit(1);
  }

  unitex_grf grf(in);
  grf.write_xml(out);

} catch (exception & e) {
  cerr << "fatal error: " << e.what() << endl;
  exit(1);
}

