#include <map>
#include <vector>

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>

#include <outilex/wgb_color.h>
#include <outilex/generic_fst.h>
#include <outilex/unitex_grf.h>


using namespace std;
using namespace boost;
namespace fs = boost::filesystem;

#if 0
struct fst_info {
  wgb_color color;
  generic_fst fst;
};
#endif

namespace {

template<typename OutputIterator>
void lookup_subcall(const generic_fst & fst, OutputIterator out) {

  for (int q = 0; q < fst.size(); ++q) {
  
    for (generic_fst::const_trans_iterator tr = fst.trans_begin(q); tr != fst.trans_end(q); ++tr) {

      const std::string & label = tr->in();

      if (label.size() > 1 && label[0] == ':') {
        //cerr << "-> " << label << endl;
        if (label[label.size() - 1] == '$') {
          *out = label.substr(1, label.size() - 2);
        } else {
          *out = label.substr(1);
        }
        ++out;
      }
    }
  }
}



#if 0
generic_fst & flatten(const string & name, map<string, fst_info> & FSTs) {

  fst_info & info = FSTs[name];
  generic_fst & fst = info.fst;

  if (info.color == black) { return fst; }
  if (info.color == gray)  { throw runtime_error("flatten: subgraph call recursion detected"); }

  info.color = gray;


  for (int q1 = 0; q1 < fst.size(); ++q1) {
  
    for (generic_fst::trans_iterator tr = fst.trans_begin(q1); tr != fst.trans_end(q1); ++tr) {
    
      if (tr->in()[0] == ':') { // subgraph call
        
        // flatten the subgraph
        generic_fst & subfst = flatten(tr->in().substr(1), FSTs);

        int init2 = fst.size();
        
        /* make room */
        fst.resize(fst.size() + subfst.size());

        for (int q2 = 0; q2 < subfst.size(); ++q2) {

          for (generic_fst::trans_iterator tr2 = subfst.trans_begin(q2); tr2 != subfst.trans_end(q2); ++tr) {
            fst.add_trans(init2 + q2, tr2->in(), tr2->out(), init2 + tr2->to());
          }
          
          if (subfst.final(q2)) {
            fst.add_trans(init2 + q2, "<E>", "", tr->to());
          }
        }

        tr->to() = init2;
      }
    }
  }

  info.color = black;
  return fst;
}
#endif


int flatten(generic_fst & dest, const generic_fst & src, int to) {

  const int init = dest.size();

  /* if src is empty, create a useless state */

  if (src.empty()) {
    dest.resize(init + 1);
    return init;
  }

  dest.resize(init + src.size());

  for (int q = 0; q < src.size(); ++q) {
    
    for (generic_fst::const_trans_iterator tr = src.trans_begin(q); tr != src.trans_end(q); ++tr) {
      dest.add_trans(init + q, tr->in(), tr->out(), init + tr->to());
    }
 
    if (src.final(q)) {
      dest.add_trans(init + q, "<E>", "", to);
    }
  }
  return init;
}

} //namespace ""


bool flatten(generic_fst & fst, const fs::path & rootpath, int maxdepth) {

  map<string, generic_fst> FSTs; 

  vector<string> stack;
  lookup_subcall(fst, back_inserter(stack));

  int nbgraphs = 1;

  //cout << "loading graphs ...\n";
  while (! stack.empty()) {
  
    string name = stack.back(); stack.pop_back();
  
    if (FSTs.find(name) != FSTs.end()) { continue; }

    cerr << name << " ";

    generic_fst & fst = FSTs[name];

    fst.clear();

    //cerr <<  ' ' << name;
    for (int i = 0; i < name.size(); ++i) {
      if (name[i] == ':') { name[i] = '/'; }
    }

    fs::path curpath = rootpath / (name + ".gfst"); 

    if (fs::exists(curpath)) {

      fst.read(curpath);
 
    } else {
    
      curpath = rootpath / (name + ".grf8");

      if (fs::exists(curpath)) {
        unitex_grf grf(curpath);
        grf_to_generic_fst(grf, fst);
      } else {
        cerr << "error: graph '" << name << "' not found\n";
      }
    } 
 
    lookup_subcall(fst, back_inserter(stack));

    nbgraphs++;
    if ((nbgraphs % 100) == 0) {
      cout << nbgraphs << " graphs proceed ...\n";
    }
  }
  cerr << "\n";
  //cout << "done. total of " << nbgraphs << " graphs.\n";



  //cout << "flattening ...\n";

  int oldsize = 0, size = fst.size();

  while (maxdepth && oldsize < size) { // can add a max rec depth condition here

    cerr << "depth " << maxdepth << "\n";

    for (int q = oldsize; q < size; ++q) {

      for (int trno = 0; trno != fst.trans_size(q); ++trno) {

        generic_fst::transition & tr = fst.get_trans(q, trno);

        const string & label = tr.in();

        if (! label.empty() && label[0] == ':') { // subgraph call
 
          int len = label.size() - 1;
          if (label[len] == '$') { --len; }

          int to = flatten(fst, FSTs[label.substr(1, len)], tr.to());

          /* we retrieve a new ref to tr because flatten may have change its adress ... (sigh) */
          generic_fst::transition & tr2 = fst.get_trans(q, trno);
          tr2.to() = to;
          tr2.in() = "<E>";
        }
      }
    }

    oldsize = size;
    size = fst.size();
    --maxdepth;
  }

  if (size != oldsize) { // max depth reached

    cerr << "max depth reached\n";

    for (int q = oldsize; q < size; ++q) {

      generic_fst::transitions nouvo;

      nouvo.reserve(fst.trans_size(q));


      for (int trno = 0; trno != fst.trans_size(q); ++trno) {

        generic_fst::transition & tr = fst.get_trans(q, trno);

        const string & label = tr.in();

        if (label.empty() || label[0] == ':') { // subgraph call
          nouvo.push_back(tr);
        }
      }
      fst.states[q].trans.swap(nouvo);
    }
  }
  return size == oldsize;
}


