/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.unitex.io;

import fr.umlv.unitex.exceptions.NotAUnicodeLittleEndianFileException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class UnicodeIO {
    private static int toInt(byte by) {
        if (by >= 0) {
            return by;
        }
        return 256 + by;
    }

    public static int readCharRawly(FileInputStream fileInputStream) {
        byte[] byArray = new byte[2];
        try {
            if (fileInputStream.read(byArray) == -1) {
                return -1;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        char c = (char)(UnicodeIO.toInt(byArray[1]) * 256 + UnicodeIO.toInt(byArray[0]));
        return c;
    }

    public static int readChar(FileInputStream fileInputStream) {
        int n = UnicodeIO.readCharRawly(fileInputStream);
        if (n == 13) {
            UnicodeIO.readCharRawly(fileInputStream);
            n = 10;
        }
        return n;
    }

    public static String readLine(FileInputStream fileInputStream) {
        int n;
        String string = "";
        while ((n = UnicodeIO.readChar(fileInputStream)) != 10 && n != -1) {
            string = string + (char)n;
        }
        return string;
    }

    public static String readFirstLine(File file) {
        String string;
        if (!file.exists()) {
            return null;
        }
        if (!file.canRead()) {
            return null;
        }
        try {
            FileInputStream fileInputStream = UnicodeIO.openUnicodeLittleEndianFileInputStream(file);
            string = UnicodeIO.readLine(fileInputStream);
            fileInputStream.close();
        }
        catch (NotAUnicodeLittleEndianFileException notAUnicodeLittleEndianFileException) {
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return string;
    }

    public static void skipChars(FileInputStream fileInputStream, int n) {
        for (int i = 0; i < n; ++i) {
            UnicodeIO.readChar(fileInputStream);
        }
    }

    public static void skipLine(FileInputStream fileInputStream) {
        while (UnicodeIO.readChar(fileInputStream) != 10) {
        }
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static void writeChar(FileOutputStream fileOutputStream, char c) {
        byte[] byArray = new byte[2];
        byArray[1] = (byte)(c / 256);
        byArray[0] = (byte)(c % 256);
        if (c == '\n') {
            UnicodeIO.writeChar(fileOutputStream, '\r');
        }
        try {
            fileOutputStream.write(byArray[0]);
            fileOutputStream.write(byArray[1]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeString(FileOutputStream fileOutputStream, String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            UnicodeIO.writeChar(fileOutputStream, string.charAt(i));
        }
    }

    public static boolean isAUnicodeLittleEndianFile(File file) throws FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        boolean bl = UnicodeIO.readChar(fileInputStream) == 65279;
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }

    public static FileInputStream openUnicodeLittleEndianFileInputStream(File file) throws NotAUnicodeLittleEndianFileException, FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        if (UnicodeIO.readChar(fileInputStream) != 65279) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw new NotAUnicodeLittleEndianFileException();
        }
        return fileInputStream;
    }

    public static FileOutputStream openUnicodeLittleEndianFileOutputStream(File file) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        UnicodeIO.writeChar(fileOutputStream, '\ufeff');
        return fileOutputStream;
    }
}

