/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.unitex;

import fr.outilex.OutilexEnvironment;
import fr.umlv.unitex.GraphFrame;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class GraphSizeMenu
extends JDialog {
    SpecialNumericTextField Width = new SpecialNumericTextField(4, String.valueOf(0));
    SpecialNumericTextField Height = new SpecialNumericTextField(4, String.valueOf(0));
    static int resolutionDPI = Toolkit.getDefaultToolkit().getScreenResolution();
    static GraphSizeMenu pref;
    float X;
    float Y;
    static final int PIXELS = 1;
    static final int INCHES = 2;
    static final int CM = 3;
    static int unit;
    OutilexEnvironment env;
    GraphFrame graphFrame;

    public GraphSizeMenu(OutilexEnvironment outilexEnvironment) {
        super(outilexEnvironment.mainFrame, "Graph Size", true);
        this.env = outilexEnvironment;
        this.graphFrame = (GraphFrame)outilexEnvironment.contentPane.getSelectedComponent();
        pref = this;
        this.setContentPane(this.constructPanel());
        GraphFrame graphFrame = this.graphFrame;
        if (graphFrame == null) {
            return;
        }
        this.X = graphFrame.graphicalZone.Width;
        this.Y = graphFrame.graphicalZone.Height;
        this.Width.setText(this.stringValueOfX());
        this.Height.setText(this.stringValueOfY());
        unit = 1;
        this.pack();
        this.setResizable(false);
        pref = this;
        this.showMenu();
    }

    private float getValueOfX() {
        if (unit == 1) {
            return this.X;
        }
        if (unit == 2) {
            return this.X / (float)resolutionDPI;
        }
        return this.X * 24.0f / (float)resolutionDPI / 10.0f;
    }

    private float getValueOfY() {
        if (unit == 1) {
            return this.Y;
        }
        if (unit == 2) {
            return this.Y / (float)resolutionDPI;
        }
        return this.Y * 24.0f / (float)resolutionDPI / 10.0f;
    }

    String stringValueOfX() {
        if (unit == 1) {
            return String.valueOf((int)this.getValueOfX());
        }
        return String.valueOf((float)((int)(this.getValueOfX() * 100.0f)) / 100.0f);
    }

    String stringValueOfY() {
        if (unit == 1) {
            return String.valueOf((int)this.getValueOfY());
        }
        return String.valueOf((float)((int)(this.getValueOfY() * 100.0f)) / 100.0f);
    }

    public void showMenu() {
        this.setLocationRelativeTo(this.env.mainFrame);
        this.setVisible(true);
    }

    private JPanel constructPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)this.constructPanel1(), "North");
        jPanel.add((Component)this.constructDownPanel(), "Center");
        return jPanel;
    }

    private JPanel constructPanel1() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.add(new JLabel("Width : "));
        this.Width.setEditable(true);
        jPanel.add(this.Width);
        jPanel.add(new JLabel(" x Height : "));
        this.Height.setEditable(true);
        jPanel.add(this.Height);
        return jPanel;
    }

    private JPanel constructDownPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.constructPanel2(), "West");
        jPanel.add((Component)this.constructPanel3(), "Center");
        return jPanel;
    }

    private JPanel constructPanel2() {
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.add(new JLabel("Unit :"));
        final Choice choice = new Choice();
        choice.addItem("Pixels");
        choice.addItem("Inches");
        choice.addItem("Cm");
        choice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                float f;
                float f2;
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                try {
                    f2 = new Float(GraphSizeMenu.this.Width.getText()).floatValue();
                    f = new Float(GraphSizeMenu.this.Height.getText()).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, "Invalid value", "Error", 0);
                    return;
                }
                if (unit == 1) {
                    GraphSizeMenu.this.X = f2;
                    GraphSizeMenu.this.Y = f;
                } else if (unit == 2) {
                    GraphSizeMenu.this.X = f2 * (float)resolutionDPI;
                    GraphSizeMenu.this.Y = f * (float)resolutionDPI;
                } else {
                    GraphSizeMenu.this.X = (float)((double)(f2 * (float)resolutionDPI) / 2.4);
                    GraphSizeMenu.this.Y = (float)((double)(f * (float)resolutionDPI) / 2.4);
                }
                unit = choice.getSelectedIndex() + 1;
                GraphSizeMenu.this.Width.setText(GraphSizeMenu.this.stringValueOfX());
                GraphSizeMenu.this.Height.setText(GraphSizeMenu.this.stringValueOfY());
                GraphSizeMenu.this.repaint();
            }
        });
        choice.select(0);
        jPanel.add(choice);
        AbstractAction abstractAction = new AbstractAction("Set to A4"){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphSizeMenu.this.X = (float)(29.7 * (double)resolutionDPI / 2.4);
                GraphSizeMenu.this.Y = (float)((double)(21 * resolutionDPI) / 2.4);
                GraphSizeMenu.this.Width.setText(GraphSizeMenu.this.stringValueOfX());
                GraphSizeMenu.this.Height.setText(GraphSizeMenu.this.stringValueOfY());
                GraphSizeMenu.this.repaint();
            }
        };
        JButton jButton = new JButton(abstractAction);
        jPanel.add(jButton);
        return jPanel;
    }

    private JPanel constructPanel3() {
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.constructButtonPanel();
        jPanel.add(new JLabel("Orientation :"));
        AbstractAction abstractAction = new AbstractAction("Portrait/Landscape"){

            public void actionPerformed(ActionEvent actionEvent) {
                float f = GraphSizeMenu.this.X;
                GraphSizeMenu.this.X = GraphSizeMenu.this.Y;
                GraphSizeMenu.this.Y = f;
                GraphSizeMenu.this.Width.setText(GraphSizeMenu.this.stringValueOfX());
                GraphSizeMenu.this.Height.setText(GraphSizeMenu.this.stringValueOfY());
                GraphSizeMenu.this.repaint();
            }
        };
        JButton jButton = new JButton(abstractAction);
        jPanel.add(jButton);
        jPanel.add(this.constructButtonPanel());
        return jPanel;
    }

    private JPanel constructButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        AbstractAction abstractAction = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent actionEvent) {
                float f;
                float f2;
                try {
                    f2 = new Float(GraphSizeMenu.this.Width.getText()).floatValue();
                    f = new Float(GraphSizeMenu.this.Height.getText()).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(null, "Invalid value", "Error", 0);
                    return;
                }
                if (unit == 1) {
                    GraphSizeMenu.this.X = f2;
                    GraphSizeMenu.this.Y = f;
                } else if (unit == 2) {
                    GraphSizeMenu.this.X = f2 * (float)resolutionDPI;
                    GraphSizeMenu.this.Y = f * (float)resolutionDPI;
                } else {
                    GraphSizeMenu.this.X = (float)((double)(f2 * (float)resolutionDPI) / 2.4);
                    GraphSizeMenu.this.Y = (float)((double)(f * (float)resolutionDPI) / 2.4);
                }
                GraphFrame graphFrame = GraphSizeMenu.this.graphFrame;
                graphFrame.reSizeGraphicalZone((int)GraphSizeMenu.this.X, (int)GraphSizeMenu.this.Y);
                graphFrame.setModified(true);
                pref.setVisible(false);
            }
        };
        JButton jButton = new JButton(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent actionEvent) {
                pref.setVisible(false);
            }
        };
        JButton jButton2 = new JButton(abstractAction2);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    static {
        unit = 1;
    }

    class SpecialNumericTextDocument
    extends PlainDocument {
        SpecialNumericTextDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if ((cArray[i] < '0' || cArray[i] > '9') && cArray[i] != '.') {
                    return;
                }
                if (unit != 1 || cArray[i] != '.') continue;
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }

    class SpecialNumericTextField
    extends JTextField {
        SpecialNumericTextField(int n, String string) {
            super(n);
            this.setEditable(true);
            this.setText(string);
            this.setEditable(false);
        }

        public Document createDefaultModel() {
            return new SpecialNumericTextDocument();
        }
    }
}

