/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.unitex;

import fr.umlv.unitex.GenericGraphBox;
import fr.umlv.unitex.GraphBoxInfo;
import fr.umlv.unitex.GraphFrame;
import fr.umlv.unitex.MultipleSelection;
import fr.umlv.unitex.Preferences;
import fr.umlv.unitex.TextField;
import fr.umlv.unitex.undo.AddBoxeEdit;
import fr.umlv.unitex.undo.BoxeGroupTextEdit;
import fr.umlv.unitex.undo.BoxeTextEdit;
import fr.umlv.unitex.undo.DeleteBoxGroupEdit;
import fr.umlv.unitex.undo.SelectEdit;
import fr.umlv.unitex.undo.TransitionEdit;
import fr.umlv.unitex.undo.TransitionGroupEdit;
import fr.umlv.unitex.undo.TranslationEdit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public abstract class GenericGraphicalZone
extends JComponent {
    public boolean modified = false;
    public int Width;
    public int Height;
    public JTextField texte;
    public JTextField outText;
    public ArrayList selectedBoxes;
    public ArrayList graphBoxes;
    protected boolean is_initialised = false;
    public boolean isGrid = false;
    public int nPixels = 30;
    public Preferences pref = new Preferences();
    public JComponent parentFrame;
    protected UndoableEditSupport support = new UndoableEditSupport();
    public double scaleFactor = 1.0;
    protected int Xmouse;
    protected int Ymouse;
    protected boolean mouseInGraphicalZone = false;
    private Rectangle clipZone;
    public int EDITING_MODE = 0;
    public static int NORMAL_OUTPUT = 0;
    public static int UNIF_OUTPUT = 1;
    public int OUTPUT_STYLE = UNIF_OUTPUT;
    protected int X_start_drag;
    protected int Y_start_drag;
    protected int X_end_drag;
    protected int Y_end_drag;
    protected int X_drag;
    protected int Y_drag;
    protected int dragWidth;
    protected int dragHeight;
    protected boolean selecting = false;
    protected boolean dragging = false;
    protected boolean singleDragging = false;
    protected GenericGraphBox singleDraggedBox;

    public GenericGraphicalZone(int n, int n2, JTextField jTextField, JTextField jTextField2, JComponent jComponent) {
        this.Width = n;
        this.Height = n2;
        this.texte = jTextField;
        this.outText = jTextField2;
        this.parentFrame = jComponent;
        this.texte.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                ((GraphFrame)GenericGraphicalZone.this.parentFrame).setRedoEnabled(false);
                ((GraphFrame)GenericGraphicalZone.this.parentFrame).setUndoEnabled(false);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
            }
        });
        this.outText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                ((GraphFrame)GenericGraphicalZone.this.parentFrame).setRedoEnabled(false);
                ((GraphFrame)GenericGraphicalZone.this.parentFrame).setUndoEnabled(false);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
            }
        });
        this.selectedBoxes = new ArrayList();
        this.graphBoxes = new ArrayList();
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.texte.setEditable(false);
        this.pref = Preferences.pref.getClone();
    }

    protected abstract void init();

    public void addBox(GenericGraphBox genericGraphBox) {
        if (this.graphBoxes.size() >= 2) {
            AddBoxeEdit addBoxeEdit = new AddBoxeEdit(genericGraphBox, this.graphBoxes, this);
            this.postEdit(addBoxeEdit);
        }
        this.graphBoxes.add(genericGraphBox);
    }

    protected abstract GenericGraphBox createBox(int var1, int var2);

    protected abstract GenericGraphBox newBox(int var1, int var2, int var3, GenericGraphicalZone var4);

    public void pasteSelection(MultipleSelection multipleSelection) {
        GenericGraphBox genericGraphBox;
        GraphBoxInfo graphBoxInfo;
        int n;
        ArrayList arrayList = multipleSelection.elem;
        this.unSelectAllBoxes();
        for (n = 0; n < arrayList.size(); ++n) {
            graphBoxInfo = (GraphBoxInfo)arrayList.get(n);
            genericGraphBox = this.createBox(graphBoxInfo.X + 20 * multipleSelection.n, graphBoxInfo.Y + 20 * multipleSelection.n);
            genericGraphBox.setContent(graphBoxInfo.content, graphBoxInfo.transduction);
            genericGraphBox.selected = true;
            this.selectedBoxes.add(genericGraphBox);
        }
        for (n = 0; n < this.selectedBoxes.size(); ++n) {
            genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(n);
            graphBoxInfo = (GraphBoxInfo)arrayList.get(n);
            Vector vector = graphBoxInfo.reachableBoxes;
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                Integer n3 = (Integer)vector.get(i);
                genericGraphBox.addTransitionTo((GenericGraphBox)this.selectedBoxes.get(n3));
            }
        }
        this.setModified(true);
        this.initText("", "");
        this.repaint();
    }

    public void initText(String string, String string2) {
        if (this.texte instanceof TextField) {
            ((TextField)this.outText).initText(string2);
            ((TextField)this.texte).initText(string);
        }
    }

    public void validateTextField() {
        if (this.texte instanceof TextField) {
            ((TextField)this.texte).validateTextField();
        }
    }

    public void setModified(boolean bl) {
        if (this.parentFrame instanceof GraphFrame) {
            ((GraphFrame)this.parentFrame).setModified(bl);
        }
    }

    public void removeTransitionTo(GenericGraphBox genericGraphBox) {
        if (this.graphBoxes.isEmpty()) {
            return;
        }
        int n = this.graphBoxes.size();
        for (int i = 0; i < n; ++i) {
            GenericGraphBox genericGraphBox2 = (GenericGraphBox)this.graphBoxes.get(i);
            int n2 = genericGraphBox2.transitions.indexOf(genericGraphBox);
            if (n2 == -1) continue;
            genericGraphBox2.transitions.remove(n2);
        }
    }

    public ArrayList getTransitionTo(GenericGraphBox genericGraphBox) {
        ArrayList<GenericGraphBox> arrayList = new ArrayList<GenericGraphBox>();
        if (this.graphBoxes.isEmpty()) {
            return null;
        }
        int n = this.graphBoxes.size();
        for (int i = 0; i < n; ++i) {
            GenericGraphBox genericGraphBox2 = (GenericGraphBox)this.graphBoxes.get(i);
            int n2 = genericGraphBox2.transitions.indexOf(genericGraphBox);
            if (n2 == -1) continue;
            arrayList.add(genericGraphBox2);
        }
        return arrayList;
    }

    public void removeTransitionsToSelected() {
        if (this.selectedBoxes.isEmpty()) {
            return;
        }
        int n = this.selectedBoxes.size();
        for (int i = 0; i < n; ++i) {
            GenericGraphBox genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(i);
            if (genericGraphBox.type != 2) continue;
            this.removeTransitionTo(genericGraphBox);
        }
    }

    public void removeSelected() {
        if (this.selectedBoxes.isEmpty()) {
            return;
        }
        int n = this.selectedBoxes.size();
        DeleteBoxGroupEdit deleteBoxGroupEdit = new DeleteBoxGroupEdit(this.selectedBoxes, this.graphBoxes, this);
        this.postEdit(deleteBoxGroupEdit);
        for (int i = 0; i < n; ++i) {
            GenericGraphBox genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(i);
            if (genericGraphBox.type == 2) {
                this.graphBoxes.remove(genericGraphBox);
            }
            this.removeTransitionsToSelected();
        }
        this.unSelectAllBoxes();
        this.repaint();
    }

    public void setTextForSelected(String string, String string2) {
        if (this.selectedBoxes.isEmpty()) {
            return;
        }
        if (string.equals("")) {
            this.removeSelected();
            return;
        }
        int n = this.selectedBoxes.size();
        if (n == 1) {
            GenericGraphBox genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(0);
            BoxeTextEdit boxeTextEdit = new BoxeTextEdit(genericGraphBox, string, string2, this);
            this.postEdit(boxeTextEdit);
            genericGraphBox.setContent(string, string2);
        } else {
            BoxeGroupTextEdit boxeGroupTextEdit = new BoxeGroupTextEdit(this.selectedBoxes, string, string2, this);
            this.postEdit(boxeGroupTextEdit);
            for (int i = 0; i < n; ++i) {
                GenericGraphBox genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(i);
                genericGraphBox.setContent(string, string2);
            }
        }
    }

    public int getSelectedBox(int n, int n2) {
        int n3 = this.graphBoxes.size();
        for (int i = 0; i < n3; ++i) {
            GenericGraphBox genericGraphBox = (GenericGraphBox)this.graphBoxes.get(i);
            if (n < genericGraphBox.x || n > genericGraphBox.x + genericGraphBox.Width || n2 < genericGraphBox.Y1 || n2 > genericGraphBox.Y1 + genericGraphBox.Height) continue;
            return i;
        }
        return -1;
    }

    public void unSelectAllBoxes() {
        while (!this.selectedBoxes.isEmpty()) {
            GenericGraphBox genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(0);
            genericGraphBox.selected = false;
            this.selectedBoxes.remove(0);
        }
        this.texte.setEditable(false);
    }

    public void selectAllBoxes() {
        this.unSelectAllBoxes();
        int n = this.graphBoxes.size();
        for (int i = 0; i < n; ++i) {
            GenericGraphBox genericGraphBox = (GenericGraphBox)this.graphBoxes.get(i);
            genericGraphBox.selected = true;
            this.selectedBoxes.add(genericGraphBox);
            this.initText(genericGraphBox.content, genericGraphBox.transduction);
        }
        this.texte.setEditable(false);
        this.repaint();
    }

    public void selectByRectangle(int n, int n2, int n3, int n4) {
        int n5 = this.graphBoxes.size();
        for (int i = 0; i < n5; ++i) {
            GenericGraphBox genericGraphBox = (GenericGraphBox)this.graphBoxes.get(i);
            if (!genericGraphBox.isSelectedByRectangle(n, n2, n3, n4)) continue;
            genericGraphBox.selected = true;
            this.selectedBoxes.add(genericGraphBox);
            this.initText(genericGraphBox.content, genericGraphBox.transduction);
        }
        if (!this.selectedBoxes.isEmpty()) {
            SelectEdit selectEdit = new SelectEdit(this.selectedBoxes);
            this.postEdit(selectEdit);
        }
    }

    public void translateAllSelectedBoxes(int n, int n2) {
        if (this.selectedBoxes.isEmpty()) {
            return;
        }
        int n3 = this.selectedBoxes.size();
        for (int i = 0; i < n3; ++i) {
            GenericGraphBox genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(i);
            genericGraphBox.translate(n, n2);
        }
    }

    public void addTransitionsFromSelectedBoxes(GenericGraphBox genericGraphBox, boolean bl) {
        if (this.selectedBoxes.isEmpty()) {
            return;
        }
        int n = this.selectedBoxes.size();
        if (bl) {
            TransitionGroupEdit transitionGroupEdit = new TransitionGroupEdit(this.selectedBoxes, genericGraphBox, this);
            this.postEdit(transitionGroupEdit);
        }
        for (int i = 0; i < n; ++i) {
            GenericGraphBox genericGraphBox2 = (GenericGraphBox)this.selectedBoxes.get(i);
            genericGraphBox2.addTransitionTo(genericGraphBox);
        }
    }

    public void addReverseTransitionsFromSelectedBoxes(GenericGraphBox genericGraphBox) {
        if (this.selectedBoxes.isEmpty()) {
            return;
        }
        int n = this.selectedBoxes.size();
        for (int i = 0; i < n; ++i) {
            GenericGraphBox genericGraphBox2 = (GenericGraphBox)this.selectedBoxes.get(i);
            TransitionEdit transitionEdit = new TransitionEdit(genericGraphBox, genericGraphBox2);
            this.postEdit(transitionEdit);
            genericGraphBox.addTransitionTo(genericGraphBox2);
        }
    }

    public void drawAllTransitions(Graphics2D graphics2D) {
        if (this.graphBoxes.isEmpty()) {
            return;
        }
        int n = this.graphBoxes.size();
        for (int i = 0; i < n; ++i) {
            GenericGraphBox genericGraphBox = (GenericGraphBox)this.graphBoxes.get(i);
            genericGraphBox.drawTransitions(graphics2D);
        }
    }

    public void drawTransitionsFromMousePointerToSelectedBoxes(Graphics2D graphics2D) {
        GenericGraphBox genericGraphBox = this.newBox(this.Xmouse, this.Ymouse, 2, this);
        genericGraphBox.X_out = this.Xmouse;
        genericGraphBox.Y_out = this.Ymouse;
        int n = this.selectedBoxes.size();
        for (int i = 0; i < n; ++i) {
            GenericGraphBox genericGraphBox2 = (GenericGraphBox)this.selectedBoxes.get(i);
            genericGraphBox.drawTransition(graphics2D, genericGraphBox2);
        }
    }

    public void drawTransitionsFromSelectedBoxesToMousePointer(Graphics2D graphics2D) {
        GenericGraphBox genericGraphBox = this.newBox(this.Xmouse, this.Ymouse, 2, this);
        genericGraphBox.X_out = this.Xmouse;
        genericGraphBox.Y_out = this.Ymouse;
        int n = this.selectedBoxes.size();
        for (int i = 0; i < n; ++i) {
            GenericGraphBox genericGraphBox2 = (GenericGraphBox)this.selectedBoxes.get(i);
            genericGraphBox2.drawTransition(graphics2D, genericGraphBox);
        }
    }

    public void drawAllBoxes(Graphics2D graphics2D) {
        if (this.graphBoxes.isEmpty()) {
            return;
        }
        int n = this.graphBoxes.size();
        for (int i = 0; i < n; ++i) {
            GenericGraphBox genericGraphBox = (GenericGraphBox)this.graphBoxes.get(i);
            genericGraphBox.draw(graphics2D);
        }
    }

    public void drawGrid(Graphics2D graphics2D) {
        if (!this.isGrid) {
            return;
        }
        graphics2D.setColor(this.pref.foregroundColor);
        for (int i = 10; i < this.Width - 10; i += this.nPixels) {
            for (int j = 10; j < this.Height - 10; j += this.nPixels) {
                graphics2D.drawLine(i, j, i + 1, j);
            }
        }
    }

    public void HTopAlign() {
        int n;
        if (this.selectedBoxes.isEmpty()) {
            return;
        }
        GenericGraphBox genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(0);
        int n2 = genericGraphBox.Y1;
        for (n = 1; n < this.selectedBoxes.size(); ++n) {
            genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(n);
            if (genericGraphBox.Y1 >= n2) continue;
            n2 = genericGraphBox.Y1;
        }
        for (n = 0; n < this.selectedBoxes.size(); ++n) {
            genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(n);
            int n3 = n2 - genericGraphBox.Y1;
            TranslationEdit translationEdit = new TranslationEdit(genericGraphBox, 0, n3);
            this.postEdit(translationEdit);
            genericGraphBox.translate(0, n3);
        }
        this.repaint();
    }

    public void HCenterAlign() {
        GenericGraphBox genericGraphBox;
        int n;
        if (this.selectedBoxes.isEmpty()) {
            return;
        }
        if (this.selectedBoxes.isEmpty()) {
            return;
        }
        int n2 = 0;
        for (n = 0; n < this.selectedBoxes.size(); ++n) {
            genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(n);
            n2 += genericGraphBox.Y;
        }
        n2 /= this.selectedBoxes.size();
        for (n = 0; n < this.selectedBoxes.size(); ++n) {
            genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(n);
            int n3 = n2 - genericGraphBox.Y;
            TranslationEdit translationEdit = new TranslationEdit(genericGraphBox, 0, n3);
            this.postEdit(translationEdit);
            genericGraphBox.translate(0, n3);
        }
        this.repaint();
    }

    public void HBottomAlign() {
        int n;
        if (this.selectedBoxes.isEmpty()) {
            return;
        }
        GenericGraphBox genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(0);
        int n2 = genericGraphBox.Y1 + genericGraphBox.Height;
        for (n = 1; n < this.selectedBoxes.size(); ++n) {
            genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(n);
            if (genericGraphBox.Y1 + genericGraphBox.Height <= n2) continue;
            n2 = genericGraphBox.Y1 + genericGraphBox.Height;
        }
        for (n = 0; n < this.selectedBoxes.size(); ++n) {
            genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(n);
            int n3 = n2 - (genericGraphBox.Y1 + genericGraphBox.Height);
            TranslationEdit translationEdit = new TranslationEdit(genericGraphBox, 0, n3);
            this.postEdit(translationEdit);
            genericGraphBox.translate(0, n3);
        }
        this.repaint();
    }

    public void VLeftAlign() {
        int n;
        if (this.selectedBoxes.isEmpty()) {
            return;
        }
        GenericGraphBox genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(0);
        int n2 = genericGraphBox.X1;
        for (n = 1; n < this.selectedBoxes.size(); ++n) {
            genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(n);
            if (genericGraphBox.X1 >= n2) continue;
            n2 = genericGraphBox.X1;
        }
        for (n = 0; n < this.selectedBoxes.size(); ++n) {
            genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(n);
            int n3 = n2 - genericGraphBox.X1;
            TranslationEdit translationEdit = new TranslationEdit(genericGraphBox, n3, 0);
            this.postEdit(translationEdit);
            genericGraphBox.translate(n3, 0);
        }
        this.repaint();
    }

    public void VCenterAlign() {
        int n;
        if (this.selectedBoxes.isEmpty()) {
            return;
        }
        GenericGraphBox genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(0);
        int n2 = 0;
        for (n = 0; n < this.selectedBoxes.size(); ++n) {
            genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(n);
            n2 += genericGraphBox.X1 + genericGraphBox.Width / 2;
        }
        n2 /= this.selectedBoxes.size();
        for (n = 0; n < this.selectedBoxes.size(); ++n) {
            genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(n);
            int n3 = n2 - (genericGraphBox.X1 + genericGraphBox.Width / 2);
            TranslationEdit translationEdit = new TranslationEdit(genericGraphBox, n3, 0);
            this.postEdit(translationEdit);
            genericGraphBox.translate(n3, 0);
        }
        this.repaint();
    }

    public void VRightAlign() {
        int n;
        if (this.selectedBoxes.isEmpty()) {
            return;
        }
        GenericGraphBox genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(0);
        int n2 = genericGraphBox.X1 + genericGraphBox.Width;
        for (n = 1; n < this.selectedBoxes.size(); ++n) {
            genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(n);
            if (genericGraphBox.X1 + genericGraphBox.Width <= n2) continue;
            n2 = genericGraphBox.X1 + genericGraphBox.Width;
        }
        for (n = 0; n < this.selectedBoxes.size(); ++n) {
            genericGraphBox = (GenericGraphBox)this.selectedBoxes.get(n);
            int n3 = n2 - (genericGraphBox.X1 + genericGraphBox.Width);
            TranslationEdit translationEdit = new TranslationEdit(genericGraphBox, n3, 0);
            this.postEdit(translationEdit);
            genericGraphBox.translate(n3, 0);
        }
        this.repaint();
    }

    public void setGrid(boolean bl) {
        this.isGrid = bl;
        this.repaint();
    }

    public void setGrid(boolean bl, int n) {
        this.isGrid = bl;
        this.nPixels = n;
        this.repaint();
    }

    public void updateAllBoxes() {
        for (int i = 0; i < this.graphBoxes.size(); ++i) {
            GenericGraphBox genericGraphBox = (GenericGraphBox)this.graphBoxes.get(i);
            genericGraphBox.update();
        }
        this.repaint();
    }

    public void setRightToLeft(boolean bl) {
        this.pref.rightToLeft = bl;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.support.addUndoableEditListener(undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.support.removeUndoableEditListener(undoableEditListener);
    }

    public void postEdit(UndoableEdit undoableEdit) {
        this.support.postEdit(undoableEdit);
        this.parentFrame.repaint();
    }

    public ArrayList getSelectedBoxes() {
        return this.selectedBoxes;
    }

    public Rectangle getClipZone() {
        return this.clipZone;
    }

    public void setClipZone(Rectangle rectangle) {
        this.clipZone = rectangle;
    }
}

