/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.unitex;

import fr.umlv.unitex.GenericGraphicalZone;
import fr.umlv.unitex.GraphFrame;
import fr.umlv.unitex.GraphicalToolBox;
import fr.umlv.unitex.Preferences;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.io.File;
import java.util.ArrayList;

public abstract class GenericGraphBox {
    public int x;
    public int Y;
    public int type;
    public static final int INITIAL = 0;
    public static final int FINAL = 1;
    public static final int NORMAL = 2;
    public static double NULL_WEIGHT = 0.0;
    public boolean variable;
    public boolean selected;
    public boolean comment;
    public boolean hasOutgoingTransitions;
    public int hasIncomingTransitions;
    public boolean singleDragging;
    public int X_in;
    public int Y_in;
    public int X_out;
    public int Y_out;
    public String content;
    public ArrayList lines;
    public ArrayList greyed;
    public String transduction;
    public int n_lignes;
    public int X1;
    public int Y1;
    public int Width;
    public int Height;
    public int h_ligne;
    public int descent;
    public GenericGraphicalZone parentGraphicalZone;
    public ArrayList transitions;
    public static Font variableFont = new Font("Times New Roman", 1, 30);
    public Graphics2D context;
    public int identificationNumber;

    public GenericGraphBox(int n, int n2, int n3, GenericGraphicalZone genericGraphicalZone) {
        this.x = n;
        this.Y = n2;
        this.parentGraphicalZone = genericGraphicalZone;
        this.type = n3;
        this.content = "<E>";
        this.transduction = "";
        this.variable = false;
        this.n_lignes = 0;
        this.h_ligne = 15;
        this.lines = new ArrayList();
        this.greyed = new ArrayList();
        this.transitions = new ArrayList();
        this.Width = 15;
        this.Height = 20;
        if (n3 == 1) {
            this.X_in = n;
            this.Y_in = this.Y;
            this.X1 = n;
            this.Y1 = this.Y - 10;
            this.Y_out = this.Y_in;
            this.X_out = this.X_in + 25;
        } else {
            this.X1 = n;
            this.Y1 = this.Y;
            this.X_in = n;
            this.Y_in = this.Y;
            this.X_out = n + this.Width + 5;
            this.Y_out = this.Y_in;
        }
        this.selected = false;
        this.singleDragging = false;
        this.comment = true;
        this.hasOutgoingTransitions = false;
        this.hasIncomingTransitions = 0;
        this.identificationNumber = -1;
    }

    public File getGraphClicked(int n) {
        int n2 = (n - this.Y1 - 4) / this.h_ligne;
        Boolean bl = (Boolean)this.greyed.get(n2);
        if (bl.booleanValue()) {
            File file;
            String string = (String)this.lines.get(n2);
            if (!string.endsWith(".grf")) {
                string = string + ".grf";
            }
            if (!(file = new File(string)).isAbsolute()) {
                file = new File(((GraphFrame)this.parentGraphicalZone.parentFrame).getGraph().getParentFile(), string);
            }
            return file;
        }
        return null;
    }

    public void addTransitionTo(GenericGraphBox genericGraphBox) {
        if (this.type == 1) {
            return;
        }
        int n = this.transitions.indexOf(genericGraphBox);
        if (n == -1) {
            this.transitions.add(genericGraphBox);
            ++genericGraphBox.hasIncomingTransitions;
        } else {
            this.transitions.remove(n);
            --genericGraphBox.hasIncomingTransitions;
        }
        this.hasOutgoingTransitions = !this.transitions.isEmpty();
        this.comment = !this.hasOutgoingTransitions && this.hasIncomingTransitions == 0;
        genericGraphBox.comment = !genericGraphBox.hasOutgoingTransitions && genericGraphBox.hasIncomingTransitions == 0;
    }

    public void onlyAddTransitionTo(GenericGraphBox genericGraphBox) {
        if (this.type == 1) {
            return;
        }
        int n = this.transitions.indexOf(genericGraphBox);
        if (n == -1) {
            this.transitions.add(genericGraphBox);
            ++genericGraphBox.hasIncomingTransitions;
        }
        this.hasOutgoingTransitions = !this.transitions.isEmpty();
        this.comment = !this.hasOutgoingTransitions && this.hasIncomingTransitions == 0;
        genericGraphBox.comment = !genericGraphBox.hasOutgoingTransitions && genericGraphBox.hasIncomingTransitions == 0;
    }

    public void removeTransitionTo(GenericGraphBox genericGraphBox) {
        int n = this.transitions.indexOf(genericGraphBox);
        if (n != -1) {
            this.transitions.remove(n);
            --genericGraphBox.hasIncomingTransitions;
        }
        this.hasOutgoingTransitions = !this.transitions.isEmpty();
        this.comment = !this.hasOutgoingTransitions && this.hasIncomingTransitions == 0;
        genericGraphBox.comment = !genericGraphBox.hasOutgoingTransitions && genericGraphBox.hasIncomingTransitions == 0;
    }

    public void translate(int n, int n2) {
        this.x += n;
        this.Y += n2;
        this.X_in += n;
        this.Y_in += n2;
        this.X_out += n;
        this.Y_out += n2;
        this.X1 += n;
        this.Y1 += n2;
    }

    public boolean isSelectedByRectangle(int n, int n2, int n3, int n4) {
        return this.X1 <= n + n3 && this.X1 + this.Width >= n && this.Y1 <= n2 + n4 && this.Y1 + this.Height >= n2;
    }

    public void drawTransition(Graphics2D graphics2D, GenericGraphBox genericGraphBox) {
        Preferences preferences = this.parentGraphicalZone == null ? Preferences.pref : this.parentGraphicalZone.pref;
        if (!preferences.rightToLeft) {
            if (genericGraphBox.X_in > this.X_out) {
                GraphicalToolBox.drawLine(graphics2D, this.X_out, this.Y_out, genericGraphBox.X_in, genericGraphBox.Y_in);
                return;
            }
            if (this.equals(genericGraphBox)) {
                int n = 10 + this.Height / 2;
                GraphicalToolBox.drawArc(graphics2D, this.X_out - n / 2, this.Y_out - n, n, n, 90, -180);
                GraphicalToolBox.drawArc(graphics2D, genericGraphBox.X_in - n / 2, genericGraphBox.Y_in - n, n, n, 90, 180);
                GraphicalToolBox.drawLine(graphics2D, this.X_in, this.Y_in - n, this.X_out, this.Y_out - n);
                return;
            }
            if (this.Y1 < genericGraphBox.Y1 + genericGraphBox.Height && this.Y1 + this.Height > genericGraphBox.Y1) {
                int n = 10 + this.Height / 2;
                GraphicalToolBox.drawArc(graphics2D, this.X_out - n / 2, this.Y_out - n, n, n, 90, -180);
                int n2 = 10 + genericGraphBox.Height / 2;
                GraphicalToolBox.drawArc(graphics2D, genericGraphBox.X_in - n2 / 2, genericGraphBox.Y_in - n2, n2, n2, 90, 180);
                int n3 = genericGraphBox.X_in;
                int n4 = genericGraphBox.Y_in - n2;
                int n5 = this.X_out;
                int n6 = this.Y_out - n;
                int n7 = (n5 + n3) / 2;
                int n8 = (n6 + n4) / 2;
                int n9 = n + n2;
                GraphicalToolBox.drawCurve(graphics2D, n3, n4, n3 + n9, n4, n7, n8);
                GraphicalToolBox.drawCurve(graphics2D, n5, n6, n5 - n9, n6, n7, n8);
                return;
            }
            if (this.Y1 < genericGraphBox.Y1 + genericGraphBox.Height) {
                int n = 10 + this.Height / 2;
                GraphicalToolBox.drawArc(graphics2D, this.X_out - n / 2, this.Y_out, n, n, 0, 90);
                int n10 = 10 + genericGraphBox.Height / 2;
                GraphicalToolBox.drawArc(graphics2D, genericGraphBox.X_in - n10 / 2, genericGraphBox.Y_in - n10, n10, n10, 180, 90);
                int n11 = genericGraphBox.X_in - n10 / 2;
                int n12 = genericGraphBox.Y_in - n10 / 2;
                int n13 = this.X_out + 1 + n / 2;
                int n14 = this.Y_out + 1 + n / 2;
                int n15 = n + n10 - 20;
                int n16 = (n13 + n11) / 2;
                int n17 = (n14 + n12) / 2;
                GraphicalToolBox.drawCurve(graphics2D, n11, n12, n11, n12 - n15, n16, n17);
                GraphicalToolBox.drawCurve(graphics2D, n13, n14, n13, n14 + n15, n16, n17);
                return;
            }
            int n = 10 + this.Height / 2;
            GraphicalToolBox.drawArc(graphics2D, this.X_out - n / 2, this.Y_out - n, n, n, 270, 90);
            int n18 = 10 + genericGraphBox.Height / 2;
            GraphicalToolBox.drawArc(graphics2D, genericGraphBox.X_in - n18 / 2, genericGraphBox.Y_in, n18, n18, 90, 90);
            int n19 = genericGraphBox.X_in - n18 / 2;
            int n20 = genericGraphBox.Y_in + n18 / 2;
            int n21 = this.X_out + 1 + n / 2;
            int n22 = this.Y_out + 1 - n / 2;
            int n23 = n + n18 - 20;
            int n24 = (n21 + n19) / 2;
            int n25 = (n22 + n20) / 2;
            GraphicalToolBox.drawCurve(graphics2D, n19, n20, n19, n20 + n23, n24, n25);
            GraphicalToolBox.drawCurve(graphics2D, n21, n22, n21, n22 - n23, n24, n25);
            return;
        }
        if (genericGraphBox.X_out - 5 < this.X_in - 5) {
            GraphicalToolBox.drawLine(graphics2D, this.X_in - 5, this.Y_in, genericGraphBox.X_out - 5, genericGraphBox.Y_out);
            return;
        }
        if (this.equals(genericGraphBox)) {
            int n = 10 + this.Height / 2;
            GraphicalToolBox.drawArc(graphics2D, this.X_in - 5 - n / 2, this.Y_in - n, n, n, 90, 180);
            GraphicalToolBox.drawArc(graphics2D, genericGraphBox.X_out - 5 - n / 2, genericGraphBox.Y_out - n, n, n, 90, -180);
            GraphicalToolBox.drawLine(graphics2D, this.X_out - 5, this.Y_out - n, this.X_in - 5, this.Y_in - n);
            return;
        }
        if (this.Y1 < genericGraphBox.Y1 + genericGraphBox.Height && this.Y1 + this.Height > genericGraphBox.Y1) {
            int n = 10 + this.Height / 2;
            GraphicalToolBox.drawArc(graphics2D, this.X_in - 5 - n / 2, this.Y_in - n, n, n, 90, 180);
            int n26 = 10 + genericGraphBox.Height / 2;
            GraphicalToolBox.drawArc(graphics2D, genericGraphBox.X_out - 5 - n26 / 2, genericGraphBox.Y_out - n26, n26, n26, 90, -180);
            int n27 = genericGraphBox.X_out - 5;
            int n28 = genericGraphBox.Y_out - n26;
            int n29 = this.X_in - 5;
            int n30 = this.Y_in - n;
            int n31 = (n27 + n29) / 2;
            int n32 = (n28 + n30) / 2;
            int n33 = n + n26;
            GraphicalToolBox.drawCurve(graphics2D, n29, n30, n29 + n33, n30, n31, n32);
            GraphicalToolBox.drawCurve(graphics2D, n27, n28, n27 - n33, n28, n31, n32);
            return;
        }
        if (this.Y1 < genericGraphBox.Y1 + genericGraphBox.Height) {
            int n = 10 + this.Height / 2;
            GraphicalToolBox.drawArc(graphics2D, this.X_in - 5 - n / 2, this.Y_in, n, n, 90, 90);
            int n34 = 10 + genericGraphBox.Height / 2;
            GraphicalToolBox.drawArc(graphics2D, genericGraphBox.X_out - 5 - n34 / 2, genericGraphBox.Y_out - n34, n34, n34, 270, 90);
            int n35 = genericGraphBox.X_out + 1 - 5 + n34 / 2;
            int n36 = genericGraphBox.Y_out - n34 / 2;
            int n37 = this.X_in - 5 - n / 2;
            int n38 = this.Y_in + n / 2;
            int n39 = n + n34 - 20;
            int n40 = (n37 + n35) / 2;
            int n41 = (n38 + n36) / 2;
            GraphicalToolBox.drawCurve(graphics2D, n35, n36, n35, n36 - n39, n40, n41);
            GraphicalToolBox.drawCurve(graphics2D, n37, n38, n37, n38 + n39, n40, n41);
            return;
        }
        int n = 10 + this.Height / 2;
        GraphicalToolBox.drawArc(graphics2D, this.X_in - 5 - n / 2, this.Y_in - n, n, n, 270, -90);
        int n42 = 10 + genericGraphBox.Height / 2;
        GraphicalToolBox.drawArc(graphics2D, genericGraphBox.X_out - 5 - n42 / 2, genericGraphBox.Y_out, n42, n42, 90, -90);
        int n43 = genericGraphBox.X_out - 5 + n42 / 2;
        int n44 = genericGraphBox.Y_out + 1 + n42 / 2;
        int n45 = this.X_in - 5 - n / 2;
        int n46 = this.Y_in - n / 2;
        int n47 = n + n42 - 20;
        int n48 = (n45 + n43) / 2;
        int n49 = (n46 + n44) / 2;
        GraphicalToolBox.drawCurve(graphics2D, n43, n44, n43, n44 + n47, n48, n49);
        GraphicalToolBox.drawCurve(graphics2D, n45, n46, n45, n46 - n47, n48, n49);
    }

    public void drawTransitions(Graphics2D graphics2D) {
        this.updateWithContext(graphics2D);
        if (this.transitions.isEmpty()) {
            return;
        }
        int n = this.transitions.size();
        if (this.parentGraphicalZone != null) {
            graphics2D.setColor(this.parentGraphicalZone.pref.foregroundColor);
        } else {
            graphics2D.setColor(Preferences.pref.foregroundColor);
        }
        for (int i = 0; i < n; ++i) {
            GenericGraphBox genericGraphBox = (GenericGraphBox)this.transitions.get(i);
            this.drawTransition(graphics2D, genericGraphBox);
        }
    }

    private void drawOtherSingleDrag(Graphics2D graphics2D) {
        if (this.comment) {
            graphics2D.setColor(this.parentGraphicalZone.pref.commentColor);
        } else {
            graphics2D.setColor(this.parentGraphicalZone.pref.foregroundColor);
        }
        if (this.n_lignes == 0) {
            GraphicalToolBox.drawLine(graphics2D, this.X_in, this.Y_in, this.X_in + 15, this.Y_in);
            if (!this.parentGraphicalZone.pref.rightToLeft) {
                GraphicalToolBox.drawLine(graphics2D, this.X_in + 15, this.Y1, this.X_in + 15, this.Y1 + this.Height);
            } else {
                GraphicalToolBox.drawLine(graphics2D, this.X_in, this.Y1, this.X_in, this.Y1 + this.Height);
            }
        } else {
            GraphicalToolBox.drawRect(graphics2D, this.X1, this.Y1, this.Width, this.Height);
        }
        if (this.hasOutgoingTransitions || this.type == 0) {
            if (!this.parentGraphicalZone.pref.rightToLeft) {
                GraphicalToolBox.drawLine(graphics2D, this.X_out, this.Y_out, this.X1 + this.Width, this.Y1);
                GraphicalToolBox.drawLine(graphics2D, this.X1 + this.Width, this.Y1, this.X1 + this.Width, this.Y1 + this.Height);
                GraphicalToolBox.drawLine(graphics2D, this.X1 + this.Width, this.Y1 + this.Height, this.X_out, this.Y_out);
            } else {
                GraphicalToolBox.drawLine(graphics2D, this.X_in - 5, this.Y_in, this.X1, this.Y1);
                GraphicalToolBox.drawLine(graphics2D, this.X1, this.Y1, this.X1, this.Y1 + this.Height);
                GraphicalToolBox.drawLine(graphics2D, this.X1, this.Y1 + this.Height, this.X_in - 5, this.Y_in);
            }
        }
    }

    private void drawInitialSingleDrag(Graphics2D graphics2D) {
        graphics2D.setColor(this.parentGraphicalZone.pref.foregroundColor);
        if (this.n_lignes == 0) {
            GraphicalToolBox.drawLine(graphics2D, this.X_in, this.Y_in, this.X_in + 15, this.Y_in);
        } else {
            GraphicalToolBox.drawRect(graphics2D, this.X1, this.Y1, this.Width, this.Height);
        }
        if (!this.parentGraphicalZone.pref.rightToLeft) {
            GraphicalToolBox.drawLine(graphics2D, this.X_in, this.Y_in, this.X_in - 10, this.Y_in);
        } else {
            GraphicalToolBox.drawLine(graphics2D, this.X_out - 5, this.Y_out, this.X_out + 5, this.Y_out);
        }
        if (this.hasOutgoingTransitions || this.type == 0) {
            if (!this.parentGraphicalZone.pref.rightToLeft) {
                GraphicalToolBox.drawLine(graphics2D, this.X_out, this.Y_out, this.X1 + this.Width, this.Y1);
                GraphicalToolBox.drawLine(graphics2D, this.X1 + this.Width, this.Y1, this.X1 + this.Width, this.Y1 + this.Height);
                GraphicalToolBox.drawLine(graphics2D, this.X1 + this.Width, this.Y1 + this.Height, this.X_out, this.Y_out);
            } else {
                GraphicalToolBox.drawLine(graphics2D, this.X_in - 5, this.Y_in, this.X1, this.Y1);
                GraphicalToolBox.drawLine(graphics2D, this.X1, this.Y1, this.X1, this.Y1 + this.Height);
                GraphicalToolBox.drawLine(graphics2D, this.X1, this.Y1 + this.Height, this.X_in - 5, this.Y_in);
            }
        }
    }

    private void drawFinalSingleDrag(Graphics2D graphics2D) {
        this.drawFinal(graphics2D);
    }

    private void drawOtherComment(Graphics2D graphics2D) {
        if (this.variable) {
            this.drawVariableComment(graphics2D);
            return;
        }
        graphics2D.setColor(this.parentGraphicalZone.pref.commentColor);
        if (this.n_lignes == 0) {
            GraphicalToolBox.drawLine(graphics2D, this.X_in, this.Y_in, this.X_in + 15, this.Y_in);
            if (!this.parentGraphicalZone.pref.rightToLeft) {
                GraphicalToolBox.drawLine(graphics2D, this.X_in + 15, this.Y1, this.X_in + 15, this.Y1 + this.Height);
            } else {
                GraphicalToolBox.drawLine(graphics2D, this.X_in, this.Y1, this.X_in, this.Y1 + this.Height);
            }
        } else {
            graphics2D.setColor(this.parentGraphicalZone.pref.backgroundColor);
            GraphicalToolBox.fillRect(graphics2D, this.X1 + 1, this.Y1 + 1, this.Width - 1, this.Height - 1);
            graphics2D.setColor(this.parentGraphicalZone.pref.commentColor);
        }
        for (int i = 0; i < this.n_lignes; ++i) {
            Boolean bl = (Boolean)this.greyed.get(i);
            String string = (String)this.lines.get(i);
            if (bl.booleanValue()) {
                graphics2D.setColor(this.parentGraphicalZone.pref.subgraphColor);
                GraphicalToolBox.fillRect(graphics2D, this.X1 + 3, this.Y1 + 4 + i * this.h_ligne, this.Width - 4, this.h_ligne);
                graphics2D.setColor(this.parentGraphicalZone.pref.commentColor);
                graphics2D.drawString(string, this.X1 + 5, this.Y1 - this.descent + 3 + (i + 1) * this.h_ligne);
                continue;
            }
            graphics2D.drawString(string, this.X1 + 5, this.Y1 - this.descent + 3 + (i + 1) * this.h_ligne);
        }
        graphics2D.setColor(this.parentGraphicalZone.pref.foregroundColor);
        String string = this.transduction;
        graphics2D.setFont(this.parentGraphicalZone.pref.output);
        graphics2D.drawString(string, this.X1 + 5, this.Y1 + this.Height + graphics2D.getFontMetrics().getHeight());
    }

    private void drawFinal(Graphics2D graphics2D) {
        graphics2D.setColor(this.parentGraphicalZone.pref.backgroundColor);
        GraphicalToolBox.fillEllipse(graphics2D, this.x, this.Y - 10, 21, 21);
        graphics2D.setColor(this.parentGraphicalZone.pref.foregroundColor);
        GraphicalToolBox.drawEllipse(graphics2D, this.x, this.Y - 10, 21, 21);
        GraphicalToolBox.drawRect(graphics2D, this.x + 5, this.Y - 5, 10, 10);
    }

    private void drawFinalSelected(Graphics2D graphics2D) {
        graphics2D.setColor(this.parentGraphicalZone.pref.selectedColor);
        GraphicalToolBox.fillEllipse(graphics2D, this.x, this.Y - 10, 21, 21);
        graphics2D.setColor(this.parentGraphicalZone.pref.backgroundColor);
        GraphicalToolBox.drawRect(graphics2D, this.x + 5, this.Y - 5, 10, 10);
    }

    private void drawVariable(Graphics2D graphics2D) {
        graphics2D.setColor(this.parentGraphicalZone.pref.commentColor);
        graphics2D.setFont(variableFont);
        graphics2D.drawString((String)this.lines.get(0), this.X1 + 5, this.Y1 - graphics2D.getFontMetrics().getDescent() + this.get_h_variable_ligne());
        graphics2D.setFont(this.parentGraphicalZone.pref.output);
        String string = this.transduction;
        graphics2D.drawString(string, this.X1 + 10, this.Y1 + this.Height + graphics2D.getFontMetrics().getHeight());
    }

    private void drawVariableSelected(Graphics2D graphics2D) {
        graphics2D.setColor(this.parentGraphicalZone.pref.selectedColor);
        GraphicalToolBox.fillRect(graphics2D, this.X1, this.Y1, this.Width, this.Height);
        graphics2D.setColor(this.parentGraphicalZone.pref.commentColor);
        graphics2D.setFont(variableFont);
        graphics2D.drawString((String)this.lines.get(0), this.X1 + 5, this.Y1 - graphics2D.getFontMetrics().getDescent() + this.get_h_variable_ligne());
        graphics2D.setColor(this.parentGraphicalZone.pref.selectedColor);
        String string = this.transduction;
        GraphicalToolBox.fillRect(graphics2D, this.X1 + 5, this.Y1 + this.Height + graphics2D.getFontMetrics().getDescent(), graphics2D.getFontMetrics(this.parentGraphicalZone.pref.output).stringWidth(string), graphics2D.getFontMetrics(this.parentGraphicalZone.pref.output).getHeight() + 1);
        graphics2D.setColor(this.parentGraphicalZone.pref.backgroundColor);
        graphics2D.setFont(this.parentGraphicalZone.pref.output);
        graphics2D.drawString(string, this.X1 + 5, this.Y1 + this.Height + graphics2D.getFontMetrics().getHeight());
    }

    private void drawVariableComment(Graphics2D graphics2D) {
        this.drawVariable(graphics2D);
    }

    private void drawOther(Graphics2D graphics2D) {
        int n;
        Preferences preferences = Preferences.pref;
        if (this.parentGraphicalZone != null) {
            Preferences.pref = this.parentGraphicalZone.pref;
        }
        if (this.variable) {
            this.drawVariable(graphics2D);
            return;
        }
        graphics2D.setColor(preferences.foregroundColor);
        if (this.n_lignes == 0) {
            GraphicalToolBox.drawLine(graphics2D, this.X_in, this.Y_in, this.X_in + 15, this.Y_in);
            if (!this.parentGraphicalZone.pref.rightToLeft) {
                GraphicalToolBox.drawLine(graphics2D, this.X_in + 15, this.Y1, this.X_in + 15, this.Y1 + this.Height);
            } else {
                GraphicalToolBox.drawLine(graphics2D, this.X_in, this.Y1, this.X_in, this.Y1 + this.Height);
            }
        } else {
            GraphicalToolBox.drawRect(graphics2D, this.X1, this.Y1, this.Width, this.Height);
            graphics2D.setColor(this.parentGraphicalZone.pref.backgroundColor);
            GraphicalToolBox.fillRect(graphics2D, this.X1 + 1, this.Y1 + 1, this.Width - 1, this.Height - 1);
            graphics2D.setColor(this.parentGraphicalZone.pref.foregroundColor);
        }
        if (this.hasOutgoingTransitions || this.type == 0) {
            if (!this.parentGraphicalZone.pref.rightToLeft) {
                int n2 = this.X1 + this.Width;
                int n3 = this.Y1 + this.Height;
                GraphicalToolBox.drawLine(graphics2D, this.X_out, this.Y_out, n2, this.Y1);
                GraphicalToolBox.drawLine(graphics2D, n2, this.Y1, n2, n3);
                GraphicalToolBox.drawLine(graphics2D, n2, n3, this.X_out, this.Y_out);
            } else {
                GraphicalToolBox.drawLine(graphics2D, this.X_in - 5, this.Y_in, this.X1, this.Y1);
                GraphicalToolBox.drawLine(graphics2D, this.X1, this.Y1, this.X1, this.Y1 + this.Height);
                GraphicalToolBox.drawLine(graphics2D, this.X1, this.Y1 + this.Height, this.X_in - 5, this.Y_in);
            }
        }
        for (n = 0; n < this.n_lignes; ++n) {
            Boolean bl = (Boolean)this.greyed.get(n);
            String string = (String)this.lines.get(n);
            if (bl.booleanValue()) {
                graphics2D.setColor(preferences.subgraphColor);
                GraphicalToolBox.fillRect(graphics2D, this.X1 + 3, this.Y1 + 4 + n * this.h_ligne, this.Width - 4, this.h_ligne);
                graphics2D.setColor(preferences.foregroundColor);
                graphics2D.drawString(string, this.X1 + 5, this.Y1 - this.descent + 3 + (n + 1) * this.h_ligne);
                continue;
            }
            graphics2D.drawString(string, this.X1 + 5, this.Y1 - this.descent + 3 + (n + 1) * this.h_ligne);
        }
        graphics2D.setColor(preferences.foregroundColor);
        String string = this.transduction;
        if (this.parentGraphicalZone.OUTPUT_STYLE != GenericGraphicalZone.UNIF_OUTPUT) {
            graphics2D.setFont(preferences.output);
            graphics2D.drawString(string, this.X1 + 5, this.Y1 + this.Height + graphics2D.getFontMetrics().getHeight());
        } else {
            String[] stringArray = string.split("\\+");
            graphics2D.setFont(preferences.output);
            for (n = 0; n < stringArray.length; ++n) {
                graphics2D.drawString(stringArray[n], this.X1 + 5, this.Y1 + this.Height + (n + 1) * graphics2D.getFontMetrics().getHeight());
            }
        }
    }

    private void drawOtherSelected(Graphics2D graphics2D) {
        Preferences preferences = Preferences.pref;
        if (this.parentGraphicalZone != null) {
            Preferences.pref = this.parentGraphicalZone.pref;
        }
        if (this.variable) {
            this.drawVariableSelected(graphics2D);
            return;
        }
        graphics2D.setColor(preferences.foregroundColor);
        if (this.n_lignes == 0) {
            graphics2D.setColor(preferences.selectedColor);
            GraphicalToolBox.fillRect(graphics2D, this.X_in, this.Y_in - 10, 15, 20);
            graphics2D.setColor(preferences.backgroundColor);
            GraphicalToolBox.drawLine(graphics2D, this.X_in, this.Y_in, this.X_in + 15, this.Y_in);
        } else {
            graphics2D.setColor(preferences.selectedColor);
            GraphicalToolBox.fillRect(graphics2D, this.X1, this.Y1, this.Width, this.Height + 1);
        }
        if (this.hasOutgoingTransitions || this.type == 0) {
            graphics2D.setColor(preferences.foregroundColor);
            if (!preferences.rightToLeft) {
                GraphicalToolBox.drawLine(graphics2D, this.X_out, this.Y_out, this.X1 + this.Width, this.Y1);
                GraphicalToolBox.drawLine(graphics2D, this.X1 + this.Width, this.Y1, this.X1 + this.Width, this.Y1 + this.Height);
                GraphicalToolBox.drawLine(graphics2D, this.X1 + this.Width, this.Y1 + this.Height, this.X_out, this.Y_out);
            } else {
                GraphicalToolBox.drawLine(graphics2D, this.X_in - 5, this.Y_in, this.X1, this.Y1);
                GraphicalToolBox.drawLine(graphics2D, this.X1, this.Y1, this.X1, this.Y1 + this.Height);
                GraphicalToolBox.drawLine(graphics2D, this.X1, this.Y1 + this.Height, this.X_in - 5, this.Y_in);
            }
        }
        graphics2D.setColor(preferences.backgroundColor);
        for (int i = 0; i < this.n_lignes; ++i) {
            String string = (String)this.lines.get(i);
            graphics2D.drawString(string, this.X1 + 5, this.Y1 - this.descent + 3 + (i + 1) * this.h_ligne);
        }
        String string = this.transduction;
        graphics2D.setColor(preferences.selectedColor);
        GraphicalToolBox.fillRect(graphics2D, this.X1 + 5, this.Y1 + this.Height + graphics2D.getFontMetrics().getDescent(), graphics2D.getFontMetrics(this.parentGraphicalZone.pref.output).stringWidth(string), graphics2D.getFontMetrics(this.parentGraphicalZone.pref.output).getHeight() + 1);
        graphics2D.setColor(this.parentGraphicalZone.pref.backgroundColor);
        graphics2D.setFont(this.parentGraphicalZone.pref.output);
        graphics2D.drawString(string, this.X1 + 5, this.Y1 + this.Height + graphics2D.getFontMetrics().getHeight());
    }

    private void drawInitial(Graphics2D graphics2D) {
        this.drawOther(graphics2D);
        if (!this.parentGraphicalZone.pref.rightToLeft) {
            GraphicalToolBox.drawLine(graphics2D, this.X_in, this.Y_in, this.X_in - 10, this.Y_in);
        } else {
            GraphicalToolBox.drawLine(graphics2D, this.X_out - 5, this.Y_out, this.X_out + 5, this.Y_out);
        }
    }

    private void drawInitialSelected(Graphics2D graphics2D) {
        this.drawOtherSelected(graphics2D);
        graphics2D.setColor(this.parentGraphicalZone.pref.foregroundColor);
        if (!this.parentGraphicalZone.pref.rightToLeft) {
            GraphicalToolBox.drawLine(graphics2D, this.X_in - 1, this.Y_in, this.X_in - 10, this.Y_in);
        } else {
            GraphicalToolBox.drawLine(graphics2D, this.X_out - 5, this.Y_out, this.X_out + 5, this.Y_out);
        }
    }

    public void draw(Graphics2D graphics2D) {
        Preferences preferences = Preferences.pref;
        if (this.parentGraphicalZone != null) {
            Preferences.pref = this.parentGraphicalZone.pref;
        }
        this.updateWithContext(graphics2D);
        graphics2D.setFont(preferences.input);
        this.h_ligne = graphics2D.getFontMetrics().getHeight();
        this.descent = graphics2D.getFontMetrics().getDescent();
        if (this.singleDragging) {
            if (this.type == 1) {
                this.drawFinalSingleDrag(graphics2D);
            } else if (this.type == 2) {
                this.drawOtherSingleDrag(graphics2D);
            } else {
                this.drawInitialSingleDrag(graphics2D);
            }
        } else if (this.selected) {
            if (this.type == 1) {
                this.drawFinalSelected(graphics2D);
            } else if (this.type == 2) {
                this.drawOtherSelected(graphics2D);
            } else {
                this.drawInitialSelected(graphics2D);
            }
        } else if (this.comment) {
            if (this.type == 1) {
                this.drawFinal(graphics2D);
            } else if (this.type == 2) {
                this.drawOtherComment(graphics2D);
            } else {
                this.drawInitial(graphics2D);
            }
        } else if (this.type == 1) {
            this.drawFinal(graphics2D);
        } else if (this.type == 2) {
            this.drawOther(graphics2D);
        } else {
            this.drawInitial(graphics2D);
        }
    }

    int get_h_ligne() {
        if (this.context == null) {
            return 0;
        }
        Preferences preferences = Preferences.pref;
        if (this.parentGraphicalZone != null) {
            Preferences.pref = this.parentGraphicalZone.pref;
        }
        this.context.setFont(preferences.input);
        return this.context.getFontMetrics().getHeight();
    }

    int get_h_variable_ligne() {
        if (this.context == null) {
            return 0;
        }
        this.context.setFont(variableFont);
        return this.context.getFontMetrics().getHeight();
    }

    public int maxLineWidth() {
        if (this.context == null) {
            return 0;
        }
        int n = 0;
        n = 0;
        Preferences preferences = Preferences.pref;
        if (this.parentGraphicalZone != null) {
            Preferences.pref = this.parentGraphicalZone.pref;
        }
        FontMetrics fontMetrics = this.context.getFontMetrics(preferences.input);
        for (int i = 0; i < this.n_lignes; ++i) {
            String string = (String)this.lines.get(i);
            if (n >= fontMetrics.stringWidth(string)) continue;
            n = fontMetrics.stringWidth(string);
        }
        return n;
    }

    public abstract void setGrfContent(String var1);

    public abstract void setContent(String var1, String var2);

    public void update() {
        this.setContent(this.content, this.transduction);
    }

    public ArrayList getTransitions() {
        return this.transitions;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.Y;
    }

    public String getContent() {
        return this.content;
    }

    public String getTransduction() {
        return this.transduction;
    }

    public void translateToPosition(int n, int n2) {
        this.x = n;
        this.Y = n2;
        if (this.type == 1) {
            this.X_in = n;
            this.Y_in = this.Y;
            this.X1 = n;
            this.Y1 = this.Y - 10;
            this.Y_out = this.Y_in;
            this.X_out = this.X_in + 25;
        } else {
            this.X1 = n;
            this.Y1 = this.Y;
            this.X_in = n;
            this.Y_in = this.Y + this.Height / 2;
            this.X_out = n + this.Width + 5;
            this.Y_out = this.Y_in;
        }
    }

    public boolean hasTransitionToItself() {
        for (GenericGraphBox genericGraphBox : this.getTransitions()) {
            if (genericGraphBox != this) continue;
            return true;
        }
        return false;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.Y = n;
    }

    public int getWidth() {
        return this.Width;
    }

    public int getX_in() {
        return this.X_in;
    }

    public void setX_in(int n) {
        this.X_in = n;
    }

    public int getX_out() {
        return this.X_out;
    }

    public void setX_out(int n) {
        this.X_out = n;
    }

    public int getX1() {
        return this.X1;
    }

    public void setX1(int n) {
        this.X1 = n;
    }

    public int getY1() {
        return this.Y1;
    }

    public void setY1(int n) {
        this.Y1 = n;
    }

    public int getY_in() {
        return this.Y_in;
    }

    public void setY_in(int n) {
        this.Y_in = n;
    }

    public int getY_out() {
        return this.Y_out;
    }

    public void setY_out(int n) {
        this.Y_out = n;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setTransitions(ArrayList arrayList) {
        this.transitions = arrayList;
    }

    private void updateWithContext(Graphics2D graphics2D) {
        if (this.context != null) {
            return;
        }
        this.context = graphics2D;
        this.update();
    }
}

