/*
 * Decompiled with CFR 0.152.
 */
package fr.outilex.texts;

import fr.outilex.OutilexContentPane;
import fr.outilex.OutilexEnvironment;
import fr.outilex.config.OutilexParameters;
import fr.outilex.io.OutilexFileChoosers;
import fr.outilex.process.Command;
import fr.outilex.process.ProcessActionListener;
import fr.outilex.process.ProcessInfo;
import fr.outilex.projects.ProjectActionListener;
import fr.outilex.projects.TextListModel;
import fr.outilex.texts.Text;
import fr.outilex.texts.TextFsa;
import fr.outilex.texts.TextPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;

public class TextActionListener
implements ActionListener {
    protected String action;
    protected OutilexEnvironment env;

    public TextActionListener(String string, OutilexEnvironment outilexEnvironment) {
        this.action = string;
        this.env = outilexEnvironment;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println("Text Action");
        if (this.action.equals("new")) {
            TextActionListener.createText(this.env);
            return;
        }
        if (this.action.equals("open")) {
            TextActionListener.openText(this.env, true);
            return;
        }
        if (this.action.equals("opentextfsa")) {
            TextActionListener.openTextFsa(this.env, true);
            return;
        }
        if (this.action.equals("save")) {
            this.saveText();
            return;
        }
        if (this.action.equals("saveas")) {
            this.saveAsText();
            return;
        }
        if (this.action.equals("tfsa2xml")) {
            this.textFsa2Xml();
            return;
        }
        if (this.action.equals("addtoproject")) {
            TextActionListener.addToProject(this.env);
            return;
        }
    }

    public static String selectText(Component component) {
        JFileChooser jFileChooser = OutilexFileChoosers.getOpenTextFileChooser();
        int n = jFileChooser.showOpenDialog(component);
        if (n == 0) {
            OutilexParameters.textpath = jFileChooser.getCurrentDirectory();
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public static String selectText(OutilexEnvironment outilexEnvironment) {
        return TextActionListener.selectText(outilexEnvironment.mainFrame);
    }

    public static void createText(OutilexEnvironment outilexEnvironment) {
        OutilexContentPane outilexContentPane = outilexEnvironment.contentPane;
        outilexContentPane.addPanel("new text", new TextPanel(outilexContentPane));
        outilexContentPane.setSelectedIndex(outilexContentPane.getTabCount() - 1);
    }

    public static void openText(OutilexEnvironment outilexEnvironment, boolean bl) {
        JFileChooser jFileChooser = OutilexFileChoosers.getOpenTextFileChooser();
        int n = jFileChooser.showOpenDialog(outilexEnvironment.mainFrame);
        if (n == 0) {
            OutilexParameters.textpath = jFileChooser.getCurrentDirectory();
            File file = jFileChooser.getSelectedFile();
            String string = file.getAbsolutePath();
            TextActionListener.openText(string, outilexEnvironment, bl);
        }
    }

    public static void openText(String string, OutilexEnvironment outilexEnvironment, boolean bl) {
        OutilexContentPane outilexContentPane = outilexEnvironment.contentPane;
        TextPanel textPanel = new TextPanel(outilexContentPane);
        textPanel.load(string, bl);
        textPanel.setFile(string);
        outilexContentPane.addPanel(textPanel.getTitle(), textPanel);
        outilexContentPane.setSelectedIndex(outilexContentPane.getTabCount() - 1);
    }

    public static void openTextFsa(OutilexEnvironment outilexEnvironment, boolean bl) {
        JFileChooser jFileChooser = OutilexFileChoosers.getOpenTextFsaFileChooser();
        int n = jFileChooser.showOpenDialog(outilexEnvironment.mainFrame);
        if (n == 0) {
            OutilexParameters.textfsapath = jFileChooser.getCurrentDirectory();
            File file = jFileChooser.getSelectedFile();
            String string = file.getAbsolutePath();
            TextActionListener.openTextFsa(string, outilexEnvironment, bl);
        }
    }

    public static void openTextFsa(String string, OutilexEnvironment outilexEnvironment, boolean bl) {
        OutilexContentPane outilexContentPane = outilexEnvironment.contentPane;
        TextFsa textFsa = new TextFsa(string, outilexEnvironment);
        outilexContentPane.addPanel(textFsa.getShortname(), textFsa);
        outilexContentPane.setSelectedIndex(outilexContentPane.getTabCount() - 1);
        if (bl) {
            new ProcessInfo(ProcessActionListener.buildPSViewCommand(0, string), outilexEnvironment).start();
        }
    }

    public void textFsa2Xml() {
        new ProcessInfo(this.buildTfsa2XmlCommands(), this.env).start();
    }

    public ArrayList buildTfsa2XmlCommands() {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        Component component = this.env.contentPane.getSelectedComponent();
        if (component instanceof TextFsa) {
            TextFsa textFsa = (TextFsa)component;
            String string = textFsa.getName();
            Command command = new Command();
            command = new Command();
            command.setProg("tfsa-copy");
            command.addArgument(OutilexParameters.BINDIR + "/tfsa-copy");
            String string2 = OutilexParameters.getAppropriateRelativePath(OutilexParameters.LINGDIR + "/" + OutilexParameters.LANGUAGE + "/lingdef.xml");
            command.addArgument("-l");
            command.addArgument(string2);
            command.addArgument("-f");
            command.addArgument("xml");
            command.addArgument("-gz");
            command.addArgument("-o");
            command.addArgument(OutilexParameters.getAppropriateRelativePath(string + ".xml.gz"));
            command.addArgument(OutilexParameters.getAppropriateRelativePath(string));
            arrayList.add(command);
        }
        return arrayList;
    }

    public void saveText() {
        OutilexContentPane outilexContentPane = this.env.contentPane;
        Component component = outilexContentPane.getSelectedComponent();
        if (component instanceof TextPanel) {
            TextPanel textPanel = (TextPanel)component;
            if (!textPanel.isEditable()) {
                return;
            }
            String string = textPanel.getTitle();
            if (string == null || string.equals("")) {
                this.saveAsText();
                return;
            }
            textPanel.save(textPanel.getAbsolutePath());
        }
    }

    public void saveAsText() {
        JFileChooser jFileChooser = OutilexFileChoosers.getSaveAsTextFileChooser();
        int n = jFileChooser.showSaveDialog(this.env.mainFrame);
        if (n == 0) {
            OutilexParameters.textpath = jFileChooser.getCurrentDirectory();
            File file = jFileChooser.getSelectedFile();
            String string = file.getAbsolutePath();
            OutilexContentPane outilexContentPane = this.env.contentPane;
            Component component = outilexContentPane.getSelectedComponent();
            if (component instanceof TextPanel) {
                TextPanel textPanel = (TextPanel)component;
                if (!textPanel.isEditable()) {
                    return;
                }
                textPanel.save(string);
                textPanel.setTitle(string);
            }
        }
    }

    public static void addToProject(OutilexEnvironment outilexEnvironment) {
        OutilexContentPane outilexContentPane = outilexEnvironment.contentPane;
        Component component = outilexContentPane.getSelectedComponent();
        if (component instanceof TextPanel) {
            TextPanel textPanel = (TextPanel)component;
            String string = textPanel.getAbsolutePath();
            if (string == null || string.equals("")) {
                return;
            }
            ProjectActionListener.insertResource(string, "Text", outilexEnvironment, outilexEnvironment.texts);
        }
    }

    public static void addText(String string, OutilexEnvironment outilexEnvironment) {
        ((TextListModel)outilexEnvironment.texts.getModel()).addText(new Text(string));
    }
}

