/*
 * Decompiled with CFR 0.152.
 */
package fr.outilex.dictionaries;

import fr.outilex.OutilexContentPane;
import fr.outilex.OutilexEnvironment;
import fr.outilex.OutilexException;
import fr.outilex.config.OutilexParameters;
import fr.outilex.dictionaries.DicoPanel;
import fr.outilex.io.OutilexFileChoosers;
import fr.outilex.process.Command;
import fr.outilex.process.ProcessInfo;
import fr.outilex.projects.ProjectActionListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class DicoActionListener
implements ActionListener {
    private String action;
    private OutilexEnvironment env;

    public DicoActionListener(String string, OutilexEnvironment outilexEnvironment) {
        this.action = string;
        this.env = outilexEnvironment;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println("Dico Action");
        if (this.action.equals("new")) {
            DicoActionListener.createDico(this.env);
            return;
        }
        if (this.action.equals("open")) {
            DicoActionListener.openDico(this.env, true);
            return;
        }
        if (this.action.equals("save")) {
            this.saveDico();
            return;
        }
        if (this.action.equals("saveas")) {
            this.saveAsDico();
            return;
        }
        if (this.action.equals("addtoproject")) {
            DicoActionListener.addToProject(this.env);
            return;
        }
        if (this.action.equals("compress")) {
            try {
                new ProcessInfo(this.buildCompressCommands(this.env), this.env).start();
            }
            catch (OutilexException outilexException) {
                JOptionPane.showMessageDialog(this.env.mainPanel, outilexException.what(), "Error", 0);
            }
            return;
        }
        if (this.action.equals("xml2dela")) {
            System.out.println("XML2DELA transcoder to be implemented...");
            return;
        }
        if (this.action.equals("dela2xml")) {
            new ProcessInfo(this.buildDela2XmlCommands(this.env), this.env).start();
        }
    }

    public ArrayList buildXml2DelaCommands() {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        Command command = new Command();
        command.setProg("grep");
        command.addArgument("grep");
        command.addArgument("-r");
        command.addArgument("x");
        command.addArgument("/");
        arrayList.add(command);
        return arrayList;
    }

    public ArrayList buildCompressCommands(OutilexEnvironment outilexEnvironment) throws OutilexException {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        Component component = outilexEnvironment.contentPane.getSelectedComponent();
        if (component instanceof DicoPanel) {
            DicoPanel dicoPanel = (DicoPanel)component;
            String string = OutilexParameters.getAppropriateRelativePath(dicoPanel.getAbsolutePath());
            if (string.endsWith("dic.xml.gz")) {
                Command command = new Command();
                command.setProg("dic-index");
                command.addArgument(OutilexParameters.BINDIR + "/dic-index");
                command.addArgument(string);
                arrayList.add(command);
                String string2 = string;
                string2 = string2.substring(0, string2.length() - 11);
                String string3 = string2 + ".dic.idx";
                string2 = string2 + ".idx";
                command = new Command();
                command.setProg("mv");
                command.setType(Command.FILE);
                command.addArgument("mv");
                command.addArgument(string3);
                command.addArgument(string2);
                arrayList.add(command);
            } else if (dicoPanel.getAbsolutePath().endsWith(".dic")) {
                Command command = new Command();
                command.setProg("dela-index");
                command.addArgument(OutilexParameters.BINDIR + "/dela-index");
                command.addArgument(string.replaceAll("\\\\", "/"));
                command.addArgument("-corresp");
                String string4 = OutilexParameters.getAppropriateRelativePath(OutilexParameters.LINGDIR + "/" + OutilexParameters.LANGUAGE + "/delaf-corresp");
                command.addArgument(string4);
                arrayList.add(command);
            } else {
                throw new OutilexException("Your dictionary should be an XML.GZ or DIC file");
            }
        }
        return arrayList;
    }

    public ArrayList buildDela2XmlCommands(OutilexEnvironment outilexEnvironment) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        Component component = outilexEnvironment.contentPane.getSelectedComponent();
        if (component instanceof DicoPanel) {
            DicoPanel dicoPanel = (DicoPanel)component;
            Command command = new Command();
            command = new Command();
            command.setProg("delaf2xml.sh");
            command.addArgument(OutilexParameters.BINDIR + "/delaf2xml.sh");
            command.addArgument("-c");
            String string = OutilexParameters.getAppropriateRelativePath(OutilexParameters.LINGDIR + "/" + OutilexParameters.LANGUAGE + "/delaf-corresp");
            command.addArgument(string);
            command.addArgument(OutilexParameters.getAppropriateRelativePath(dicoPanel.getAbsolutePath()));
            arrayList.add(command);
            command = new Command();
            command.setProg("opendic");
            command.setType(Command.OUTILEX);
            command.addArgument("opendic");
            command.addArgument(dicoPanel.getAbsolutePath() + ".xml.gz");
            arrayList.add(command);
        }
        return arrayList;
    }

    public static String selectDico(Component component) {
        JFileChooser jFileChooser = OutilexFileChoosers.getOpenDicoFileChooser();
        int n = jFileChooser.showOpenDialog(component);
        if (n == 0) {
            OutilexParameters.dicopath = jFileChooser.getCurrentDirectory();
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public static String selectDico(OutilexEnvironment outilexEnvironment) {
        return DicoActionListener.selectDico(outilexEnvironment.mainFrame);
    }

    public static String selectIdxDico(Component component) {
        JFileChooser jFileChooser = OutilexFileChoosers.getOpenIdxDicoFileChooser();
        int n = jFileChooser.showOpenDialog(component);
        if (n == 0) {
            OutilexParameters.dicopath = jFileChooser.getCurrentDirectory();
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public static String selectIdxDico(OutilexEnvironment outilexEnvironment) {
        return DicoActionListener.selectIdxDico(outilexEnvironment.mainFrame);
    }

    public static void createDico(OutilexEnvironment outilexEnvironment) {
        OutilexContentPane outilexContentPane = outilexEnvironment.contentPane;
        outilexContentPane.addPanel("new dico", new DicoPanel(outilexContentPane));
        outilexContentPane.setSelectedIndex(outilexContentPane.getTabCount() - 1);
    }

    public static void openDico(OutilexEnvironment outilexEnvironment, boolean bl) {
        JFileChooser jFileChooser = OutilexFileChoosers.getOpenDicoFileChooser();
        int n = jFileChooser.showOpenDialog(outilexEnvironment.mainFrame);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            String string = file.getAbsolutePath();
            OutilexParameters.dicopath = jFileChooser.getCurrentDirectory();
            DicoActionListener.openDico(string, outilexEnvironment, bl);
        }
    }

    public static void openDico(String string, OutilexEnvironment outilexEnvironment, boolean bl) {
        OutilexContentPane outilexContentPane = outilexEnvironment.contentPane;
        DicoPanel dicoPanel = new DicoPanel(outilexContentPane);
        dicoPanel.load(string, bl);
        dicoPanel.setFile(string);
        outilexContentPane.addPanel(dicoPanel.getTitle(), dicoPanel);
        outilexContentPane.setSelectedIndex(outilexContentPane.getTabCount() - 1);
    }

    public void saveDico() {
        OutilexContentPane outilexContentPane = this.env.contentPane;
        Component component = outilexContentPane.getSelectedComponent();
        if (component instanceof DicoPanel) {
            DicoPanel dicoPanel = (DicoPanel)component;
            if (!dicoPanel.isEditable()) {
                return;
            }
            String string = dicoPanel.getTitle();
            if (string == null || string.equals("")) {
                this.saveAsDico();
                return;
            }
            dicoPanel.save(string);
        }
    }

    public void saveAsDico() {
        JFileChooser jFileChooser = OutilexFileChoosers.getSaveAsDicoFileChooser();
        int n = jFileChooser.showSaveDialog(this.env.mainFrame);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            OutilexParameters.dicopath = jFileChooser.getCurrentDirectory();
            String string = file.getAbsolutePath();
            OutilexContentPane outilexContentPane = this.env.contentPane;
            Component component = outilexContentPane.getSelectedComponent();
            if (component instanceof DicoPanel) {
                DicoPanel dicoPanel = (DicoPanel)component;
                if (!dicoPanel.isEditable()) {
                    return;
                }
                dicoPanel.save(string);
                dicoPanel.setTitle(string);
            }
        }
    }

    public static void addToProject(OutilexEnvironment outilexEnvironment) {
        OutilexContentPane outilexContentPane = outilexEnvironment.contentPane;
        Component component = outilexContentPane.getSelectedComponent();
        if (component instanceof DicoPanel) {
            DicoPanel dicoPanel = (DicoPanel)component;
            String string = dicoPanel.getAbsolutePath();
            if (string == null || string.equals("")) {
                return;
            }
            ProjectActionListener.insertResource(string, "Dico", outilexEnvironment, outilexEnvironment.dicos);
        }
    }
}

