/*
 * Decompiled with CFR 0.152.
 */
package fr.outilex;

import fr.outilex.OutilexEnvironment;
import fr.outilex.config.OutilexParameters;
import fr.outilex.io.OutilexFileChoosers;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class LocatePane
extends JPanel {
    private OutilexEnvironment env;
    JRadioButton regularExpression = new JRadioButton("Regular expression:", false);
    JLabel graph = new JLabel("Graph:");
    JTextField regExp = new JTextField();
    JTextField graphName = new JTextField();
    JRadioButton shortestMatches = new JRadioButton("Shortest matches", false);
    JRadioButton longuestMatches = new JRadioButton("Longest matches", true);
    JRadioButton allMatches = new JRadioButton("All matches", false);
    JRadioButton longestWeightedMatches = new JRadioButton("Longest matches + weights (sum)", false);
    JRadioButton weightMatches = new JRadioButton("Weights (sum) + longest match", false);
    JRadioButton ignoreOutputs = new JRadioButton("Ignore", true);
    JRadioButton mergeOutputs = new JRadioButton("Merge", false);
    JRadioButton replaceOutputs = new JRadioButton("Replace", false);
    JRadioButton stopAfterNmatches = new JRadioButton("Stop after ", true);
    JRadioButton indexAllMatches = new JRadioButton("Index all utterances in text", false);
    JRadioButton concord = new JRadioButton("Concordance", true);
    JRadioButton trans = new JRadioButton("Modified text", false);
    JRadioButton HTML = new JRadioButton("HTML", true);
    JRadioButton TXT = new JRadioButton("TXT", false);
    JRadioButton ALL = new JRadioButton("All", false);
    JRadioButton LONGEST = new JRadioButton("Longest", true);

    public LocatePane(OutilexEnvironment outilexEnvironment) {
        this.env = outilexEnvironment;
        this.constructPanel();
    }

    public void initRadioButtonsForConcordance() {
        this.TXT.setEnabled(false);
        this.HTML.setSelected(true);
        this.ALL.setEnabled(true);
        this.replaceOutputs.setEnabled(false);
        this.ignoreOutputs.setSelected(true);
    }

    public void initRadioButtonsForTransduct() {
        this.TXT.setEnabled(true);
        this.TXT.setSelected(true);
        this.ALL.setEnabled(false);
        this.LONGEST.setSelected(true);
        this.replaceOutputs.setEnabled(true);
    }

    private void constructPanel() {
        this.initRadioButtonsForConcordance();
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("Locate pattern settings:"));
        this.setBackground(Color.GRAY);
        this.add((Component)this.constructPatternPanel(), "Center");
        this.add((Component)this.constructDownPanel(), "South");
    }

    private JPanel constructPatternPanel() {
        JPanel jPanel = new JPanel();
        AbstractAction abstractAction = new AbstractAction("Set"){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = OutilexFileChoosers.getSelectGraphFileChooser();
                int n = jFileChooser.showOpenDialog(null);
                if (n != 0) {
                    return;
                }
                OutilexParameters.graphpath = jFileChooser.getCurrentDirectory();
                LocatePane.this.graphName.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                ((LocatePane)LocatePane.this).env.project.setLocateGraph(LocatePane.this.getGraphPath());
            }
        };
        JButton jButton = new JButton(abstractAction);
        this.graphName.setPreferredSize(new Dimension(150, 20));
        jButton.setPreferredSize(new Dimension(30, 20));
        jPanel.add(this.graph);
        jPanel.add(this.graphName);
        jPanel.add(jButton);
        return jPanel;
    }

    private JPanel constructDownPanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 2));
        JPanel jPanel2 = new JPanel();
        jPanel.add(this.constructResultTypePanel());
        jPanel.add(this.constructResultFormatPanel());
        JPanel jPanel3 = new JPanel();
        jPanel.add(this.constructIndexPanel());
        jPanel.add(this.constructOutputPanel());
        return jPanel;
    }

    private JPanel constructResultTypePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new TitledBorder("Result type"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.concord);
        buttonGroup.add(this.trans);
        this.concord.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (LocatePane.this.concord.isSelected()) {
                    LocatePane.this.initRadioButtonsForConcordance();
                } else {
                    LocatePane.this.initRadioButtonsForTransduct();
                }
            }
        });
        jPanel.add((Component)this.concord, "North");
        jPanel.add((Component)this.trans, "South");
        return jPanel;
    }

    private JPanel constructResultFormatPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new TitledBorder("Format"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.HTML);
        buttonGroup.add(this.TXT);
        jPanel.add((Component)this.HTML, "North");
        jPanel.add((Component)this.TXT, "South");
        return jPanel;
    }

    private JPanel constructIndexPanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.setBorder(new TitledBorder("Index"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.ALL);
        buttonGroup.add(this.LONGEST);
        jPanel.add(this.ALL);
        jPanel.add(this.LONGEST);
        return jPanel;
    }

    private JPanel constructOutputPanel() {
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        jPanel.setBorder(new TitledBorder("Outputs"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.ignoreOutputs);
        buttonGroup.add(this.mergeOutputs);
        buttonGroup.add(this.replaceOutputs);
        this.ignoreOutputs.setEnabled(true);
        this.replaceOutputs.setEnabled(true);
        jPanel.add(this.ignoreOutputs);
        jPanel.add(this.mergeOutputs);
        jPanel.add(this.replaceOutputs);
        return jPanel;
    }

    private JPanel constructSearchLimitationPanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.setBorder(new TitledBorder("Search limitation"));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.stopAfterNmatches, "West");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.stopAfterNmatches);
        buttonGroup.add(this.indexAllMatches);
        jPanel.add(jPanel2);
        jPanel.add(this.indexAllMatches);
        return jPanel;
    }

    public String getGraphPath() {
        return this.graphName.getText();
    }

    public void setGraphPath(String string) {
        this.graphName.setText(string);
    }

    public String getFormatOption() {
        if (this.TXT.isSelected()) {
            return "-txt";
        }
        if (this.HTML.isSelected()) {
            return "-html";
        }
        return "";
    }

    public String getResultName() {
        if (this.TXT.isSelected()) {
            return "modified_text.txt";
        }
        if (this.HTML.isSelected()) {
            if (this.concord.isSelected()) {
                return "concord.index";
            }
            return "modified_text.html";
        }
        return "";
    }

    public String getOutputOption() {
        if (this.ignoreOutputs.isSelected()) {
            return "-i";
        }
        if (this.replaceOutputs.isSelected()) {
            return "-r";
        }
        if (this.mergeOutputs.isSelected()) {
            return "-m";
        }
        return "";
    }

    public boolean isLongestMatch() {
        return this.LONGEST.isSelected();
    }

    public boolean isMerge() {
        return this.mergeOutputs.isSelected();
    }

    public boolean isConcordancer() {
        return this.concord.isSelected();
    }
}

