/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.unitex.undo;

import fr.umlv.unitex.GenericGraphBox;
import fr.umlv.unitex.GenericGraphicalZone;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.undo.AbstractUndoableEdit;

public class DeleteBoxGroupEdit
extends AbstractUndoableEdit {
    ArrayList boxes;
    ArrayList selectedBoxes;
    ArrayList oldSelectedBoxes;
    GenericGraphicalZone zone;
    HashMap selectedBoxesAndTransitionsTo = new HashMap();
    HashMap selectedBoxesAndTransitionsFrom = new HashMap();

    public DeleteBoxGroupEdit(ArrayList arrayList, ArrayList arrayList2, GenericGraphicalZone genericGraphicalZone) {
        this.selectedBoxes = arrayList;
        this.oldSelectedBoxes = (ArrayList)arrayList.clone();
        this.boxes = arrayList2;
        this.zone = genericGraphicalZone;
        for (GenericGraphBox genericGraphBox : arrayList) {
            ArrayList arrayList3 = genericGraphicalZone.getTransitionTo(genericGraphBox);
            ArrayList arrayList4 = (ArrayList)genericGraphBox.getTransitions().clone();
            this.selectedBoxesAndTransitionsTo.put(genericGraphBox, arrayList3);
            this.selectedBoxesAndTransitionsFrom.put(genericGraphBox, arrayList4);
        }
    }

    public void undo() {
        super.undo();
        Set set = this.selectedBoxesAndTransitionsTo.keySet();
        for (GenericGraphBox genericGraphBox : set) {
            genericGraphBox.setTransitions(new ArrayList());
            ArrayList arrayList = (ArrayList)this.selectedBoxesAndTransitionsTo.get(genericGraphBox);
            ArrayList arrayList2 = (ArrayList)this.selectedBoxesAndTransitionsFrom.get(genericGraphBox);
            this.boxes.add(genericGraphBox);
            genericGraphBox.setSelected(true);
            this.selectedBoxes.add(genericGraphBox);
            this.zone.initText(genericGraphBox.getContent(), genericGraphBox.getTransduction());
            if (genericGraphBox.hasTransitionToItself()) {
                genericGraphBox.addTransitionTo(genericGraphBox);
            }
            for (GenericGraphBox genericGraphBox2 : arrayList) {
                if (this.selectedBoxes.contains(genericGraphBox2)) continue;
                genericGraphBox2.onlyAddTransitionTo(genericGraphBox);
            }
            for (GenericGraphBox genericGraphBox2 : arrayList2) {
                genericGraphBox.onlyAddTransitionTo(genericGraphBox2);
            }
        }
        this.zone.repaint();
    }

    public void redo() {
        super.redo();
        if (this.selectedBoxes.isEmpty()) {
            return;
        }
        int n = this.oldSelectedBoxes.size();
        for (int i = 0; i < n; ++i) {
            GenericGraphBox genericGraphBox = (GenericGraphBox)this.oldSelectedBoxes.get(i);
            if (genericGraphBox.getType() == 2) {
                this.boxes.remove(genericGraphBox);
            }
            this.zone.removeTransitionsToSelected();
        }
        this.zone.unSelectAllBoxes();
        this.zone.repaint();
    }
}

