/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.unitex.io;

import fr.umlv.unitex.GenericGraphBox;
import fr.umlv.unitex.GraphFrame;
import fr.umlv.unitex.GraphicalZone;
import fr.umlv.unitex.Preferences;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class SVG {
    private OutputStreamWriter writer;
    private GraphFrame frame;
    private GraphicalZone graphicalZone;
    private Graphics2D graphics;
    private Preferences preferences;
    private Font input;
    private Font output;
    private int h_ligne;
    private int descent;
    private int OUTPUT_STYLE;

    public SVG(OutputStreamWriter outputStreamWriter, GraphFrame graphFrame) {
        this.writer = outputStreamWriter;
        this.frame = graphFrame;
        this.graphicalZone = graphFrame.graphicalZone;
        this.graphics = (Graphics2D)this.graphicalZone.getGraphics();
        this.preferences = this.graphicalZone.pref;
        this.input = this.preferences.input;
        this.output = this.preferences.output;
        this.OUTPUT_STYLE = this.graphicalZone.OUTPUT_STYLE;
    }

    private void header() throws IOException {
        this.writer.write("<?xml version=\"1.0\" standalone=\"yes\"?>\n");
        this.writer.write("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n");
        this.writer.write("<svg width=\"" + this.graphicalZone.Width + "\" height=\"" + this.graphicalZone.Height + "\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\">\n");
        this.writer.write("<desc>\n\tThis SVG file was created by Unitex (http://igm.univ-mlv.fr/~unitex).\n");
        this.writer.write("\tIt represents the graph named: " + this.frame.getGraph().getAbsolutePath() + "\n</desc>\n");
    }

    public void save() throws IOException {
        GenericGraphBox genericGraphBox;
        int n;
        this.header();
        ArrayList arrayList = this.graphicalZone.graphBoxes;
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            genericGraphBox = (GenericGraphBox)arrayList.get(n);
            this.drawTransitions(genericGraphBox);
        }
        for (n = 0; n < n2; ++n) {
            genericGraphBox = (GenericGraphBox)arrayList.get(n);
            this.drawBox(genericGraphBox);
        }
        this.writer.write("</svg>\n");
    }

    private void drawBox(GenericGraphBox genericGraphBox) throws IOException {
        this.graphics.setFont(this.input);
        this.h_ligne = this.graphics.getFontMetrics().getHeight();
        this.descent = this.graphics.getFontMetrics().getDescent();
        if (genericGraphBox.comment) {
            if (genericGraphBox.type == 1) {
                this.drawFinal(genericGraphBox);
            } else if (genericGraphBox.type == 2) {
                this.drawOtherComment(genericGraphBox);
            } else {
                this.drawInitial(genericGraphBox);
            }
        } else if (genericGraphBox.type == 1) {
            this.drawFinal(genericGraphBox);
        } else if (genericGraphBox.type == 2) {
            this.drawOther(genericGraphBox);
        } else {
            this.drawInitial(genericGraphBox);
        }
    }

    private void drawInitial(GenericGraphBox genericGraphBox) throws IOException {
        this.drawOther(genericGraphBox);
        if (!this.preferences.rightToLeft) {
            this.drawLine(genericGraphBox.X_in, genericGraphBox.Y_in, genericGraphBox.X_in - 10, genericGraphBox.Y_in, this.preferences.foregroundColor);
        } else {
            this.drawLine(genericGraphBox.X_out - 5, genericGraphBox.Y_out, genericGraphBox.X_out + 5, genericGraphBox.Y_out, this.preferences.foregroundColor);
        }
    }

    private void drawOther(GenericGraphBox genericGraphBox) throws IOException {
        int n;
        int n2;
        if (genericGraphBox.variable) {
            this.drawVariable(genericGraphBox);
            return;
        }
        Color color = this.preferences.foregroundColor;
        if (genericGraphBox.n_lignes == 0) {
            this.drawLine(genericGraphBox.X_in, genericGraphBox.Y_in, genericGraphBox.X_in + 15, genericGraphBox.Y_in, color);
            if (!this.preferences.rightToLeft) {
                this.drawLine(genericGraphBox.X_in + 15, genericGraphBox.Y1, genericGraphBox.X_in + 15, genericGraphBox.Y1 + genericGraphBox.Height, color);
            } else {
                this.drawLine(genericGraphBox.X_in, genericGraphBox.Y1, genericGraphBox.X_in, genericGraphBox.Y1 + genericGraphBox.Height, color);
            }
        } else {
            this.fillRect(genericGraphBox.X1, genericGraphBox.Y1, genericGraphBox.Width, genericGraphBox.Height, this.preferences.backgroundColor);
            this.drawRect(genericGraphBox.X1, genericGraphBox.Y1, genericGraphBox.Width, genericGraphBox.Height, color, 1);
        }
        if (genericGraphBox.hasOutgoingTransitions || genericGraphBox.type == 0) {
            if (!this.preferences.rightToLeft) {
                n2 = genericGraphBox.X1 + genericGraphBox.Width;
                n = genericGraphBox.Y1 + genericGraphBox.Height;
                this.drawLine(genericGraphBox.X_out, genericGraphBox.Y_out, n2, genericGraphBox.Y1, color);
                this.drawLine(n2, genericGraphBox.Y1, n2, n, color);
                this.drawLine(n2, n, genericGraphBox.X_out, genericGraphBox.Y_out, color);
            } else {
                this.drawLine(genericGraphBox.X_in - 5, genericGraphBox.Y_in, genericGraphBox.X1, genericGraphBox.Y1, color);
                this.drawLine(genericGraphBox.X1, genericGraphBox.Y1, genericGraphBox.X1, genericGraphBox.Y1 + genericGraphBox.Height, color);
                this.drawLine(genericGraphBox.X1, genericGraphBox.Y1 + genericGraphBox.Height, genericGraphBox.X_in - 5, genericGraphBox.Y_in, color);
            }
        }
        for (n2 = 0; n2 < genericGraphBox.n_lignes; ++n2) {
            Boolean bl = (Boolean)genericGraphBox.greyed.get(n2);
            String string = (String)genericGraphBox.lines.get(n2);
            if (bl.booleanValue()) {
                this.fillRect(genericGraphBox.X1 + 2, genericGraphBox.Y1 + 4 + n2 * this.h_ligne, genericGraphBox.Width - 4, this.h_ligne, this.preferences.subgraphColor);
            }
            this.drawText(string, genericGraphBox.X1 + 5, genericGraphBox.Y1 - this.descent + 3 + (n2 + 1) * this.h_ligne, color, this.input);
        }
        if (!genericGraphBox.transduction.equals("")) {
            if (this.OUTPUT_STYLE == GraphicalZone.NORMAL_OUTPUT) {
                this.drawText(genericGraphBox.transduction, genericGraphBox.X1 + 5, genericGraphBox.Y1 + genericGraphBox.Height + this.graphics.getFontMetrics().getHeight(), this.preferences.foregroundColor, this.output);
            } else {
                String[] stringArray = genericGraphBox.transduction.split("\\+");
                for (n = 0; n < stringArray.length; ++n) {
                    this.drawText(stringArray[n], genericGraphBox.X1 + 5, genericGraphBox.Y1 + genericGraphBox.Height + (n + 1) * this.graphics.getFontMetrics().getHeight(), this.preferences.foregroundColor, this.output);
                }
            }
        }
    }

    private void drawOtherComment(GenericGraphBox genericGraphBox) throws IOException {
        if (genericGraphBox.variable) {
            this.drawVariable(genericGraphBox);
            return;
        }
        Color color = this.preferences.commentColor;
        if (genericGraphBox.n_lignes == 0) {
            this.drawLine(genericGraphBox.X_in, genericGraphBox.Y_in, genericGraphBox.X_in + 15, genericGraphBox.Y_in, color);
            if (!this.preferences.rightToLeft) {
                this.drawLine(genericGraphBox.X_in + 15, genericGraphBox.Y1, genericGraphBox.X_in + 15, genericGraphBox.Y1 + genericGraphBox.Height, color);
            } else {
                this.drawLine(genericGraphBox.X_in, genericGraphBox.Y1, genericGraphBox.X_in, genericGraphBox.Y1 + genericGraphBox.Height, color);
            }
        } else {
            this.fillRect(genericGraphBox.X1, genericGraphBox.Y1, genericGraphBox.Width, genericGraphBox.Height, this.preferences.backgroundColor);
        }
        for (int i = 0; i < genericGraphBox.n_lignes; ++i) {
            Boolean bl = (Boolean)genericGraphBox.greyed.get(i);
            String string = (String)genericGraphBox.lines.get(i);
            if (bl.booleanValue()) {
                this.fillRect(genericGraphBox.X1 + 2, genericGraphBox.Y1 + 3 + i * this.h_ligne, genericGraphBox.Width - 4, this.h_ligne, this.preferences.subgraphColor);
            }
            this.drawText(string, genericGraphBox.X1 + 5, genericGraphBox.Y1 - this.descent + 3 + (i + 1) * this.h_ligne, color, this.input);
        }
        if (!genericGraphBox.transduction.equals("")) {
            this.drawText(genericGraphBox.transduction, genericGraphBox.X1 + 5, genericGraphBox.Y1 + genericGraphBox.Height + this.graphics.getFontMetrics().getHeight(), this.preferences.foregroundColor, this.output);
        }
    }

    private void drawVariable(GenericGraphBox genericGraphBox) throws IOException {
        Color color = this.preferences.commentColor;
        this.graphics.setFont(GenericGraphBox.variableFont);
        this.drawText((String)genericGraphBox.lines.get(0), genericGraphBox.X1 + 5, genericGraphBox.Y1 - this.graphics.getFontMetrics().getDescent() + this.graphics.getFontMetrics().getHeight(), color, GenericGraphBox.variableFont);
        this.graphics.setFont(this.output);
        this.drawText(genericGraphBox.transduction, genericGraphBox.X1 + 10, genericGraphBox.Y1 + genericGraphBox.Height + this.graphics.getFontMetrics().getHeight(), color, this.output);
    }

    private void drawFinal(GenericGraphBox genericGraphBox) throws IOException {
        this.drawCircle(genericGraphBox.x + 10, genericGraphBox.Y, 10, this.preferences.foregroundColor, this.preferences.backgroundColor);
        this.drawRect(genericGraphBox.x + 5, genericGraphBox.Y - 5, 10, 10, this.preferences.foregroundColor, 1);
    }

    private void drawCircle(int n, int n2, int n3, Color color, Color color2) throws IOException {
        this.writer.write("<circle cx=\"" + n + "\" cy=\"" + n2 + "\" r=\"" + n3 + "\" fill=\"" + this.rgb(color2) + "\" stroke=\"" + this.rgb(color) + "\"/>\n");
    }

    private void drawTransitions(GenericGraphBox genericGraphBox) throws IOException {
        ArrayList arrayList = genericGraphBox.getTransitions();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            GenericGraphBox genericGraphBox2 = (GenericGraphBox)arrayList.get(i);
            this.drawTransition(genericGraphBox, genericGraphBox2);
        }
    }

    private void drawTransition(GenericGraphBox genericGraphBox, GenericGraphBox genericGraphBox2) throws IOException {
        Color color = this.preferences.foregroundColor;
        if (!this.preferences.rightToLeft) {
            if (genericGraphBox2.X_in > genericGraphBox.X_out) {
                this.drawLine(genericGraphBox.X_out, genericGraphBox.Y_out, genericGraphBox2.X_in, genericGraphBox2.Y_in, color);
                return;
            }
            if (genericGraphBox.equals(genericGraphBox2)) {
                int n = 10 + genericGraphBox.Height / 2;
                int n2 = n / 2;
                this.drawArc1(genericGraphBox.X_out, genericGraphBox.Y_out, n2, color);
                this.drawArc2(genericGraphBox.X_out + n2, genericGraphBox.Y_out - n2, n2, color);
                this.drawArc3(genericGraphBox.X_in, genericGraphBox.Y_in - 2 * n2, n2, color);
                this.drawArc4(genericGraphBox.X_in - n2, genericGraphBox.Y_in - n2, n2, color);
                this.drawLine(genericGraphBox.X_out, genericGraphBox.Y_out - 2 * n2, genericGraphBox.X_in, genericGraphBox.Y_in - 2 * n2, color);
                return;
            }
            if (genericGraphBox.Y1 < genericGraphBox2.Y1 + genericGraphBox2.Height && genericGraphBox.Y1 + genericGraphBox.Height > genericGraphBox2.Y1) {
                int n = (10 + genericGraphBox.Height / 2) / 2;
                this.drawArc1(genericGraphBox.X_out, genericGraphBox.Y_out, n, color);
                this.drawArc2(genericGraphBox.X_out + n, genericGraphBox.Y_out - n, n, color);
                int n3 = (10 + genericGraphBox2.Height / 2) / 2;
                this.drawArc3(genericGraphBox2.X_in, genericGraphBox2.Y_in - 2 * n3, n3, color);
                this.drawArc4(genericGraphBox2.X_in - n3, genericGraphBox2.Y_in - n3, n3, color);
                int n4 = genericGraphBox2.X_in;
                int n5 = genericGraphBox2.Y_in - 2 * n3;
                int n6 = genericGraphBox.X_out;
                int n7 = genericGraphBox.Y_out - 2 * n;
                int n8 = (n6 + n4) / 2;
                int n9 = (n7 + n5) / 2;
                int n10 = 2 * n + 2 * n3;
                this.drawCurve(n4, n5, n4 + n10, n5, n8, n9, color);
                this.drawCurve(n6, n7, n6 - n10, n7, n8, n9, color);
                return;
            }
            if (genericGraphBox.Y1 < genericGraphBox2.Y1 + genericGraphBox2.Height) {
                int n = (10 + genericGraphBox.Height / 2) / 2;
                this.drawArc2(genericGraphBox.X_out + n, genericGraphBox.Y_out + n, n, color);
                int n11 = (10 + genericGraphBox2.Height / 2) / 2;
                this.drawArc4(genericGraphBox2.X_in - n11, genericGraphBox2.Y_in - n11, n11, color);
                int n12 = genericGraphBox2.X_in - 2 * n11 / 2;
                int n13 = genericGraphBox2.Y_in - 2 * n11 / 2;
                int n14 = genericGraphBox.X_out + 2 * n / 2;
                int n15 = genericGraphBox.Y_out + 2 * n / 2;
                int n16 = 2 * n + 2 * n11 - 20;
                int n17 = (n14 + n12) / 2;
                int n18 = (n15 + n13) / 2;
                this.drawCurve(n12, n13, n12, n13 - n16, n17, n18, color);
                this.drawCurve(n14, n15, n14, n15 + n16, n17, n18, color);
                return;
            }
            int n = (10 + genericGraphBox.Height / 2) / 2;
            this.drawArc1(genericGraphBox.X_out, genericGraphBox.Y_out, n, color);
            int n19 = (10 + genericGraphBox2.Height / 2) / 2;
            this.drawArc3(genericGraphBox2.X_in, genericGraphBox2.Y_in, n19, color);
            int n20 = genericGraphBox2.X_in - 2 * n19 / 2;
            int n21 = genericGraphBox2.Y_in + 2 * n19 / 2;
            int n22 = genericGraphBox.X_out + 2 * n / 2;
            int n23 = genericGraphBox.Y_out - 2 * n / 2;
            int n24 = 2 * n + 2 * n19 - 20;
            int n25 = (n22 + n20) / 2;
            int n26 = (n23 + n21) / 2;
            this.drawCurve(n20, n21, n20, n21 + n24, n25, n26, color);
            this.drawCurve(n22, n23, n22, n23 - n24, n25, n26, color);
            return;
        }
        if (genericGraphBox2.X_out - 5 < genericGraphBox.X_in - 5) {
            this.drawLine(genericGraphBox.X_in - 5, genericGraphBox.Y_in, genericGraphBox2.X_out - 5, genericGraphBox2.Y_out, color);
            return;
        }
        if (genericGraphBox.equals(genericGraphBox2)) {
            int n = (10 + genericGraphBox.Height / 2) / 2;
            this.drawArc1(genericGraphBox.X_out - 5, genericGraphBox.Y_out, n, color);
            this.drawArc2(genericGraphBox.X_out - 5 + n, genericGraphBox.Y_out - n, n, color);
            this.drawArc3(genericGraphBox.X_in - 5, genericGraphBox.Y_out - 2 * n, n, color);
            this.drawArc4(genericGraphBox.X_in - 5 - n, genericGraphBox.Y_out - n, n, color);
            this.drawLine(genericGraphBox.X_out - 5, genericGraphBox.Y_out - 2 * n, genericGraphBox.X_in - 5, genericGraphBox.Y_out - 2 * n, color);
            return;
        }
        if (genericGraphBox.Y1 < genericGraphBox2.Y1 + genericGraphBox2.Height && genericGraphBox.Y1 + genericGraphBox.Height > genericGraphBox2.Y1) {
            int n = (10 + genericGraphBox.Height / 2) / 2;
            int n27 = (10 + genericGraphBox2.Height / 2) / 2;
            this.drawArc3(genericGraphBox.X_in - 5, genericGraphBox.Y_in - 2 * n, n, color);
            this.drawArc4(genericGraphBox.X_in - 5 - n, genericGraphBox.Y_in - n, n, color);
            this.drawArc1(genericGraphBox2.X_out - 5, genericGraphBox2.Y_out, n27, color);
            this.drawArc2(genericGraphBox2.X_out - 5 + n27, genericGraphBox2.Y_out - n27, n27, color);
            int n28 = genericGraphBox2.X_out - 5;
            int n29 = genericGraphBox2.Y_out - 2 * n27;
            int n30 = genericGraphBox.X_in - 5;
            int n31 = genericGraphBox.Y_in - 2 * n;
            int n32 = (n28 + n30) / 2;
            int n33 = (n29 + n31) / 2;
            int n34 = 2 * n + 2 * n27;
            this.drawCurve(n30, n31, n30 + n34, n31, n32, n33, color);
            this.drawCurve(n28, n29, n28 - n34, n29, n32, n33, color);
            return;
        }
        if (genericGraphBox.Y1 < genericGraphBox2.Y1 + genericGraphBox2.Height) {
            int n = (10 + genericGraphBox.Height / 2) / 2;
            this.drawArc3(genericGraphBox.X_in - 5, genericGraphBox.Y_in, n, color);
            int n35 = (10 + genericGraphBox2.Height / 2) / 2;
            this.drawArc1(genericGraphBox2.X_out - 5, genericGraphBox2.Y_out, n35, color);
            int n36 = genericGraphBox2.X_out - 5 + 2 * n35 / 2;
            int n37 = genericGraphBox2.Y_out - 2 * n35 / 2;
            int n38 = genericGraphBox.X_in - 5 - 2 * n / 2;
            int n39 = genericGraphBox.Y_in + 2 * n / 2;
            int n40 = 2 * n + 2 * n35 - 20;
            int n41 = (n38 + n36) / 2;
            int n42 = (n39 + n37) / 2;
            this.drawCurve(n36, n37, n36, n37 - n40, n41, n42, color);
            this.drawCurve(n38, n39, n38, n39 + n40, n41, n42, color);
            return;
        }
        int n = (10 + genericGraphBox.Height / 2) / 2;
        this.drawArc4(genericGraphBox.X_in - 5 - n, genericGraphBox.Y_in - n, n, color);
        int n43 = (10 + genericGraphBox2.Height / 2) / 2;
        this.drawArc2(genericGraphBox2.X_out - 5 + n43, genericGraphBox2.Y_out + n43, n43, color);
        int n44 = genericGraphBox2.X_out - 5 + 2 * n43 / 2;
        int n45 = genericGraphBox2.Y_out + 2 * n43 / 2;
        int n46 = genericGraphBox.X_in - 5 - 2 * n / 2;
        int n47 = genericGraphBox.Y_in - 2 * n / 2;
        int n48 = 2 * n + 2 * n43 - 20;
        int n49 = (n46 + n44) / 2;
        int n50 = (n47 + n45) / 2;
        this.drawCurve(n44, n45, n44, n45 + n48, n49, n50, color);
        this.drawCurve(n46, n47, n46, n47 - n48, n49, n50, color);
    }

    private void drawCurve(int n, int n2, int n3, int n4, int n5, int n6, Color color) throws IOException {
        this.writer.write("<path d=\"M" + n + "," + n2 + " Q" + n3 + "," + n4 + " " + n5 + "," + n6 + "\" fill=\"none\" stroke=\"" + this.rgb(color) + "\"/>\n");
    }

    private void drawArc1(int n, int n2, int n3, Color color) throws IOException {
        this.writer.write("<path d=\"M" + n + "," + n2 + " a" + n3 + ",-" + n3 + " 0 0,0 " + n3 + ",-" + n3 + "\" fill=\"none\" stroke=\"" + this.rgb(color) + "\"/>\n");
    }

    private void drawArc2(int n, int n2, int n3, Color color) throws IOException {
        this.writer.write("<path d=\"M" + n + "," + n2 + " a-" + n3 + ",-" + n3 + " 0 0,0 -" + n3 + ",-" + n3 + "\" fill=\"none\" stroke=\"" + this.rgb(color) + "\"/>\n");
    }

    private void drawArc3(int n, int n2, int n3, Color color) throws IOException {
        this.writer.write("<path d=\"M" + n + "," + n2 + " a-" + n3 + "," + n3 + " 0 0,0 -" + n3 + "," + n3 + "\" fill=\"none\" stroke=\"" + this.rgb(color) + "\"/>\n");
    }

    private void drawArc4(int n, int n2, int n3, Color color) throws IOException {
        this.writer.write("<path d=\"M" + n + "," + n2 + " a" + n3 + "," + n3 + " 0 0,0 " + n3 + "," + n3 + "\" fill=\"none\" stroke=\"" + this.rgb(color) + "\"/>\n");
    }

    private void drawLine(int n, int n2, int n3, int n4, Color color) throws IOException {
        this.writer.write("<line stroke=\"" + this.rgb(color) + "\"  x1=\"" + n + "\" y1=\"" + n2 + "\" x2=\"" + n3 + "\" y2=\"" + n4 + "\"/>\n");
    }

    private void drawText(String string, int n, int n2, Color color, Font font) throws IOException {
        this.writer.write("<text x=\"" + n + "\" y=\"" + n2 + "\" font-family=\"" + font.getFamily() + "\" font-size=\"" + font.getSize() + "\" fill=\"" + this.rgb(color) + "\">");
        this.writer.write(this.replaceXMLChars(string));
        this.writer.write("</text>\n");
    }

    private String replaceXMLChars(String string) {
        String string2 = string.replaceAll("&", "&amp;");
        string2 = string2.replaceAll("<", "&lt;");
        return string2.replaceAll(">", "&gt;");
    }

    private void fillRect(int n, int n2, int n3, int n4, Color color) throws IOException {
        this.writer.write("<rect stroke=\"none\" fill=\"" + this.rgb(color) + "\" x=\"" + n + "\" y=\"" + n2 + "\" width=\"" + n3 + "\" height=\"" + n4 + "\"/>\n");
    }

    private void drawRect(int n, int n2, int n3, int n4, Color color, int n5) throws IOException {
        this.writer.write("<rect stroke=\"" + this.rgb(color) + "\" stroke-width=\"" + n5 + "\" fill=\"none\" x=\"" + n + "\" y=\"" + n2 + "\" width=\"" + n3 + "\" height=\"" + n4 + "\"/>\n");
    }

    private String rgb(Color color) {
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }
}

