/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.unitex.io;

import fr.umlv.unitex.GenericGraphBox;
import fr.umlv.unitex.GenericGraphicalZone;
import fr.umlv.unitex.GraphBox;
import fr.umlv.unitex.Preferences;
import fr.umlv.unitex.exceptions.BackSlashAtEndOfLineException;
import fr.umlv.unitex.exceptions.MissingGraphNameException;
import fr.umlv.unitex.exceptions.NoClosingQuoteException;
import fr.umlv.unitex.exceptions.NoClosingRoundBracketException;
import fr.umlv.unitex.exceptions.NoClosingSupException;
import fr.umlv.unitex.exceptions.NotAUnicodeLittleEndianFileException;
import fr.umlv.unitex.io.UnicodeIO;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GraphIO {
    public ArrayList boxes;
    public Preferences pref = new Preferences();
    public int width;
    public int height;
    public int nBoxes;

    public static GraphIO loadGraph(File file) {
        String string = file.getAbsolutePath();
        if (string.endsWith(".xgrf")) {
            return GraphIO.loadXGrf(file, null);
        }
        if (string.endsWith(".grf")) {
            return GraphIO.loadGrf(file);
        }
        return null;
    }

    public static GraphIO loadGraph(File file, GenericGraphicalZone genericGraphicalZone) {
        String string = file.getAbsolutePath();
        if (string.endsWith(".xgrf")) {
            return GraphIO.loadXGrf(file, genericGraphicalZone);
        }
        if (string.endsWith(".grf")) {
            return GraphIO.loadGrf(file);
        }
        return null;
    }

    private void loadInputFont(String string) {
        String string2 = "";
        int n = string.indexOf(58);
        string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, n + 3);
        String string4 = string.substring(n + 3);
        boolean bl = string3.charAt(0) == 'B';
        boolean bl2 = string3.charAt(1) == 'I';
        this.pref.inputSize = Integer.parseInt(string4);
        int n2 = bl && bl2 ? 3 : (bl ? 1 : (bl2 ? 2 : 0));
        this.pref.input = new Font(string2, n2, (int)((double)this.pref.inputSize / 0.72));
    }

    private void loadOutputFont(String string) {
        String string2 = "";
        int n = string.indexOf(58);
        string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, n + 3);
        String string4 = string.substring(n + 3);
        boolean bl = string3.charAt(0) == 'B';
        boolean bl2 = string3.charAt(1) == 'I';
        this.pref.outputSize = Integer.parseInt(string4);
        int n2 = bl && bl2 ? 3 : (bl ? 1 : (bl2 ? 2 : 0));
        this.pref.output = new Font(string2, n2, (int)((double)this.pref.outputSize / 0.72));
    }

    public void loadBColor(Color color) {
        this.pref.backgroundColor = color;
    }

    public void loadFColor(Color color) {
        this.pref.foregroundColor = color;
    }

    public void loadAColor(Color color) {
        this.pref.subgraphColor = color;
    }

    public void loadSColor(Color color) {
        this.pref.commentColor = color;
    }

    public void loadCColor(Color color) {
        this.pref.selectedColor = color;
    }

    private void loadDrawFrame(String string) {
        this.pref.frame = string.equals("y");
    }

    private void loadDate(String string) {
        this.pref.date = string.equals("y");
    }

    private void loadFile(String string) {
        this.pref.filename = string.equals("y");
    }

    private void loadDirectory(String string) {
        this.pref.pathname = string.equals("y");
    }

    private void loadRightToLeft(String string) {
        this.pref.rightToLeft = string.equals("y");
    }

    private void loadBoxNumber(int n) {
        this.nBoxes = n;
    }

    private void loadBox(Element element) {
        String string;
        Object object;
        int n = Integer.parseInt(element.getAttribute("id"));
        int n2 = Integer.parseInt(element.getAttribute("x"));
        int n3 = Integer.parseInt(element.getAttribute("y"));
        GenericGraphBox genericGraphBox = (GenericGraphBox)this.boxes.get(n);
        Element element2 = (Element)element.getElementsByTagName("labels").item(0);
        int n4 = Integer.parseInt(element2.getAttribute("number"));
        NodeList nodeList = element2.getElementsByTagName("label");
        String string2 = "";
        for (int i = 0; i < n4; ++i) {
            object = (Element)nodeList.item(i);
            string = "+";
            if (i == 0) {
                string = "";
            }
            string2 = string2 + string + "" + object.getAttribute("value");
        }
        Element element3 = (Element)element.getElementsByTagName("out").item(0);
        object = element3.getAttribute("value");
        genericGraphBox.setX(n2);
        genericGraphBox.setY(n3);
        genericGraphBox.setX1(genericGraphBox.getX());
        genericGraphBox.setY1(genericGraphBox.getY());
        genericGraphBox.setX_in(genericGraphBox.getX());
        genericGraphBox.setY_in(genericGraphBox.getY());
        genericGraphBox.setX_out(genericGraphBox.getX() + genericGraphBox.getWidth() + 5);
        genericGraphBox.setY_out(genericGraphBox.getY_in());
        if (n != 1) {
            genericGraphBox.setContent(string2, (String)object);
        } else {
            genericGraphBox.setContent("<E>", "");
            genericGraphBox.setX_in(genericGraphBox.getX());
            genericGraphBox.setY_in(genericGraphBox.getY());
            genericGraphBox.setX1(genericGraphBox.getX());
            genericGraphBox.setY1(genericGraphBox.getY() - 10);
            genericGraphBox.setY_out(genericGraphBox.getY_in());
            genericGraphBox.setX_out(genericGraphBox.getX_in() + 25);
        }
        element2 = (Element)element.getElementsByTagName("trans").item(0);
        string = element2.getAttribute("dest");
        String[] stringArray = string.split(" +");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                int n5 = Integer.parseInt(stringArray[i]);
                genericGraphBox.addTransitionTo((GenericGraphBox)this.boxes.get(n5));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void loadProperty(GraphIO graphIO, String string, String string2) {
        if (string == null) {
            return;
        }
        if (string2 == null) {
            return;
        }
        if (string.equals("width")) {
            graphIO.width = Integer.parseInt(string2);
            return;
        }
        if (string.equals("height")) {
            graphIO.height = Integer.parseInt(string2);
            return;
        }
        if (string.equals("font")) {
            graphIO.loadInputFont(string2);
            return;
        }
        if (string.equals("ofont")) {
            graphIO.loadOutputFont(string2);
            return;
        }
        if (string.equals("bcolor")) {
            graphIO.loadBColor(new Color(Integer.parseInt(string2)));
            return;
        }
        if (string.equals("fcolor")) {
            graphIO.loadFColor(new Color(Integer.parseInt(string2)));
            return;
        }
        if (string.equals("acolor")) {
            graphIO.loadAColor(new Color(Integer.parseInt(string2)));
            return;
        }
        if (string.equals("scolor")) {
            graphIO.loadSColor(new Color(Integer.parseInt(string2)));
            return;
        }
        if (string.equals("ccolor")) {
            graphIO.loadCColor(new Color(Integer.parseInt(string2)));
            return;
        }
        if (string.equals("dframe")) {
            graphIO.loadDrawFrame(string2);
            return;
        }
        if (string.equals("ddate")) {
            graphIO.loadDate(string2);
            return;
        }
        if (string.equals("dfile")) {
            graphIO.loadFile(string2);
            return;
        }
        if (string.equals("ddir")) {
            graphIO.loadDirectory(string2);
            return;
        }
        if (string.equals("drig")) {
            graphIO.loadRightToLeft(string2);
            return;
        }
    }

    public static GraphIO loadXGrf(File file, GenericGraphicalZone genericGraphicalZone) {
        GraphIO graphIO = new GraphIO();
        graphIO.boxes = new ArrayList();
        try {
            int n;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            Element element = (Element)document.getElementsByTagName("header").item(0);
            if (element == null) {
                return null;
            }
            NodeList nodeList = element.getElementsByTagName("prop");
            for (n = 0; n < nodeList.getLength(); ++n) {
                Element element2 = (Element)nodeList.item(n);
                if (!element2.getTagName().equals("prop")) continue;
                GraphIO.loadProperty(graphIO, element2.getAttribute("name"), element2.getAttribute("value"));
            }
            element = (Element)document.getElementsByTagName("boxes").item(0);
            if (element == null) {
                return null;
            }
            graphIO.loadBoxNumber(Integer.parseInt(element.getAttribute("number")));
            graphIO.boxes.add(new GraphBox(0, 0, 0, genericGraphicalZone));
            graphIO.boxes.add(new GraphBox(0, 0, 1, genericGraphicalZone));
            for (n = 2; n < graphIO.nBoxes; ++n) {
                graphIO.boxes.add(new GraphBox(0, 0, 2, genericGraphicalZone));
            }
            NodeList nodeList2 = document.getElementsByTagName("box");
            for (int i = 0; i < graphIO.nBoxes; ++i) {
                graphIO.loadBox((Element)nodeList2.item(i));
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println(" " + sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            (exception == null ? sAXException : exception).printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            graphIO = null;
        }
        return graphIO;
    }

    public static GraphIO loadGrf(File file) {
        GraphIO graphIO = new GraphIO();
        if (!file.exists()) {
            JOptionPane.showMessageDialog(null, "Cannot find " + file.getAbsolutePath(), "Error", 0);
            return null;
        }
        if (!file.canRead()) {
            JOptionPane.showMessageDialog(null, "Cannot read " + file.getAbsolutePath(), "Error", 0);
            return null;
        }
        if (file.length() <= 2L) {
            JOptionPane.showMessageDialog(null, file.getAbsolutePath() + " is empty", "Error", 0);
            return null;
        }
        try {
            int n;
            FileInputStream fileInputStream = UnicodeIO.openUnicodeLittleEndianFileInputStream(file);
            UnicodeIO.skipLine(fileInputStream);
            graphIO.readSize(fileInputStream);
            graphIO.readInputFont(fileInputStream);
            graphIO.readOutputFont(fileInputStream);
            graphIO.readBackgroundColor(fileInputStream);
            graphIO.readForegroundColor(fileInputStream);
            graphIO.readSubgraphColor(fileInputStream);
            graphIO.readCommentColor(fileInputStream);
            graphIO.readSelectedColor(fileInputStream);
            UnicodeIO.skipLine(fileInputStream);
            graphIO.readDrawFrame(fileInputStream);
            graphIO.readDate(fileInputStream);
            graphIO.readFile(fileInputStream);
            graphIO.readDirectory(fileInputStream);
            graphIO.readRightToLeft(fileInputStream);
            UnicodeIO.skipLine(fileInputStream);
            UnicodeIO.skipLine(fileInputStream);
            UnicodeIO.skipLine(fileInputStream);
            UnicodeIO.skipLine(fileInputStream);
            graphIO.readBoxNumber(fileInputStream);
            graphIO.boxes = new ArrayList();
            graphIO.boxes.add(new GraphBox(0, 0, 0, null));
            graphIO.boxes.add(new GraphBox(0, 0, 1, null));
            for (n = 2; n < graphIO.nBoxes; ++n) {
                graphIO.boxes.add(new GraphBox(0, 0, 2, null));
            }
            for (n = 0; n < graphIO.nBoxes; ++n) {
                graphIO.readGraphLine(fileInputStream, n);
            }
            fileInputStream.close();
        }
        catch (NotAUnicodeLittleEndianFileException notAUnicodeLittleEndianFileException) {
            JOptionPane.showMessageDialog(null, file.getAbsolutePath() + " is not a Unicode Little-Endian graph", "Error", 0);
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return graphIO;
    }

    private void readSize(FileInputStream fileInputStream) {
        char c;
        UnicodeIO.skipChars(fileInputStream, 5);
        this.width = 0;
        while (UnicodeIO.isDigit(c = (char)UnicodeIO.readChar(fileInputStream))) {
            this.width = this.width * 10 + (c - 48);
        }
        while (UnicodeIO.isDigit(c = (char)UnicodeIO.readChar(fileInputStream))) {
            this.height = this.height * 10 + (c - 48);
        }
    }

    private void readInputFont(FileInputStream fileInputStream) {
        char c;
        UnicodeIO.skipChars(fileInputStream, 5);
        String string = "";
        while ((c = (char)UnicodeIO.readChar(fileInputStream)) != ':') {
            string = string + c;
        }
        boolean bl = UnicodeIO.readChar(fileInputStream) == 66;
        boolean bl2 = UnicodeIO.readChar(fileInputStream) == 73;
        int n = 0;
        while (UnicodeIO.isDigit(c = (char)UnicodeIO.readChar(fileInputStream))) {
            n = n * 10 + (c - 48);
        }
        this.pref.inputSize = n;
        int n2 = bl && bl2 ? 3 : (bl ? 1 : (bl2 ? 2 : 0));
        this.pref.input = new Font(string, n2, (int)((double)n / 0.72));
    }

    private void readOutputFont(FileInputStream fileInputStream) {
        char c;
        UnicodeIO.skipChars(fileInputStream, 6);
        String string = "";
        while ((c = (char)UnicodeIO.readChar(fileInputStream)) != ':') {
            string = string + c;
        }
        boolean bl = UnicodeIO.readChar(fileInputStream) == 66;
        boolean bl2 = UnicodeIO.readChar(fileInputStream) == 73;
        int n = 0;
        while (UnicodeIO.isDigit(c = (char)UnicodeIO.readChar(fileInputStream))) {
            n = n * 10 + (c - 48);
        }
        this.pref.outputSize = n;
        int n2 = bl && bl2 ? 3 : (bl ? 1 : (bl2 ? 2 : 0));
        this.pref.output = new Font(string, n2, (int)((double)n / 0.72));
    }

    private void readBackgroundColor(FileInputStream fileInputStream) {
        char c;
        UnicodeIO.skipChars(fileInputStream, 7);
        int n = 0;
        while (UnicodeIO.isDigit(c = (char)UnicodeIO.readChar(fileInputStream))) {
            n = n * 10 + (c - 48);
        }
        this.pref.backgroundColor = new Color(n);
    }

    private void readForegroundColor(FileInputStream fileInputStream) {
        char c;
        UnicodeIO.skipChars(fileInputStream, 7);
        int n = 0;
        while (UnicodeIO.isDigit(c = (char)UnicodeIO.readChar(fileInputStream))) {
            n = n * 10 + (c - 48);
        }
        this.pref.foregroundColor = new Color(n);
    }

    private void readSubgraphColor(FileInputStream fileInputStream) {
        char c;
        UnicodeIO.skipChars(fileInputStream, 7);
        int n = 0;
        while (UnicodeIO.isDigit(c = (char)UnicodeIO.readChar(fileInputStream))) {
            n = n * 10 + (c - 48);
        }
        this.pref.subgraphColor = new Color(n);
    }

    private void readSelectedColor(FileInputStream fileInputStream) {
        char c;
        UnicodeIO.skipChars(fileInputStream, 7);
        int n = 0;
        while (UnicodeIO.isDigit(c = (char)UnicodeIO.readChar(fileInputStream))) {
            n = n * 10 + (c - 48);
        }
        this.pref.selectedColor = new Color(n);
    }

    private void readCommentColor(FileInputStream fileInputStream) {
        char c;
        UnicodeIO.skipChars(fileInputStream, 7);
        int n = 0;
        while (UnicodeIO.isDigit(c = (char)UnicodeIO.readChar(fileInputStream))) {
            n = n * 10 + (c - 48);
        }
        this.pref.commentColor = new Color(n);
    }

    private void readDrawFrame(FileInputStream fileInputStream) {
        UnicodeIO.skipChars(fileInputStream, 7);
        this.pref.frame = UnicodeIO.readChar(fileInputStream) == 121;
        UnicodeIO.readChar(fileInputStream);
    }

    private void readDate(FileInputStream fileInputStream) {
        UnicodeIO.skipChars(fileInputStream, 6);
        this.pref.date = UnicodeIO.readChar(fileInputStream) == 121;
        UnicodeIO.readChar(fileInputStream);
    }

    private void readFile(FileInputStream fileInputStream) {
        UnicodeIO.skipChars(fileInputStream, 6);
        this.pref.filename = UnicodeIO.readChar(fileInputStream) == 121;
        UnicodeIO.readChar(fileInputStream);
    }

    private void readDirectory(FileInputStream fileInputStream) {
        UnicodeIO.skipChars(fileInputStream, 5);
        this.pref.pathname = UnicodeIO.readChar(fileInputStream) == 121;
        UnicodeIO.readChar(fileInputStream);
    }

    private void readRightToLeft(FileInputStream fileInputStream) {
        UnicodeIO.skipChars(fileInputStream, 5);
        this.pref.rightToLeft = UnicodeIO.readChar(fileInputStream) == 121;
        UnicodeIO.readChar(fileInputStream);
    }

    private void readBoxNumber(FileInputStream fileInputStream) {
        char c;
        this.nBoxes = 0;
        while (UnicodeIO.isDigit(c = (char)UnicodeIO.readChar(fileInputStream))) {
            this.nBoxes = this.nBoxes * 10 + (c - 48);
        }
    }

    private void readGraphLine(FileInputStream fileInputStream, int n) {
        char c;
        GenericGraphBox genericGraphBox = (GenericGraphBox)this.boxes.get(n);
        if (UnicodeIO.readChar(fileInputStream) == 115) {
            UnicodeIO.readChar(fileInputStream);
        }
        String string = "";
        while ((c = (char)UnicodeIO.readChar(fileInputStream)) != '\"') {
            if (c == '\\') {
                c = (char)UnicodeIO.readChar(fileInputStream);
                if (c != '\\') {
                    if (c == '\"') {
                        string = string + c;
                        continue;
                    }
                    string = string + "\\" + c;
                    continue;
                }
                c = (char)UnicodeIO.readChar(fileInputStream);
                if (c == '\\') {
                    c = (char)UnicodeIO.readChar(fileInputStream);
                    string = string + "\\" + c;
                    continue;
                }
                string = string + "\\\\";
                if (c == '\"') break;
                string = string + c;
                continue;
            }
            string = string + c;
        }
        UnicodeIO.readChar(fileInputStream);
        int n2 = 0;
        int n3 = 1;
        c = (char)UnicodeIO.readChar(fileInputStream);
        if (c == '-') {
            n3 = -1;
        } else if (UnicodeIO.isDigit(c)) {
            n2 = c - 48;
        }
        while (UnicodeIO.isDigit(c = (char)UnicodeIO.readChar(fileInputStream))) {
            n2 = n2 * 10 + (c - 48);
        }
        n2 *= n3;
        int n4 = 0;
        n3 = 1;
        c = (char)UnicodeIO.readChar(fileInputStream);
        if (c == '-') {
            n3 = -1;
        } else if (UnicodeIO.isDigit(c)) {
            n4 = c - 48;
        }
        while (UnicodeIO.isDigit(c = (char)UnicodeIO.readChar(fileInputStream))) {
            n4 = n4 * 10 + (c - 48);
        }
        genericGraphBox.setX(n2);
        genericGraphBox.setY(n4 *= n3);
        genericGraphBox.setX1(genericGraphBox.getX());
        genericGraphBox.setY1(genericGraphBox.getY());
        genericGraphBox.setX_in(genericGraphBox.getX());
        genericGraphBox.setY_in(genericGraphBox.getY());
        genericGraphBox.setX_out(genericGraphBox.getX() + genericGraphBox.getWidth() + 5);
        genericGraphBox.setY_out(genericGraphBox.getY_in());
        if (n != 1) {
            genericGraphBox.setGrfContent(string);
        } else {
            genericGraphBox.setGrfContent("<E>");
            genericGraphBox.setX_in(genericGraphBox.getX());
            genericGraphBox.setY_in(genericGraphBox.getY());
            genericGraphBox.setX1(genericGraphBox.getX());
            genericGraphBox.setY1(genericGraphBox.getY() - 10);
            genericGraphBox.setY_out(genericGraphBox.getY_in());
            genericGraphBox.setX_out(genericGraphBox.getX_in() + 25);
        }
        int n5 = 0;
        while (UnicodeIO.isDigit(c = (char)UnicodeIO.readChar(fileInputStream))) {
            n5 = n5 * 10 + (c - 48);
        }
        for (int i = 0; i < n5; ++i) {
            int n6 = 0;
            while (UnicodeIO.isDigit(c = (char)UnicodeIO.readChar(fileInputStream))) {
                n6 = n6 * 10 + (c - 48);
            }
            genericGraphBox.addTransitionTo((GenericGraphBox)this.boxes.get(n6));
        }
        UnicodeIO.readChar(fileInputStream);
    }

    public void saveGraph(File file) {
        String string = file.getAbsolutePath();
        if (string.endsWith(".grf") || string.endsWith(".grf8") || string.endsWith(".xgrf")) {
            string = string.substring(0, string.lastIndexOf(46));
        }
        this.saveXGrf(new File(string + ".xgrf"));
        this.saveGrf(new File(string + ".grf"), "UTF-16LE");
        this.saveGrf(new File(string + ".grf8"), "UTF-8");
    }

    private String getInputFont() {
        String string = this.pref.input.getName() + ":";
        string = this.pref.input.getStyle() == 0 ? string + "  " : (this.pref.input.getStyle() == 1 ? string + "B " : (this.pref.input.getStyle() == 2 ? string + " I" : string + "BI"));
        string = string + String.valueOf(this.pref.inputSize);
        return string;
    }

    private String getOutputFont() {
        String string = this.pref.output.getName() + ":";
        string = this.pref.output.getStyle() == 0 ? string + "  " : (this.pref.output.getStyle() == 1 ? string + "B " : (this.pref.output.getStyle() == 2 ? string + " I" : string + "BI"));
        string = string + String.valueOf(this.pref.outputSize);
        return string;
    }

    private String getRGB(int n) {
        return String.valueOf(0x1000000 + n);
    }

    private String getBoolean(boolean bl) {
        if (bl) {
            return "y";
        }
        return "n";
    }

    public void writeXGrfHeader(OutputStreamWriter outputStreamWriter) throws IOException {
        try {
            outputStreamWriter.write("<header>\n");
            outputStreamWriter.write("<prop name=\"width\" value=\"" + this.width + "\"/>\n");
            outputStreamWriter.write("<prop name=\"height\" value=\"" + this.height + "\"/>\n");
            outputStreamWriter.write("<prop name=\"font\" value=\"" + this.getInputFont() + "\"/>\n");
            outputStreamWriter.write("<prop name=\"ofont\" value=\"" + this.getOutputFont() + "\"/>\n");
            outputStreamWriter.write("<prop name=\"bcolor\" value=\"" + this.getRGB(this.pref.backgroundColor.getRGB()) + "\"/>\n");
            outputStreamWriter.write("<prop name=\"fcolor\" value=\"" + this.getRGB(this.pref.foregroundColor.getRGB()) + "\"/>\n");
            outputStreamWriter.write("<prop name=\"acolor\" value=\"" + this.getRGB(this.pref.subgraphColor.getRGB()) + "\"/>\n");
            outputStreamWriter.write("<prop name=\"scolor\" value=\"" + this.getRGB(this.pref.commentColor.getRGB()) + "\"/>\n");
            outputStreamWriter.write("<prop name=\"ccolor\" value=\"" + this.getRGB(this.pref.selectedColor.getRGB()) + "\"/>\n");
            outputStreamWriter.write("<prop name=\"dframe\" value=\"" + this.getBoolean(this.pref.frame) + "\"/>\n");
            outputStreamWriter.write("<prop name=\"ddate\" value=\"" + this.getBoolean(this.pref.date) + "\"/>\n");
            outputStreamWriter.write("<prop name=\"dfile\" value=\"" + this.getBoolean(this.pref.filename) + "\"/>\n");
            outputStreamWriter.write("<prop name=\"ddir\" value=\"" + this.getBoolean(this.pref.pathname) + "\"/>\n");
            outputStreamWriter.write("<prop name=\"drig\" value=\"" + this.getBoolean(this.pref.rightToLeft) + "\"/>\n");
            outputStreamWriter.write("</header>\n");
        }
        catch (IOException iOException) {
            throw new IOException();
        }
    }

    private String getNormalizedContent(String string) {
        int n = string.length();
        String string2 = string;
        string2 = string2.replaceAll("&", "&amp;");
        string2 = string2.replaceAll("\"", "&quot;");
        string2 = string2.replaceAll("<", "&lt;");
        string2 = string2.replaceAll(">", "&gt;");
        string2 = string2.replaceAll("'", "&#39;");
        return string2;
    }

    private String getLabelAtt(String string, String string2, String string3) {
        String string4 = this.getNormalizedContent(string);
        String string5 = this.getNormalizedContent(string2);
        String string6 = string3;
        String string7 = "";
        string7 = string7 + "in=\"" + string4 + "\" ";
        string7 = string7 + "out=\"" + string5 + "\" ";
        try {
            new Double(string3);
            string6 = string3;
        }
        catch (Exception exception) {
            string6 = "";
        }
        string7 = string7 + "weight=\"" + string6 + "\"";
        return string7;
    }

    private String getContent(ArrayList arrayList) {
        String string = "<labels number=\"" + arrayList.size() + "\">\n";
        for (int i = 0; i < arrayList.size(); ++i) {
            string = string + "<label value=\"" + this.getNormalizedContent((String)arrayList.get(i)) + "\"/>\n";
        }
        string = string + "</labels>\n";
        return string;
    }

    private String getOutput(String string) {
        return "<out value=\"" + this.getNormalizedContent(string) + "\"/>\n";
    }

    private String getWeight(String string) {
        String string2 = "";
        try {
            new Double(string);
            string2 = string;
        }
        catch (Exception exception) {
            string2 = "";
        }
        return "<weight value=\"" + string2 + "\"/>\n";
    }

    private String getTransitions(GenericGraphBox genericGraphBox) {
        int n = genericGraphBox.getTransitions().size();
        String string = "<trans dest=\"";
        for (int i = 0; i < n; ++i) {
            String string2 = " ";
            if (i == 0) {
                string2 = "";
            }
            GenericGraphBox genericGraphBox2 = (GenericGraphBox)genericGraphBox.getTransitions().get(i);
            string = string + string2 + "" + this.boxes.indexOf(genericGraphBox2);
        }
        string = string + "\"/>\n";
        return string;
    }

    public void writeXGrfBoxes(OutputStreamWriter outputStreamWriter) throws IOException {
        try {
            this.nBoxes = this.boxes.size();
            outputStreamWriter.write("<boxes number=\"" + this.nBoxes + "\">\n");
            for (int i = 0; i < this.nBoxes; ++i) {
                ArrayList arrayList;
                GenericGraphBox genericGraphBox = (GenericGraphBox)this.boxes.get(i);
                outputStreamWriter.write("<box id=\"" + i + "\" x=\"" + genericGraphBox.getX() + "\" y=\"" + genericGraphBox.getY() + "\">\n");
                try {
                    arrayList = this.tokenizeTextWithoutTransduction(genericGraphBox.getContent());
                }
                catch (Exception exception) {
                    arrayList = new ArrayList();
                }
                outputStreamWriter.write(this.getContent(arrayList));
                outputStreamWriter.write(this.getOutput(genericGraphBox.getTransduction()));
                outputStreamWriter.write(this.getTransitions(genericGraphBox));
                outputStreamWriter.write("</box>\n");
            }
            outputStreamWriter.write("</boxes>\n");
        }
        catch (IOException iOException) {
            throw new IOException();
        }
    }

    public void saveXGrf(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Cannot write " + file.getAbsolutePath(), "Error", 0);
            return;
        }
        if (!file.canWrite()) {
            JOptionPane.showMessageDialog(null, "Cannot write " + file.getAbsolutePath(), "Error", 0);
            return;
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            outputStreamWriter.write("<xgrf>\n");
            this.writeXGrfHeader(outputStreamWriter);
            this.writeXGrfBoxes(outputStreamWriter);
            outputStreamWriter.write("</xgrf>\n");
            outputStreamWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void write_content(FileOutputStream fileOutputStream, String string, String string2) {
        String string3 = string + "/" + string2;
        boolean bl = false;
        int n = string3.length();
        for (int i = 0; i < n; ++i) {
            char c = string3.charAt(i);
            if (c == '\"') {
                if (i == 0 || string3.charAt(i - 1) != '\\') {
                    UnicodeIO.writeChar(fileOutputStream, '\\');
                    UnicodeIO.writeChar(fileOutputStream, '\"');
                    continue;
                }
                UnicodeIO.writeChar(fileOutputStream, '\\');
                UnicodeIO.writeChar(fileOutputStream, '\\');
                UnicodeIO.writeChar(fileOutputStream, '\"');
                continue;
            }
            UnicodeIO.writeChar(fileOutputStream, c);
        }
    }

    public void saveGrf(File file, String string) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Cannot write " + file.getAbsolutePath(), "Error", 0);
            return;
        }
        if (!file.canWrite()) {
            JOptionPane.showMessageDialog(null, "Cannot write " + file.getAbsolutePath(), "Error", 0);
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string));
            if (string.equals("UTF-16LE")) {
                printWriter.print('\ufeff');
            }
            printWriter.println("#unigraphII");
            printWriter.println("SIZE " + this.width + " " + this.height);
            printWriter.print("FONT " + this.pref.input.getName() + ":");
            if (this.pref.input.getStyle() == 0) {
                printWriter.print("  ");
            } else if (this.pref.input.getStyle() == 1) {
                printWriter.print("B ");
            } else if (this.pref.input.getStyle() == 2) {
                printWriter.print(" I");
            } else {
                printWriter.print("BI");
            }
            printWriter.println(this.pref.inputSize);
            printWriter.print("OFONT " + this.pref.output.getName() + ":");
            if (this.pref.output.getStyle() == 0) {
                printWriter.print("  ");
            } else if (this.pref.output.getStyle() == 1) {
                printWriter.print("B ");
            } else if (this.pref.output.getStyle() == 2) {
                printWriter.print(" I");
            } else {
                printWriter.print("BI");
            }
            printWriter.println(this.pref.outputSize);
            printWriter.println("BCOLOR " + String.valueOf(0x1000000 + this.pref.backgroundColor.getRGB()));
            printWriter.println("FCOLOR " + String.valueOf(0x1000000 + this.pref.foregroundColor.getRGB()));
            printWriter.println("ACOLOR " + String.valueOf(0x1000000 + this.pref.subgraphColor.getRGB()));
            printWriter.println("SCOLOR " + String.valueOf(0x1000000 + this.pref.commentColor.getRGB()));
            printWriter.println("SCOLOR " + String.valueOf(0x1000000 + this.pref.selectedColor.getRGB()));
            printWriter.println("DBOXES y");
            printWriter.println("DFRAME y");
            printWriter.println("DDATE n");
            printWriter.println("DFILE y");
            printWriter.println("DDIR n");
            printWriter.println("DRIG n");
            printWriter.println("DRST n");
            printWriter.println("FITS 100");
            printWriter.println("PORIENT L");
            printWriter.println("#");
            this.nBoxes = this.boxes.size();
            printWriter.println(this.nBoxes);
            for (int i = 0; i < this.nBoxes; ++i) {
                GenericGraphBox genericGraphBox = (GenericGraphBox)this.boxes.get(i);
                printWriter.print('\"');
                if (genericGraphBox.getType() != 1) {
                    printWriter.print(genericGraphBox.getContent());
                    if (genericGraphBox.getTransduction().length() != 0) {
                        printWriter.print("/" + genericGraphBox.getTransduction());
                    }
                }
                printWriter.print("\" ");
                int n = genericGraphBox.getTransitions().size();
                printWriter.print(String.valueOf(genericGraphBox.getX()) + " " + String.valueOf(genericGraphBox.getY()) + " " + String.valueOf(n) + " ");
                for (int j = 0; j < n; ++j) {
                    GenericGraphBox genericGraphBox2 = (GenericGraphBox)genericGraphBox.getTransitions().get(j);
                    printWriter.print(String.valueOf(this.boxes.indexOf(genericGraphBox2)) + " ");
                }
                printWriter.print('\n');
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void saveGrfOld(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Cannot write " + file.getAbsolutePath(), "Error", 0);
            return;
        }
        if (!file.canWrite()) {
            JOptionPane.showMessageDialog(null, "Cannot write " + file.getAbsolutePath(), "Error", 0);
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            UnicodeIO.writeChar(fileOutputStream, '\ufeff');
            UnicodeIO.writeString(fileOutputStream, "#Unigraph\n");
            UnicodeIO.writeString(fileOutputStream, "SIZE " + String.valueOf(this.width) + " " + String.valueOf(this.height) + "\n");
            UnicodeIO.writeString(fileOutputStream, "FONT " + this.pref.input.getName() + ":");
            if (this.pref.input.getStyle() == 0) {
                UnicodeIO.writeString(fileOutputStream, "  ");
            } else if (this.pref.input.getStyle() == 1) {
                UnicodeIO.writeString(fileOutputStream, "B ");
            } else if (this.pref.input.getStyle() == 2) {
                UnicodeIO.writeString(fileOutputStream, " I");
            } else {
                UnicodeIO.writeString(fileOutputStream, "BI");
            }
            UnicodeIO.writeString(fileOutputStream, String.valueOf(this.pref.inputSize) + "\n");
            UnicodeIO.writeString(fileOutputStream, "OFONT " + this.pref.output.getName() + ":");
            if (this.pref.output.getStyle() == 0) {
                UnicodeIO.writeString(fileOutputStream, "  ");
            } else if (this.pref.output.getStyle() == 1) {
                UnicodeIO.writeString(fileOutputStream, "B ");
            } else if (this.pref.output.getStyle() == 2) {
                UnicodeIO.writeString(fileOutputStream, " I");
            } else {
                UnicodeIO.writeString(fileOutputStream, "BI");
            }
            UnicodeIO.writeString(fileOutputStream, String.valueOf(this.pref.outputSize) + "\n");
            UnicodeIO.writeString(fileOutputStream, "BCOLOR " + String.valueOf(0x1000000 + this.pref.backgroundColor.getRGB()) + "\n");
            UnicodeIO.writeString(fileOutputStream, "FCOLOR " + String.valueOf(0x1000000 + this.pref.foregroundColor.getRGB()) + "\n");
            UnicodeIO.writeString(fileOutputStream, "ACOLOR " + String.valueOf(0x1000000 + this.pref.subgraphColor.getRGB()) + "\n");
            UnicodeIO.writeString(fileOutputStream, "SCOLOR " + String.valueOf(0x1000000 + this.pref.commentColor.getRGB()) + "\n");
            UnicodeIO.writeString(fileOutputStream, "CCOLOR " + String.valueOf(0x1000000 + this.pref.selectedColor.getRGB()) + "\n");
            UnicodeIO.writeString(fileOutputStream, "DBOXES y\n");
            if (this.pref.frame) {
                UnicodeIO.writeString(fileOutputStream, "DFRAME y\n");
            } else {
                UnicodeIO.writeString(fileOutputStream, "DFRAME n\n");
            }
            if (this.pref.date) {
                UnicodeIO.writeString(fileOutputStream, "DDATE y\n");
            } else {
                UnicodeIO.writeString(fileOutputStream, "DDATE n\n");
            }
            if (this.pref.filename) {
                UnicodeIO.writeString(fileOutputStream, "DFILE y\n");
            } else {
                UnicodeIO.writeString(fileOutputStream, "DFILE n\n");
            }
            if (this.pref.pathname) {
                UnicodeIO.writeString(fileOutputStream, "DDIR y\n");
            } else {
                UnicodeIO.writeString(fileOutputStream, "DDIR n\n");
            }
            if (this.pref.rightToLeft) {
                UnicodeIO.writeString(fileOutputStream, "DRIG y\n");
            } else {
                UnicodeIO.writeString(fileOutputStream, "DRIG n\n");
            }
            UnicodeIO.writeString(fileOutputStream, "DRST n\n");
            UnicodeIO.writeString(fileOutputStream, "FITS 100\n");
            UnicodeIO.writeString(fileOutputStream, "PORIENT L\n");
            UnicodeIO.writeString(fileOutputStream, "#\n");
            this.nBoxes = this.boxes.size();
            UnicodeIO.writeString(fileOutputStream, String.valueOf(this.nBoxes) + "\n");
            for (int i = 0; i < this.nBoxes; ++i) {
                GenericGraphBox genericGraphBox = (GenericGraphBox)this.boxes.get(i);
                UnicodeIO.writeChar(fileOutputStream, '\"');
                if (genericGraphBox.getType() != 1) {
                    this.write_content(fileOutputStream, genericGraphBox.getContent(), genericGraphBox.getTransduction());
                }
                int n = genericGraphBox.getTransitions().size();
                UnicodeIO.writeString(fileOutputStream, "\" " + String.valueOf(genericGraphBox.getX()) + " " + String.valueOf(genericGraphBox.getY()) + " " + String.valueOf(n) + " ");
                for (int j = 0; j < n; ++j) {
                    GenericGraphBox genericGraphBox2 = (GenericGraphBox)genericGraphBox.getTransitions().get(j);
                    UnicodeIO.writeString(fileOutputStream, String.valueOf(this.boxes.indexOf(genericGraphBox2)) + " ");
                }
                UnicodeIO.writeChar(fileOutputStream, '\n');
            }
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void exportDot(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Cannot write " + file.getAbsolutePath(), "Error", 0);
            return;
        }
        if (!file.canWrite()) {
            JOptionPane.showMessageDialog(null, "Cannot write " + file.getAbsolutePath(), "Error", 0);
            return;
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            outputStreamWriter.write("digraph G{\n");
            outputStreamWriter.write("graph [rankdir=LR,description=\"" + file.getName() + "\"];\n");
            this.nBoxes = this.boxes.size();
            for (int i = 0; i < this.nBoxes; ++i) {
                GenericGraphBox genericGraphBox = (GenericGraphBox)this.boxes.get(i);
                if (i == 1) {
                    outputStreamWriter.write("1 [shape=circle,label=\"\",peripheries=2,width=0.3,height=0.3];\n");
                } else {
                    outputStreamWriter.write("" + i + " [shape=box,label=\"" + genericGraphBox.getContent() + "\"];\n");
                }
                int n = genericGraphBox.getTransitions().size();
                for (int j = 0; j < n; ++j) {
                    GenericGraphBox genericGraphBox2 = (GenericGraphBox)genericGraphBox.getTransitions().get(j);
                    outputStreamWriter.write("" + i + "->" + this.boxes.indexOf(genericGraphBox2) + ";\n");
                }
            }
            outputStreamWriter.write("}\n");
            outputStreamWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static boolean isAPlusChar(char c) {
        return c == '+' || c == '\uff0b';
    }

    private ArrayList tokenizeTextWithoutTransduction(String string) throws BackSlashAtEndOfLineException, MissingGraphNameException, NoClosingQuoteException, NoClosingSupException, NoClosingRoundBracketException {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = new char[10000];
        cArray = string.toCharArray();
        while (n2 < n) {
            String string2 = "";
            if (cArray[n2] == ':') {
                string2 = string2.concat(String.valueOf(cArray[n2++]));
                while (n2 < n && !GraphIO.isAPlusChar(cArray[n2])) {
                    if (cArray[n2] == '\\') {
                        string2 = string2.concat(String.valueOf(cArray[n2++]));
                        if (n2 >= n) {
                            BackSlashAtEndOfLineException backSlashAtEndOfLineException = new BackSlashAtEndOfLineException();
                            throw backSlashAtEndOfLineException;
                        }
                    }
                    string2 = string2.concat(String.valueOf(cArray[n2++]));
                }
                if (string2.length() == 0) {
                    MissingGraphNameException missingGraphNameException = new MissingGraphNameException();
                    throw missingGraphNameException;
                }
                if (n2 < n) {
                    cArray[n2] = 43;
                }
                ++n2;
                ++n3;
                arrayList.add(string2);
                continue;
            }
            while (n2 < n && !GraphIO.isAPlusChar(cArray[n2])) {
                if (cArray[n2] == '\"') {
                    string2 = string2.concat(String.valueOf(cArray[n2++]));
                    while (n2 < n && cArray[n2] != '\"') {
                        if (cArray[n2] == '\\') {
                            string2 = string2.concat(String.valueOf(cArray[n2++]));
                            if (n2 >= n) {
                                BackSlashAtEndOfLineException backSlashAtEndOfLineException = new BackSlashAtEndOfLineException();
                                throw backSlashAtEndOfLineException;
                            }
                        }
                        string2 = string2.concat(String.valueOf(cArray[n2++]));
                    }
                    if (n2 >= n) {
                        NoClosingQuoteException noClosingQuoteException = new NoClosingQuoteException();
                        throw noClosingQuoteException;
                    }
                    string2 = string2.concat(String.valueOf(cArray[n2++]));
                    continue;
                }
                if (cArray[n2] == '<') {
                    string2 = string2.concat(String.valueOf(cArray[n2++]));
                    while (n2 < n && cArray[n2] != '>') {
                        if (cArray[n2] == '\\') {
                            string2 = string2.concat(String.valueOf(cArray[n2++]));
                            if (n2 >= n) {
                                BackSlashAtEndOfLineException backSlashAtEndOfLineException = new BackSlashAtEndOfLineException();
                                throw backSlashAtEndOfLineException;
                            }
                        }
                        string2 = string2.concat(String.valueOf(cArray[n2++]));
                    }
                    if (n2 >= n) {
                        NoClosingSupException noClosingSupException = new NoClosingSupException();
                        throw noClosingSupException;
                    }
                    string2 = string2.concat(String.valueOf(cArray[n2++]));
                    continue;
                }
                if (cArray[n2] == '{') {
                    string2 = string2.concat(String.valueOf(cArray[n2++]));
                    while (n2 < n && cArray[n2] != '}') {
                        if (cArray[n2] == '\\') {
                            string2 = string2.concat(String.valueOf(cArray[n2++]));
                            if (n2 >= n) {
                                BackSlashAtEndOfLineException backSlashAtEndOfLineException = new BackSlashAtEndOfLineException();
                                throw backSlashAtEndOfLineException;
                            }
                        }
                        string2 = string2.concat(String.valueOf(cArray[n2++]));
                    }
                    if (n2 >= n) {
                        NoClosingRoundBracketException noClosingRoundBracketException = new NoClosingRoundBracketException();
                        throw noClosingRoundBracketException;
                    }
                    string2 = string2.concat(String.valueOf(cArray[n2++]));
                    continue;
                }
                if (cArray[n2] == '\\') {
                    string2 = string2.concat(String.valueOf(cArray[n2++]));
                    if (n2 >= n) {
                        BackSlashAtEndOfLineException backSlashAtEndOfLineException = new BackSlashAtEndOfLineException();
                        throw backSlashAtEndOfLineException;
                    }
                }
                string2 = string2.concat(String.valueOf(cArray[n2++]));
            }
            if (n2 < n) {
                cArray[n2] = 43;
            }
            ++n3;
            arrayList.add(string2);
            ++n2;
        }
        return arrayList;
    }
}

