/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.unitex;

import fr.outilex.OutilexEnvironment;
import fr.outilex.grammars.GraphActionListener;
import fr.umlv.unitex.GraphFrame;
import fr.umlv.unitex.ListDocument;
import fr.umlv.unitex.MultipleBoxesSelection;
import fr.umlv.unitex.MultipleSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;

public class TextField
extends JTextField {
    public GraphFrame parent;
    public OutilexEnvironment env;
    public int type;
    public static int INPUT_TEXT_FIELD = 0;
    public static int OUTPUT_TEXT_FIELD = 1;
    public boolean modified = false;
    public static String leftContext;
    public static String rightContext;
    public SpecialPaste specialPaste;
    public SpecialCopy specialCopy;
    public SelectAll selectAll;
    public Cut cut;
    public Open OPEN;
    public Save SAVE;
    public Close CLOSE;

    public TextField(int n, OutilexEnvironment outilexEnvironment, int n2) {
        super(n);
        this.env = outilexEnvironment;
        this.type = n2;
        this.setEditable(false);
        this.modified = false;
        Component component = this.env.contentPane.getSelectedComponent();
        if (component instanceof GraphFrame) {
            this.parent = (GraphFrame)component;
        }
        leftContext = "";
        rightContext = "";
        this.setDisabledTextColor(Color.white);
        this.setBackground(Color.white);
        Keymap keymap = this.getKeymap();
        keymap = TextField.addKeymap("textfield-keymap", keymap);
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(108, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(76, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(107, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(75, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(111, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(79, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(115, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(83, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(112, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(80, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(109, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(77, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(114, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(82, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(120, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(88, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(99, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(67, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(118, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(86, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(97, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(65, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(115, 2));
        keymap.removeKeyStrokeBinding(KeyStroke.getKeyStroke(83, 2));
        this.specialPaste = new SpecialPaste("special-paste");
        this.specialCopy = new SpecialCopy("special-copy");
        this.selectAll = new SelectAll("select all");
        this.cut = new Cut("cut");
        this.OPEN = new Open("open");
        this.SAVE = new Save("save");
        this.CLOSE = new Close();
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(118, 2), this.specialPaste);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(86, 2), this.specialPaste);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(99, 2), this.specialCopy);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(67, 2), this.specialCopy);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(111, 2), this.OPEN);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(79, 2), this.OPEN);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(115, 2), this.SAVE);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(83, 2), this.SAVE);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(119, 2), this.CLOSE);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(87, 2), this.CLOSE);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(97, 2), this.selectAll);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(65, 2), this.selectAll);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(120, 2), this.cut);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(88, 2), this.cut);
        this.setKeymap(keymap);
        this.addKeyListener(new MyKeyListener());
    }

    GraphFrame parent() {
        Component component = this.env.contentPane.getSelectedComponent();
        if (component instanceof GraphFrame) {
            return (GraphFrame)component;
        }
        return null;
    }

    public void initText(String string) {
        this.modified = false;
        this.setEditable(true);
        this.setText(string);
        this.requestFocus();
        this.getCaret().setVisible(true);
        this.selectAll();
    }

    public Document createDefaultModel() {
        return new ListDocument();
    }

    public boolean validateTextField() {
        if (!this.hasChangedTextField()) {
            return false;
        }
        if (this.isValidGraphBoxContent(this.getText())) {
            this.parent().setModified(true);
            this.parent().graphicalZone.setTextForSelected(this.parent().texte.getText(), this.parent().outText.getText());
            this.parent().graphicalZone.unSelectAllBoxes();
            this.setText("");
            this.parent().texte.setText("");
            this.parent().outText.setText("");
            this.parent().repaint();
            this.setEditable(false);
            return true;
        }
        return false;
    }

    public boolean hasChangedTextField() {
        return this.modified;
    }

    private int test_transduction(char[] cArray, int n) {
        if (cArray[n] != '/') {
            return 0;
        }
        --n;
        int n2 = 0;
        while (n >= 0 && cArray[n] == '\\') {
            ++n2;
            --n;
        }
        if (n2 % 2 != 0) {
            return 0;
        }
        return 1;
    }

    private boolean tokenize(String string) {
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[10000];
        cArray = string.toCharArray();
        if (this.type == INPUT_TEXT_FIELD) {
            if (cArray[0] == '+') {
                JOptionPane.showMessageDialog(null, "Unexpected \"+\" as first character of the line", "Error", 0);
                return false;
            }
            if (cArray[n - 1] == '+') {
                JOptionPane.showMessageDialog(null, "Unexpected \"+\" as last character of the line", "Error", 0);
                return false;
            }
        }
        while (n2 < n) {
            String string2 = "";
            if (cArray[n2] == ':') {
                ++n2;
                while (n2 < n && cArray[n2] != '+') {
                    if (cArray[n2] == '\\') {
                        string2 = string2.concat(String.valueOf(cArray[n2++]));
                        if (n2 >= n) {
                            if (this.type == INPUT_TEXT_FIELD) {
                                JOptionPane.showMessageDialog(null, "Unexpected \"\\\" at end of line", "Error", 0);
                                return false;
                            }
                            return true;
                        }
                    }
                    string2 = string2.concat(String.valueOf(cArray[n2++]));
                }
                if (string2.length() == 0) {
                    if (this.type == INPUT_TEXT_FIELD) {
                        JOptionPane.showMessageDialog(null, "Missing graph name after \":\"", "Error", 0);
                        return false;
                    }
                    return true;
                }
                ++n2;
                continue;
            }
            if (cArray[n2] == '+' && this.type == INPUT_TEXT_FIELD) {
                JOptionPane.showMessageDialog(null, "Empty line error: \"++\"", "Error", 0);
                return false;
            }
            while (n2 < n && cArray[n2] != '+') {
                if (cArray[n2] == '\"') {
                    string2 = string2.concat(String.valueOf(cArray[n2++]));
                    while (n2 < n && cArray[n2] != '\"') {
                        if (cArray[n2] == '\\') {
                            string2 = string2.concat(String.valueOf(cArray[n2++]));
                            if (n2 >= n) {
                                if (this.type == INPUT_TEXT_FIELD) {
                                    JOptionPane.showMessageDialog(null, "Unexpected \"\\\" at end of line", "Error", 0);
                                    return false;
                                }
                                return true;
                            }
                        }
                        string2 = string2.concat(String.valueOf(cArray[n2++]));
                    }
                    if (n2 >= n) {
                        if (this.type == INPUT_TEXT_FIELD) {
                            JOptionPane.showMessageDialog(null, "No closing \"", "Error", 0);
                            return false;
                        }
                        return true;
                    }
                    string2 = string2.concat(String.valueOf(cArray[n2++]));
                    continue;
                }
                if (cArray[n2] == '<') {
                    string2 = string2.concat(String.valueOf(cArray[n2++]));
                    while (n2 < n && cArray[n2] != '>') {
                        if (cArray[n2] == '\\') {
                            string2 = string2.concat(String.valueOf(cArray[n2++]));
                            if (n2 >= n) {
                                if (this.type == INPUT_TEXT_FIELD) {
                                    JOptionPane.showMessageDialog(null, "Unexpected \"\\\" at end of line", "Error", 0);
                                    return false;
                                }
                                return true;
                            }
                        }
                        string2 = string2.concat(String.valueOf(cArray[n2++]));
                    }
                    if (n2 >= n) {
                        if (this.type == INPUT_TEXT_FIELD) {
                            JOptionPane.showMessageDialog(null, "No closing \">\"", "Error", 0);
                            return false;
                        }
                        return true;
                    }
                    string2 = string2.concat(String.valueOf(cArray[n2++]));
                    continue;
                }
                if (cArray[n2] == '{') {
                    string2 = string2.concat(String.valueOf(cArray[n2++]));
                    while (n2 < n && cArray[n2] != '}') {
                        if (cArray[n2] == '\\') {
                            string2 = string2.concat(String.valueOf(cArray[n2++]));
                            if (n2 >= n) {
                                if (this.type == INPUT_TEXT_FIELD) {
                                    JOptionPane.showMessageDialog(null, "Unexpected \"\\\" at end of line", "Error", 0);
                                    return false;
                                }
                                return true;
                            }
                        }
                        string2 = string2.concat(String.valueOf(cArray[n2++]));
                    }
                    if (n2 >= n) {
                        if (this.type == INPUT_TEXT_FIELD) {
                            JOptionPane.showMessageDialog(null, "No closing \"}\"", "Error", 0);
                            return false;
                        }
                        return true;
                    }
                    string2 = string2.concat(String.valueOf(cArray[n2++]));
                    continue;
                }
                if (cArray[n2] == '\\') {
                    string2 = string2.concat(String.valueOf(cArray[n2++]));
                    if (n2 >= n) {
                        if (this.type == INPUT_TEXT_FIELD) {
                            JOptionPane.showMessageDialog(null, "Unexpected \"\\\" at end of line", "Error", 0);
                            return false;
                        }
                        return true;
                    }
                }
                string2 = string2.concat(String.valueOf(cArray[n2++]));
            }
            ++n2;
        }
        return true;
    }

    public boolean isValidGraphBoxContent(String string) {
        if (string.equals("")) {
            return true;
        }
        return this.tokenize(string);
    }

    class MyKeyListener
    implements KeyListener {
        MyKeyListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isControlDown() || keyEvent.isAltDown()) {
                return;
            }
            if (keyEvent.getKeyCode() == 10) {
                TextField.this.validateTextField();
            }
            TextField.this.modified = true;
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    class Close
    extends TextAction {
        public Close() {
            super("close");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphActionListener.closeGraph(TextField.this.env);
        }
    }

    class Save
    extends TextAction {
        public Save(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphActionListener.saveGraph(TextField.this.env);
        }
    }

    class Open
    extends TextAction {
        public Open(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphActionListener.openGraph(TextField.this.env);
        }
    }

    class SpecialPaste
    extends TextAction {
        public SpecialPaste(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MultipleSelection multipleSelection = null;
            Transferable transferable = GraphFrame.clip.getContents(this);
            try {
                if (transferable != null) {
                    multipleSelection = (MultipleSelection)transferable.getTransferData(new DataFlavor("unitex/boxes", "Unitex dataflavor"));
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (multipleSelection == null || TextField.this.modified) {
                TextField.this.paste();
                return;
            }
            ++multipleSelection.n;
            TextField.this.parent().graphicalZone.pasteSelection(multipleSelection);
        }
    }

    class Cut
    extends TextAction
    implements ClipboardOwner {
        public Cut(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!TextField.this.parent().graphicalZone.selectedBoxes.isEmpty() && TextField.this.parent().graphicalZone.selectedBoxes.size() == 1) {
                TextField.this.cut();
            } else {
                GraphFrame.clip.setContents(new MultipleBoxesSelection(new MultipleSelection(TextField.this.parent().graphicalZone.selectedBoxes, true)), this);
                TextField.this.parent().graphicalZone.removeSelected();
                TextField.this.setText("");
            }
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }

    class SelectAll
    extends TextAction
    implements ClipboardOwner {
        public SelectAll(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!TextField.this.parent().graphicalZone.selectedBoxes.isEmpty() && TextField.this.parent().graphicalZone.selectedBoxes.size() == 1) {
                TextField.this.selectAll();
            } else {
                TextField.this.parent().graphicalZone.selectAllBoxes();
            }
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }

    class SpecialCopy
    extends TextAction
    implements ClipboardOwner {
        public SpecialCopy(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (TextField.this.parent().graphicalZone.selectedBoxes.isEmpty() || TextField.this.parent().graphicalZone.selectedBoxes.size() < 2) {
                TextField.this.copy();
                GraphFrame.clip.setContents(null, this);
                return;
            }
            GraphFrame.clip.setContents(new MultipleBoxesSelection(new MultipleSelection(TextField.this.parent().graphicalZone.selectedBoxes, true)), this);
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }
}

