/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.unitex;

import fr.outilex.OutilexEnvironment;
import fr.umlv.unitex.FontMenu;
import fr.umlv.unitex.GraphFrame;
import fr.umlv.unitex.Preferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class GraphPresentationMenu
extends JDialog {
    JCheckBox dateCheckBox = new JCheckBox();
    JCheckBox filenameCheckBox = new JCheckBox();
    JCheckBox pathnameCheckBox = new JCheckBox();
    JCheckBox frameCheckBox = new JCheckBox();
    JCheckBox rightToLeftCheckBox = new JCheckBox();
    JButton color1 = new JButton("     ");
    JButton color2 = new JButton("     ");
    JButton color3 = new JButton("     ");
    JButton color4 = new JButton("     ");
    JButton color5 = new JButton("     ");
    JLabel inputLabel = new JLabel("", 2);
    JLabel outputLabel = new JLabel("", 2);
    static GraphPresentationMenu pref;
    OutilexEnvironment env;
    GraphFrame graphFrame;

    public GraphPresentationMenu(OutilexEnvironment outilexEnvironment) {
        super(outilexEnvironment.mainFrame, "Presentation", true);
        this.env = outilexEnvironment;
        this.graphFrame = (GraphFrame)this.env.contentPane.getSelectedComponent();
        Preferences.temp = this.graphFrame.graphicalZone.pref.getClone();
        this.setContentPane(this.constructPanel());
        this.pack();
        this.setResizable(false);
        pref = this;
        this.showPresentation();
    }

    public void refresh() {
        this.color1.setBackground(Preferences.temp.backgroundColor);
        this.color2.setBackground(Preferences.temp.foregroundColor);
        this.color3.setBackground(Preferences.temp.subgraphColor);
        this.color4.setBackground(Preferences.temp.selectedColor);
        this.color5.setBackground(Preferences.temp.commentColor);
        this.inputLabel.setText("  " + Preferences.temp.input.getFontName() + "  " + Preferences.temp.inputSize + "  ");
        this.outputLabel.setText("  " + Preferences.temp.output.getFontName() + "  " + Preferences.temp.outputSize + "  ");
        this.setResizable(true);
        this.pack();
        this.setResizable(false);
        this.repaint();
    }

    public void showPresentation() {
        this.setLocationRelativeTo(this.env.mainFrame);
        this.setVisible(true);
    }

    private JPanel constructPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.constructUpPanel();
        JPanel jPanel3 = this.constructDownPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JPanel constructUpPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)this.constructDisplayPanel(), "West");
        jPanel.add((Component)this.constructColorPanel(), "Center");
        return jPanel;
    }

    private JPanel constructDownPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.constructFontPanel(), "Center");
        jPanel.add((Component)this.constructButtonPanel(), "East");
        return jPanel;
    }

    private JPanel constructDisplayPanel() {
        JPanel jPanel = new JPanel(new GridLayout(5, 1));
        jPanel.setBorder(new TitledBorder("Display"));
        this.dateCheckBox.setSelected(Preferences.temp.date);
        this.filenameCheckBox.setSelected(Preferences.temp.filename);
        this.pathnameCheckBox.setSelected(Preferences.temp.pathname);
        this.frameCheckBox.setSelected(Preferences.temp.frame);
        this.rightToLeftCheckBox.setSelected(Preferences.temp.rightToLeft);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.dateCheckBox, "West");
        jPanel2.add((Component)new JLabel("Date  "), "Center");
        jPanel3.add((Component)this.filenameCheckBox, "West");
        jPanel3.add((Component)new JLabel("File Name  "), "Center");
        jPanel4.add((Component)this.pathnameCheckBox, "West");
        jPanel4.add((Component)new JLabel("Pathname  "), "Center");
        jPanel5.add((Component)this.frameCheckBox, "West");
        jPanel5.add((Component)new JLabel("Frame  "), "Center");
        jPanel6.add((Component)this.rightToLeftCheckBox, "West");
        jPanel6.add((Component)new JLabel("Right to Left  "), "Center");
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel.add(jPanel5);
        jPanel.add(jPanel6);
        return jPanel;
    }

    private void build(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    private JPanel constructColorPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(new TitledBorder("Colors"));
        AbstractAction abstractAction = new AbstractAction("Set..."){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.temp.backgroundColor = JColorChooser.showDialog(GraphPresentationMenu.this.env.mainFrame, "Background Color", Preferences.temp.backgroundColor);
                pref.refresh();
            }
        };
        JButton jButton = new JButton(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction("Set..."){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.temp.foregroundColor = JColorChooser.showDialog(GraphPresentationMenu.this.env.mainFrame, "Foreground Color", Preferences.temp.foregroundColor);
                pref.refresh();
            }
        };
        JButton jButton2 = new JButton(abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction("Set..."){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.temp.subgraphColor = JColorChooser.showDialog(GraphPresentationMenu.this.env.mainFrame, "Auxiliary Nodes Color", Preferences.temp.subgraphColor);
                pref.refresh();
            }
        };
        JButton jButton3 = new JButton(abstractAction3);
        AbstractAction abstractAction4 = new AbstractAction("Set..."){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.temp.selectedColor = JColorChooser.showDialog(GraphPresentationMenu.this.env.mainFrame, "Selected Nodes Color", Preferences.temp.selectedColor);
                pref.refresh();
            }
        };
        JButton jButton4 = new JButton(abstractAction4);
        AbstractAction abstractAction5 = new AbstractAction("Set..."){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.temp.commentColor = JColorChooser.showDialog(GraphPresentationMenu.this.env.mainFrame, "Comment Nodes Color", Preferences.temp.commentColor);
                pref.refresh();
            }
        };
        JButton jButton5 = new JButton(abstractAction5);
        this.color1.setBackground(Preferences.temp.backgroundColor);
        this.color2.setBackground(Preferences.temp.foregroundColor);
        this.color3.setBackground(Preferences.temp.subgraphColor);
        this.color4.setBackground(Preferences.temp.selectedColor);
        this.color5.setBackground(Preferences.temp.commentColor);
        JLabel jLabel = new JLabel("  Background:  ", 2);
        JLabel jLabel2 = new JLabel("  Foreground:  ", 2);
        JLabel jLabel3 = new JLabel("  Auxiliary Nodes:  ", 2);
        JLabel jLabel4 = new JLabel("  Selected Nodes:  ", 2);
        JLabel jLabel5 = new JLabel("  Comment Nodes:  ", 2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.build(gridBagConstraints, 0, 0, 1, 1, 60, 15);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.build(gridBagConstraints, 1, 0, 1, 1, 20, 0);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.color1, gridBagConstraints);
        jPanel.add(this.color1);
        this.build(gridBagConstraints, 2, 0, 1, 1, 20, 0);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        this.build(gridBagConstraints, 0, 1, 1, 1, 60, 15);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        this.build(gridBagConstraints, 1, 1, 1, 1, 20, 0);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.color2, gridBagConstraints);
        jPanel.add(this.color2);
        this.build(gridBagConstraints, 2, 1, 1, 1, 20, 0);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(jButton2, gridBagConstraints);
        jPanel.add(jButton2);
        this.build(gridBagConstraints, 0, 2, 1, 1, 60, 15);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        this.build(gridBagConstraints, 1, 2, 1, 1, 20, 0);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.color3, gridBagConstraints);
        jPanel.add(this.color3);
        this.build(gridBagConstraints, 2, 2, 1, 1, 20, 0);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(jButton3, gridBagConstraints);
        jPanel.add(jButton3);
        this.build(gridBagConstraints, 0, 3, 1, 1, 60, 15);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        jPanel.add(jLabel4);
        this.build(gridBagConstraints, 1, 3, 1, 1, 20, 0);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.color4, gridBagConstraints);
        jPanel.add(this.color4);
        this.build(gridBagConstraints, 2, 3, 1, 1, 20, 0);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(jButton4, gridBagConstraints);
        jPanel.add(jButton4);
        this.build(gridBagConstraints, 0, 4, 1, 1, 60, 15);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jLabel5, gridBagConstraints);
        jPanel.add(jLabel5);
        this.build(gridBagConstraints, 1, 4, 1, 1, 20, 0);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.color5, gridBagConstraints);
        jPanel.add(this.color5);
        this.build(gridBagConstraints, 2, 4, 1, 1, 20, 0);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(jButton5, gridBagConstraints);
        jPanel.add(jButton5);
        return jPanel;
    }

    private JPanel constructFontPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(new TitledBorder("Fonts"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        AbstractAction abstractAction = new AbstractAction("Input"){

            public void actionPerformed(ActionEvent actionEvent) {
                new FontMenu(true, GraphPresentationMenu.this.env);
                pref.refresh();
            }
        };
        JButton jButton = new JButton(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction("Output"){

            public void actionPerformed(ActionEvent actionEvent) {
                new FontMenu(false, GraphPresentationMenu.this.env);
                pref.refresh();
            }
        };
        JButton jButton2 = new JButton(abstractAction2);
        this.inputLabel.setText("  " + Preferences.temp.input.getFontName() + "  " + Preferences.temp.inputSize + "  ");
        this.outputLabel.setText("  " + Preferences.temp.output.getFontName() + "  " + Preferences.temp.outputSize + "  ");
        this.build(gridBagConstraints, 0, 0, 1, 1, 60, 15);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        this.build(gridBagConstraints, 1, 0, 1, 1, 20, 0);
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.inputLabel, gridBagConstraints);
        jPanel.add(this.inputLabel);
        this.build(gridBagConstraints, 0, 1, 1, 1, 60, 15);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jButton2, gridBagConstraints);
        jPanel.add(jButton2);
        this.build(gridBagConstraints, 1, 1, 1, 1, 20, 0);
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.outputLabel, gridBagConstraints);
        jPanel.add(this.outputLabel);
        return jPanel;
    }

    private JPanel constructButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        jPanel.setBorder(new EmptyBorder(5, 5, 0, 0));
        AbstractAction abstractAction = new AbstractAction("Default"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GraphPresentationMenu.this.graphFrame == null) {
                    return;
                }
                Preferences.temp = Preferences.pref.getClone();
                pref.refresh();
                GraphPresentationMenu.this.dateCheckBox.setSelected(Preferences.temp.date);
                GraphPresentationMenu.this.filenameCheckBox.setSelected(Preferences.temp.filename);
                GraphPresentationMenu.this.pathnameCheckBox.setSelected(Preferences.temp.pathname);
                GraphPresentationMenu.this.frameCheckBox.setSelected(Preferences.temp.frame);
                GraphPresentationMenu.this.rightToLeftCheckBox.setSelected(Preferences.temp.rightToLeft);
            }
        };
        JButton jButton = new JButton(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame graphFrame = GraphPresentationMenu.this.graphFrame;
                if (graphFrame == null) {
                    return;
                }
                Dimension dimension = graphFrame.getSize(null);
                Preferences.temp.date = GraphPresentationMenu.pref.dateCheckBox.isSelected();
                Preferences.temp.filename = GraphPresentationMenu.pref.filenameCheckBox.isSelected();
                Preferences.temp.pathname = GraphPresentationMenu.pref.pathnameCheckBox.isSelected();
                Preferences.temp.frame = GraphPresentationMenu.pref.frameCheckBox.isSelected();
                Preferences.temp.rightToLeft = GraphPresentationMenu.pref.rightToLeftCheckBox.isSelected();
                graphFrame.graphicalZone.pref = Preferences.temp.getClone();
                graphFrame.texte.setFont(graphFrame.graphicalZone.pref.input);
                graphFrame.setSize(dimension);
                graphFrame.graphicalZone.updateAllBoxes();
                pref.setVisible(false);
                graphFrame.setModified(true);
            }
        };
        JButton jButton2 = new JButton(abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent actionEvent) {
                pref.setVisible(false);
            }
        };
        JButton jButton3 = new JButton(abstractAction3);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        return jPanel;
    }
}

