/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.unitex;

import fr.outilex.OutilexEnvironment;
import fr.umlv.unitex.GraphBox;
import fr.umlv.unitex.GraphPresentationMenu;
import fr.umlv.unitex.GraphicalZone;
import fr.umlv.unitex.MyCursors;
import fr.umlv.unitex.Preferences;
import fr.umlv.unitex.TextField;
import fr.umlv.unitex.UnitexAction;
import fr.umlv.unitex.io.SVG;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class GraphFrame
extends JPanel {
    private OutilexEnvironment env;
    public static Clipboard clip = new Clipboard("GraphEditor clipboard");
    static int openFrameCount = 0;
    static final int offset = 30;
    public TextField texte;
    public TextField outText;
    public GraphicalZone graphicalZone;
    private File grf;
    public boolean modified = false;
    UndoManager manager;
    private JButton redoButton;
    private JButton undoButton;
    public JScrollPane scroll;
    boolean nonEmptyGraph = false;
    public ComponentListener compListener = null;
    private JToolBar myToolBar;
    private JTabbedPane contentPanel;

    public GraphFrame(boolean bl, OutilexEnvironment outilexEnvironment) {
        MyCursors.initCursorsAndIcons();
        this.env = outilexEnvironment;
        this.contentPanel = this.env.contentPane;
        this.nonEmptyGraph = bl;
        ++openFrameCount;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.buildTextPanel(), "North");
        this.graphicalZone = new GraphicalZone(1188, 840, this.texte, this.outText, this, this.env);
        this.graphicalZone.setPreferredSize(new Dimension((int)(1188.0 * this.graphicalZone.scaleFactor), (int)(840.0 * this.graphicalZone.scaleFactor)));
        this.manager = new UndoManager();
        this.manager.setLimit(30);
        this.graphicalZone.addUndoableEditListener(this.manager);
        this.createToolBar();
        this.scroll = new JScrollPane(this.graphicalZone);
        this.scroll.setOpaque(true);
        this.scroll.getHorizontalScrollBar().setUnitIncrement(20);
        this.scroll.getVerticalScrollBar().setUnitIncrement(20);
        this.scroll.setPreferredSize(new Dimension(1188, 840));
        jPanel.add((Component)this.scroll, "Center");
        this.texte.setFont(this.graphicalZone.pref.input);
        if (!this.graphicalZone.pref.iconBarPosition.equals(Preferences.NO_ICON_BAR)) {
            this.add((Component)this.myToolBar, this.graphicalZone.pref.iconBarPosition);
        }
        this.add((Component)jPanel, "Center");
        this.setBounds(30 * (openFrameCount % 6), 30 * (openFrameCount % 6), 840, 680);
    }

    private void createToolBar() {
        this.myToolBar = new JToolBar("Tools");
        if (Preferences.pref.iconBarPosition.equals(Preferences.ICON_BAR_WEST) || Preferences.pref.iconBarPosition.equals(Preferences.ICON_BAR_EAST)) {
            this.myToolBar.setOrientation(1);
        } else {
            this.myToolBar.setOrientation(0);
        }
        this.myToolBar.setMargin(new Insets(0, 0, 0, 0));
        JButton jButton = new JButton(MyCursors.saveIcon);
        jButton.setMaximumSize(new Dimension(36, 36));
        jButton.setMinimumSize(new Dimension(36, 36));
        jButton.setPreferredSize(new Dimension(36, 36));
        JToggleButton jToggleButton = new JToggleButton("?");
        jToggleButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    GraphicalZone cfr_ignored_0 = GraphFrame.this.graphicalZone;
                    GraphFrame.this.graphicalZone.OUTPUT_STYLE = GraphicalZone.UNIF_OUTPUT;
                } else {
                    GraphicalZone cfr_ignored_1 = GraphFrame.this.graphicalZone;
                    GraphFrame.this.graphicalZone.OUTPUT_STYLE = GraphicalZone.NORMAL_OUTPUT;
                }
                GraphFrame.this.graphicalZone.paintImmediately();
            }
        });
        JButton jButton2 = new JButton(MyCursors.copyIcon);
        JButton jButton3 = new JButton(MyCursors.cutIcon);
        JButton jButton4 = new JButton(MyCursors.pasteIcon);
        jButton2.setMaximumSize(new Dimension(36, 36));
        jButton3.setMaximumSize(new Dimension(36, 36));
        jButton4.setMaximumSize(new Dimension(36, 36));
        jButton2.setMinimumSize(new Dimension(36, 36));
        jButton3.setMinimumSize(new Dimension(36, 36));
        jButton4.setMinimumSize(new Dimension(36, 36));
        jButton2.setPreferredSize(new Dimension(36, 36));
        jButton3.setPreferredSize(new Dimension(36, 36));
        jButton4.setPreferredSize(new Dimension(36, 36));
        this.redoButton = new JButton(MyCursors.redoIcon);
        this.undoButton = new JButton(MyCursors.undoIcon);
        this.redoButton.setToolTipText("Redo");
        this.undoButton.setToolTipText("Undo");
        this.redoButton.addActionListener(new RedoIt());
        this.redoButton.setMaximumSize(new Dimension(36, 36));
        this.redoButton.setMinimumSize(new Dimension(36, 36));
        this.redoButton.setPreferredSize(new Dimension(36, 36));
        this.undoButton.addActionListener(new UndoIt());
        this.undoButton.setMaximumSize(new Dimension(36, 36));
        this.undoButton.setMinimumSize(new Dimension(36, 36));
        this.undoButton.setPreferredSize(new Dimension(36, 36));
        JToggleButton jToggleButton2 = new JToggleButton(MyCursors.arrowIcon);
        jToggleButton2.setMaximumSize(new Dimension(36, 36));
        jToggleButton2.setMinimumSize(new Dimension(36, 36));
        jToggleButton2.setPreferredSize(new Dimension(36, 36));
        JToggleButton jToggleButton3 = new JToggleButton(MyCursors.createBoxesIcon);
        jToggleButton3.setMaximumSize(new Dimension(36, 36));
        jToggleButton3.setMinimumSize(new Dimension(36, 36));
        jToggleButton3.setPreferredSize(new Dimension(36, 36));
        JToggleButton jToggleButton4 = new JToggleButton(MyCursors.killBoxesIcon);
        jToggleButton4.setMaximumSize(new Dimension(36, 36));
        jToggleButton4.setMinimumSize(new Dimension(36, 36));
        jToggleButton4.setPreferredSize(new Dimension(36, 36));
        JToggleButton jToggleButton5 = new JToggleButton(MyCursors.linkBoxesIcon);
        jToggleButton5.setMaximumSize(new Dimension(36, 36));
        jToggleButton5.setMinimumSize(new Dimension(36, 36));
        jToggleButton5.setPreferredSize(new Dimension(36, 36));
        JToggleButton jToggleButton6 = new JToggleButton(MyCursors.reverseLinkBoxesIcon);
        jToggleButton6.setMaximumSize(new Dimension(36, 36));
        jToggleButton6.setMinimumSize(new Dimension(36, 36));
        jToggleButton6.setPreferredSize(new Dimension(36, 36));
        JToggleButton jToggleButton7 = new JToggleButton(MyCursors.openSubgraphIcon);
        jToggleButton7.setMaximumSize(new Dimension(36, 36));
        jToggleButton7.setMinimumSize(new Dimension(36, 36));
        jToggleButton7.setPreferredSize(new Dimension(36, 36));
        JButton jButton5 = new JButton(MyCursors.configurationIcon);
        jButton5.setMaximumSize(new Dimension(36, 36));
        jButton5.setMinimumSize(new Dimension(36, 36));
        jButton5.setPreferredSize(new Dimension(36, 36));
        jButton.setToolTipText("Save graph");
        jToggleButton.setToolTipText("Control output style");
        jButton2.setToolTipText("Copy");
        jButton3.setToolTipText("Cut");
        jButton4.setToolTipText("Paste");
        jToggleButton2.setToolTipText("Normal editing mode");
        jToggleButton3.setToolTipText("Create a new box");
        jToggleButton4.setToolTipText("Remove a box");
        jToggleButton5.setToolTipText("Link boxes");
        jToggleButton6.setToolTipText("Reversed link between boxes");
        jToggleButton7.setToolTipText("Open a sub-graph");
        jButton5.setToolTipText("Graph configuration");
        final GraphFrame graphFrame = this;
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame graphFrame2 = graphFrame;
                if (graphFrame2 != null) {
                    UnitexAction.saveGraph(graphFrame2);
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final ActionEvent actionEvent2 = actionEvent;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((TextField)GraphFrame.this.graphicalZone.texte).specialCopy.actionPerformed(actionEvent2);
                        GraphFrame.this.repaint();
                    }
                });
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final ActionEvent actionEvent2 = actionEvent;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((TextField)GraphFrame.this.graphicalZone.texte).cut.actionPerformed(actionEvent2);
                        GraphFrame.this.repaint();
                    }
                });
            }
        });
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final ActionEvent actionEvent2 = actionEvent;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((TextField)GraphFrame.this.graphicalZone.texte).specialPaste.actionPerformed(actionEvent2);
                        GraphFrame.this.repaint();
                    }
                });
            }
        });
        jToggleButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.graphicalZone.setCursor(MyCursors.normalCursor);
                GraphFrame.this.graphicalZone.EDITING_MODE = 0;
                GraphFrame.this.repaint();
            }
        });
        jToggleButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.graphicalZone.setCursor(MyCursors.createBoxesCursor);
                GraphFrame.this.graphicalZone.EDITING_MODE = 3;
                GraphFrame.this.repaint();
            }
        });
        jToggleButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.graphicalZone.setCursor(MyCursors.killBoxesCursor);
                GraphFrame.this.graphicalZone.EDITING_MODE = 4;
                GraphFrame.this.graphicalZone.unSelectAllBoxes();
                GraphFrame.this.texte.validateTextField();
            }
        });
        jToggleButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.graphicalZone.setCursor(MyCursors.linkBoxesCursor);
                GraphFrame.this.graphicalZone.EDITING_MODE = 5;
                GraphFrame.this.repaint();
            }
        });
        jToggleButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.graphicalZone.setCursor(MyCursors.reverseLinkBoxesCursor);
                GraphFrame.this.graphicalZone.EDITING_MODE = 6;
                GraphFrame.this.repaint();
            }
        });
        jToggleButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.graphicalZone.setCursor(MyCursors.openSubgraphCursor);
                GraphFrame.this.graphicalZone.EDITING_MODE = 8;
                GraphFrame.this.texte.validateTextField();
            }
        });
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        new GraphPresentationMenu(GraphFrame.this.env);
                    }
                });
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jToggleButton2);
        buttonGroup.add(jToggleButton3);
        buttonGroup.add(jToggleButton4);
        buttonGroup.add(jToggleButton5);
        buttonGroup.add(jToggleButton6);
        buttonGroup.add(jToggleButton7);
        jToggleButton2.setSelected(true);
        this.myToolBar.add(jButton);
        this.myToolBar.add(jToggleButton);
        this.myToolBar.addSeparator();
        this.myToolBar.addSeparator();
        this.myToolBar.add(jButton2);
        this.myToolBar.add(jButton3);
        this.myToolBar.add(jButton4);
        this.myToolBar.add(this.redoButton);
        this.myToolBar.add(this.undoButton);
        this.myToolBar.addSeparator();
        this.myToolBar.addSeparator();
        this.myToolBar.add(jToggleButton2);
        this.myToolBar.add(jToggleButton3);
        this.myToolBar.add(jToggleButton4);
        this.myToolBar.add(jToggleButton5);
        this.myToolBar.add(jToggleButton6);
        this.myToolBar.add(jToggleButton7);
        this.myToolBar.addSeparator();
        this.myToolBar.addSeparator();
        this.myToolBar.add(jButton5);
    }

    private JPanel buildTextPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(this.getWidth(), 55));
        jPanel.setLayout(new LabeledPairLayout());
        JLabel jLabel = new JLabel("Input");
        JLabel jLabel2 = new JLabel("Output");
        this.outText = new TextField(25, this.env, TextField.OUTPUT_TEXT_FIELD);
        this.texte = new TextField(25, this.env, TextField.INPUT_TEXT_FIELD);
        this.texte.setEnabled(true);
        jPanel.add((Component)jLabel, "label");
        jPanel.add((Component)this.texte, "texte");
        jPanel.add((Component)jLabel2, "label");
        jPanel.add((Component)this.outText, "texte");
        return jPanel;
    }

    public void reSizeGraphicalZone(int n, int n2) {
        this.graphicalZone.Width = n;
        this.graphicalZone.Height = n2;
        this.graphicalZone.setPreferredSize(new Dimension(n, n2));
        this.graphicalZone.revalidate();
        this.graphicalZone.repaint();
    }

    public void setModified(boolean bl) {
        this.modified = bl;
        if (this.grf != null) {
            if (this.modified) {
                this.setTitle(this.grf.getName() + " (Unsaved)");
            } else {
                this.setTitle(this.grf.getName());
            }
        } else if (this.modified) {
            this.setTitle(" (Unsaved)");
        } else {
            this.setTitle("Graph");
        }
    }

    public void setScaleFactor(double d) {
        this.graphicalZone.scaleFactor = d;
        this.graphicalZone.setPreferredSize(new Dimension((int)((double)this.graphicalZone.Width * this.graphicalZone.scaleFactor), (int)((double)this.graphicalZone.Height * this.graphicalZone.scaleFactor)));
        this.graphicalZone.revalidate();
        this.graphicalZone.repaint();
    }

    public void sortNodeLabel() {
        if (this.graphicalZone.selectedBoxes.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.graphicalZone.selectedBoxes.size(); ++i) {
            GraphBox graphBox = (GraphBox)this.graphicalZone.selectedBoxes.get(i);
            graphBox.sortNodeLabel();
        }
        this.graphicalZone.unSelectAllBoxes();
        this.texte.initText("");
        this.graphicalZone.repaint();
    }

    public void changeAntialiasingValue() {
        this.graphicalZone.pref.antialiasing = !this.graphicalZone.pref.antialiasing;
        this.graphicalZone.repaint();
    }

    private void updateDoUndoButtons() {
        if (this.undoButton != null && this.redoButton != null) {
            this.undoButton.setEnabled(this.manager.canUndo());
            this.redoButton.setEnabled(this.manager.canRedo());
        }
    }

    public void repaint() {
        super.repaint();
        this.updateDoUndoButtons();
    }

    public void setRedoEnabled(boolean bl) {
        this.redoButton.setEnabled(bl);
    }

    public void setUndoEnabled(boolean bl) {
        this.undoButton.setEnabled(bl);
    }

    public File getGraph() {
        return this.grf;
    }

    public void setGraph(File file) {
        this.grf = file;
    }

    public void setTitle(String string) {
        if (this.contentPanel != null) {
            this.contentPanel.setTitleAt(this.contentPanel.getSelectedIndex(), string);
        }
    }

    public void saveGraphAsAnSVG(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Cannot write " + file.getAbsolutePath(), "Error", 0);
            return;
        }
        if (!file.canWrite()) {
            JOptionPane.showMessageDialog(null, "Cannot write " + file.getAbsolutePath(), "Error", 0);
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            SVG sVG = new SVG(outputStreamWriter, this);
            sVG.save();
            outputStreamWriter.close();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    class RedoIt
    implements ActionListener {
        RedoIt() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                GraphFrame.this.manager.redo();
            }
            catch (CannotRedoException cannotRedoException) {
            }
            finally {
                GraphFrame.this.repaint();
            }
        }
    }

    class UndoIt
    implements ActionListener {
        UndoIt() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                GraphFrame.this.manager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
            }
            finally {
                GraphFrame.this.repaint();
            }
        }
    }

    class LabeledPairLayout
    implements LayoutManager {
        Vector labels = new Vector();
        Vector fields = new Vector();
        int yGap = 2;
        int xGap = 2;

        LabeledPairLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
            if (string.equals("label")) {
                this.labels.addElement(component);
            } else {
                this.fields.addElement(component);
            }
        }

        public void layoutContainer(Container container) {
            Insets insets = container.getInsets();
            int n = 0;
            Enumeration enumeration = this.labels.elements();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                JComponent jComponent = (JComponent)enumeration.nextElement();
                n = Math.max(n, jComponent.getPreferredSize().width);
            }
            int n2 = insets.top;
            Enumeration enumeration2 = this.fields.elements();
            enumeration = this.labels.elements();
            while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
                JComponent jComponent = (JComponent)enumeration.nextElement();
                JComponent jComponent2 = (JComponent)enumeration2.nextElement();
                int n3 = Math.max(jComponent.getPreferredSize().height, jComponent2.getPreferredSize().height);
                jComponent.setBounds(insets.left, n2, n, n3);
                jComponent2.setBounds(insets.left + n + this.xGap, n2, container.getSize().width - (n + this.xGap + insets.left + insets.right), n3);
                n2 += 30;
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            Insets insets = container.getInsets();
            int n = 0;
            Enumeration enumeration = this.labels.elements();
            while (enumeration.hasMoreElements()) {
                JComponent jComponent = (JComponent)enumeration.nextElement();
                n = Math.max(n, jComponent.getPreferredSize().width);
            }
            int n2 = insets.top;
            enumeration = this.labels.elements();
            Enumeration enumeration2 = this.fields.elements();
            while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
                JComponent jComponent = (JComponent)enumeration.nextElement();
                JComponent jComponent2 = (JComponent)enumeration2.nextElement();
                int n3 = Math.max(jComponent.getPreferredSize().height, jComponent2.getPreferredSize().height);
                n2 += n3 + this.yGap;
            }
            return new Dimension(n * 3, n2);
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = this.minimumLayoutSize(container);
            dimension.width *= 2;
            return dimension;
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

