/*
 * Decompiled with CFR 0.152.
 */
package fr.umlv.unitex;

import fr.outilex.OutilexEnvironment;
import fr.umlv.unitex.NumericTextField;
import fr.umlv.unitex.Preferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class FontMenu
extends JDialog {
    JTextField font = new JTextField(10);
    JTextField style = new JTextField(10);
    NumericTextField size = new NumericTextField(3, "");
    JTextField script = new JTextField(10);
    JTextField example = new JTextField(6);
    FontList fontList;
    StyleList styleList;
    SizeList sizeList;
    ScriptList scriptList;
    Hashtable styles;
    Hashtable ranges;
    private static final int ASCII_BASE = 0;
    private static final int GREEK_BASE = 880;
    private static final int HEBREW_BASE = 1424;
    private static final int ARABIC_BASE = 1536;
    private static final int THAI_BASE = 3584;
    private static final int GEORGIAN_BASE = 4256;
    private static final int HIRAGANA_BASE = 12352;
    private static final int KATAKANA_BASE = 12448;
    private static final int HANGUL_BASE = 12592;
    private static final int KANJI_BASE = 19968;
    boolean input;
    static FontMenu pref;
    String fontName;
    int fontStyle;
    int fontSize;
    int fontScript;
    Font res;
    OutilexEnvironment env;

    public FontMenu(boolean bl, OutilexEnvironment outilexEnvironment) {
        super(outilexEnvironment.mainFrame, "Font", true);
        this.env = outilexEnvironment;
        this.input = bl;
        if (this.input) {
            this.fontName = Preferences.temp.input.getName();
            this.fontStyle = Preferences.temp.input.getStyle();
            this.fontSize = Preferences.temp.inputSize;
        } else {
            this.fontName = Preferences.temp.output.getName();
            this.fontStyle = Preferences.temp.output.getStyle();
            this.fontSize = Preferences.temp.outputSize;
        }
        this.init();
        this.refresh();
        this.setContentPane(this.constructPanel());
        this.pack();
        this.setResizable(false);
        pref = this;
        this.showFontMenu();
    }

    public void showFontMenu() {
        this.setLocationRelativeTo(this.env.mainFrame);
        this.setVisible(true);
    }

    private JPanel constructPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.constructUpPanel(), "Center");
        jPanel.add((Component)this.constructDownPanel(), "South");
        return jPanel;
    }

    private JPanel constructUpPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.constructFontPanel(), "West");
        jPanel.add((Component)this.constructStylePanel(), "Center");
        jPanel.add((Component)this.constructSizePanel(), "East");
        return jPanel;
    }

    private JPanel constructDownPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.constructScriptPanel(), "West");
        jPanel.add((Component)this.constructExampleAndButtonPanel(), "Center");
        return jPanel;
    }

    private JPanel constructFontPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add(new JLabel(" Font: "));
        jPanel2.add(this.font);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.fontList, "Center");
        return jPanel;
    }

    private JPanel constructStylePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add(new JLabel(" Style: "));
        jPanel2.add(this.style);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.styleList, "Center");
        return jPanel;
    }

    private JPanel constructSizePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add(new JLabel(" Size: "));
        jPanel2.add(this.size);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.sizeList, "Center");
        return jPanel;
    }

    private JPanel constructScriptPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add(new JLabel(" Script: "));
        jPanel2.add(this.script);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.scriptList, "Center");
        return jPanel;
    }

    private JPanel constructExampleAndButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 5));
        jPanel.add((Component)this.constructExamplePanel(), "Center");
        jPanel.add((Component)this.constructButtonPanel(), "South");
        return jPanel;
    }

    private JPanel constructExamplePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new TitledBorder("Example"));
        jPanel.add((Component)new JPanel(), "West");
        jPanel.add((Component)this.example, "Center");
        jPanel.add((Component)new JPanel(), "East");
        return jPanel;
    }

    private JPanel constructButtonPanel() {
        JPanel jPanel = new JPanel();
        AbstractAction abstractAction = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FontMenu.this.input) {
                    Preferences.temp.input = new Font(FontMenu.this.fontName, FontMenu.this.fontStyle, (int)((double)FontMenu.this.fontSize / 0.72));
                    Preferences.temp.inputSize = FontMenu.this.fontSize;
                } else {
                    Preferences.temp.output = new Font(FontMenu.this.fontName, FontMenu.this.fontStyle, (int)((double)FontMenu.this.fontSize / 0.72));
                    Preferences.temp.outputSize = FontMenu.this.fontSize;
                }
                pref.setVisible(false);
            }
        };
        AbstractAction abstractAction2 = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent actionEvent) {
                pref.setVisible(false);
            }
        };
        JButton jButton = new JButton(abstractAction);
        JButton jButton2 = new JButton(abstractAction2);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    private void init() {
        int n;
        this.fontList = new FontList(7);
        this.font.setBackground(Color.white);
        this.font.setText("");
        this.styleList = new StyleList(7);
        this.style.setDisabledTextColor(Color.white);
        this.style.setBackground(Color.white);
        this.style.setText("");
        this.style.setEditable(false);
        this.sizeList = new SizeList(7);
        this.size.setDisabledTextColor(Color.white);
        this.size.setBackground(Color.white);
        this.size.setText("");
        this.size.setEditable(false);
        this.scriptList = new ScriptList(5);
        this.script.setDisabledTextColor(Color.white);
        this.script.setBackground(Color.white);
        this.script.setText("");
        this.script.setEditable(false);
        this.example.setText("AaBbCc");
        this.example.setEditable(false);
        this.example.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.styles = new Hashtable();
        this.styles.put("Plain", new Integer(0));
        this.styles.put("Bold", new Integer(1));
        this.styles.put("Italic", new Integer(2));
        this.styles.put("Bold Italic", new Integer(3));
        String[] stringArray = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};
        this.ranges = new Hashtable();
        this.ranges.put("Occidental", new Integer(0));
        this.ranges.put("Greek", new Integer(880));
        this.ranges.put("Hebrew", new Integer(1424));
        this.ranges.put("Arabic", new Integer(1536));
        this.ranges.put("Thai", new Integer(3584));
        this.ranges.put("Georgian", new Integer(4256));
        this.ranges.put("Hiragana", new Integer(12352));
        this.ranges.put("Katakana", new Integer(12448));
        this.ranges.put("Hangul", new Integer(12592));
        this.ranges.put("Kanji", new Integer(19968));
        String[] stringArray2 = new String[]{"Occidental", "Greek", "Hebrew", "Arabic", "Thai", "Georgian", "Hiragana", "Katakana", "Hangul", "Kanji"};
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray3 = graphicsEnvironment.getAvailableFontFamilyNames();
        for (n = 0; n < stringArray3.length; ++n) {
            if (stringArray3[n].equals("")) continue;
            this.fontList.add(stringArray3[n]);
        }
        this.fontList.addItemListener(new FontListener());
        for (n = 0; n < stringArray.length; ++n) {
            this.styleList.add(stringArray[n]);
        }
        this.styleList.addItemListener(new StyleListener());
        this.sizeList.add(String.valueOf(8));
        this.sizeList.add(String.valueOf(9));
        this.sizeList.add(String.valueOf(10));
        this.sizeList.add(String.valueOf(11));
        this.sizeList.add(String.valueOf(12));
        this.sizeList.add(String.valueOf(14));
        this.sizeList.add(String.valueOf(16));
        this.sizeList.add(String.valueOf(18));
        this.sizeList.add(String.valueOf(20));
        this.sizeList.add(String.valueOf(22));
        this.sizeList.add(String.valueOf(24));
        this.sizeList.add(String.valueOf(26));
        this.sizeList.add(String.valueOf(28));
        this.sizeList.add(String.valueOf(36));
        this.sizeList.add(String.valueOf(48));
        this.sizeList.add(String.valueOf(72));
        this.sizeList.addItemListener(new SizeListener());
        for (n = 0; n < stringArray2.length; ++n) {
            this.scriptList.add(stringArray2[n]);
        }
        this.scriptList.addItemListener(new RangeListener());
        this.scriptList.select(0);
    }

    int toInt(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n = n * 10 + string.charAt(i) - 48;
        }
        return n;
    }

    void refresh() {
        this.font.setText(this.fontName);
        if (this.fontStyle == 0) {
            this.style.setText("Plain");
        }
        if (this.fontStyle == 1) {
            this.style.setText("Bold");
        }
        if (this.fontStyle == 2) {
            this.style.setText("Italic");
        }
        if (this.fontStyle == 3) {
            this.style.setText("Bold Italic");
        }
        this.size.setText(String.valueOf(this.fontSize));
        this.script.setText(this.scriptList.getSelectedItem());
        this.res = new Font(this.fontName, this.fontStyle, (int)((double)this.fontSize / 0.72));
        this.example.setFont(this.res);
        if (this.fontScript == 0) {
            this.example.setText("AaBbCc");
        }
        if (this.fontScript == 880) {
            this.example.setText("\u0391\u03b1\u0392\u03b2\u0393\u03b3");
        }
        if (this.fontScript == 1424) {
            this.example.setText("\u05d0\u05d1\u05d2\u05d3\u05d4\u05d5");
        }
        if (this.fontScript == 1536) {
            this.example.setText("\u0621\u0622\u0623\u0624\u0625\u0626");
        }
        if (this.fontScript == 3584) {
            this.example.setText("\u0e01\u0e02\u0e03\u0e04\u0e05\u0e06");
        }
        if (this.fontScript == 4256) {
            this.example.setText("\u10a0\u10a1\u10a2\u10a3\u10a4\u10a5");
        }
        if (this.fontScript == 12352) {
            this.example.setText("\u3041\u3042\u3043\u3044\u3045\u3046");
        }
        if (this.fontScript == 12448) {
            this.example.setText("\u30a1\u30a2\u30a3\u30a4\u30a5\u30a6");
        }
        if (this.fontScript == 12592) {
            this.example.setText("\u3131\u3132\u3133\u3134\u3135\u3136");
        }
        if (this.fontScript == 19968) {
            this.example.setText("\u4e07\u4e08\u4e09\u4e0a\u4e0b\u4e5f");
        }
    }

    class ScriptList
    extends List {
        public ScriptList(int n) {
            super(n);
        }

        public Dimension getPreferredSize() {
            return new Dimension(50, 50);
        }
    }

    class SizeList
    extends List {
        public SizeList(int n) {
            super(n);
        }

        public Dimension getPreferredSize() {
            return new Dimension(50, 100);
        }
    }

    class StyleList
    extends List {
        public StyleList(int n) {
            super(n);
        }

        public Dimension getPreferredSize() {
            return new Dimension(120, 100);
        }
    }

    class FontList
    extends List {
        public FontList(int n) {
            super(n);
        }

        public Dimension getPreferredSize() {
            return new Dimension(150, 100);
        }
    }

    class RangeListener
    implements ItemListener {
        RangeListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            FontMenu.this.script.setText(FontMenu.this.scriptList.getSelectedItem());
            FontMenu.this.fontScript = (Integer)FontMenu.this.ranges.get(FontMenu.this.scriptList.getSelectedItem());
            FontMenu.this.refresh();
        }
    }

    class SizeListener
    implements ItemListener {
        SizeListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            FontMenu.this.size.setText(FontMenu.this.sizeList.getSelectedItem());
            FontMenu.this.fontSize = FontMenu.this.toInt(FontMenu.this.size.getText());
            FontMenu.this.refresh();
        }
    }

    class StyleListener
    implements ItemListener {
        StyleListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            FontMenu.this.style.setText(FontMenu.this.styleList.getSelectedItem());
            FontMenu.this.fontStyle = (Integer)FontMenu.this.styles.get(FontMenu.this.styleList.getSelectedItem());
            FontMenu.this.refresh();
        }
    }

    class FontListener
    implements ItemListener {
        FontListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            FontMenu.this.font.setText(FontMenu.this.fontList.getSelectedItem());
            FontMenu.this.fontName = FontMenu.this.font.getText();
            FontMenu.this.refresh();
        }
    }
}

