/*
 * Decompiled with CFR 0.152.
 */
package fr.outilex.projects;

import fr.outilex.dictionaries.Dico;
import fr.outilex.grammars.Grammar;
import fr.outilex.texts.Text;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OutilexProject {
    String projectPath = null;
    String language = "french";
    String locateGraph = "";
    ArrayList texts = new ArrayList();
    ArrayList grammars = new ArrayList();
    ArrayList dicos = new ArrayList();

    public void setProjectPath(String string) {
        this.projectPath = string;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setLocateGraph(String string) {
        this.locateGraph = string;
    }

    public String getLocateGraph() {
        return this.locateGraph;
    }

    public ArrayList getTexts() {
        return this.texts;
    }

    public ArrayList getDicos() {
        return this.dicos;
    }

    public ArrayList getGrammars() {
        return this.grammars;
    }

    public String getLanguage() {
        return this.language;
    }

    public void addText(Text text) {
        this.texts.add(text);
    }

    public void addGrammar(Grammar grammar) {
        this.grammars.add(grammar);
    }

    public void addDico(Dico dico) {
        this.dicos.add(dico);
    }

    public void setLanguage(String string) {
        this.language = string.toLowerCase();
    }

    public void removeText(Text text) {
        this.texts.remove(text);
    }

    public void removeGrammar(Grammar grammar) {
        this.grammars.remove(grammar);
    }

    public void removeDico(Dico dico) {
        this.dicos.remove(dico);
    }

    public void removeText(int n) {
        this.texts.remove(n);
    }

    public void removeGrammar(int n) {
        this.grammars.remove(n);
    }

    public void removeDico(int n) {
        this.dicos.remove(n);
    }

    public void clearTexts() {
        this.texts.clear();
    }

    public void clearGrammars() {
        this.grammars.clear();
    }

    public void clearDicos() {
        this.dicos.clear();
    }

    public void clearProject() {
        this.clearDicos();
        this.clearTexts();
        this.clearGrammars();
    }

    public void newProject() {
        this.clearProject();
    }

    public boolean open(String string) {
        this.clearProject();
        if (this.readXML(string)) {
            this.projectPath = string;
            return true;
        }
        return false;
    }

    public boolean save(String string) {
        if (this.writeXML(string)) {
            this.projectPath = string;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.texts.toString();
    }

    public void writeTexts(Writer writer) throws Exception {
        try {
            for (int i = 0; i < this.texts.size(); ++i) {
                String string = ((Text)this.texts.get(i)).getPath();
                writer.write("<r type=\"text\" path=\"" + string + "\"/>\n");
            }
        }
        catch (Exception exception) {
            throw new Exception();
        }
    }

    public void writeDicos(Writer writer) throws Exception {
        try {
            for (int i = 0; i < this.dicos.size(); ++i) {
                Dico dico = (Dico)this.dicos.get(i);
                String string = dico.getPath();
                String string2 = "" + dico.getPriority();
                writer.write("<r type=\"dico\" path=\"" + string + "\" priority=\"" + string2 + "\"/>\n");
            }
        }
        catch (Exception exception) {
            throw new Exception();
        }
    }

    public void writeGrammars(Writer writer) throws Exception {
        try {
            for (int i = 0; i < this.grammars.size(); ++i) {
                String string = ((Grammar)this.grammars.get(i)).getPath();
                writer.write("<r type=\"graph\" path=\"" + string + "\"/>\n");
            }
        }
        catch (Exception exception) {
            throw new Exception();
        }
    }

    public void writeLanguage(Writer writer) throws Exception {
        try {
            writer.write("<r type=\"language\" path=\"" + this.language + "\"/>\n");
        }
        catch (Exception exception) {
            throw new Exception();
        }
    }

    public void writeLocateGraph(Writer writer) throws Exception {
        try {
            writer.write("<r type=\"locate\" path=\"" + this.locateGraph + "\"/>\n");
        }
        catch (Exception exception) {
            throw new Exception();
        }
    }

    public void writeResources(Writer writer) throws Exception {
        try {
            writer.write("<resources>\n");
            this.writeLanguage(writer);
            this.writeTexts(writer);
            this.writeDicos(writer);
            this.writeGrammars(writer);
            this.writeLocateGraph(writer);
            writer.write("</resources>\n");
        }
        catch (Exception exception) {
            throw new Exception();
        }
    }

    public boolean writeXML(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
            bufferedWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            bufferedWriter.write("<outilex-project>\n");
            this.writeResources(bufferedWriter);
            bufferedWriter.write("</outilex-project>\n");
            ((Writer)bufferedWriter).close();
            return true;
        }
        catch (Exception exception) {
            System.out.println("cannot save project");
            return false;
        }
    }

    public boolean readXML(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            document.getDocumentElement().normalize();
            Element element = (Element)document.getElementsByTagName("resources").item(0);
            if (element == null) {
                System.out.println("element <resources> is missing in " + string);
                return false;
            }
            NodeList nodeList = element.getElementsByTagName("r");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string2 = element2.getAttribute("type");
                String string3 = element2.getAttribute("path");
                if (string2.equals("text")) {
                    this.addText(new Text(string3));
                }
                if (string2.equals("dico")) {
                    String string4 = element2.getAttribute("priority");
                    if (string4 == null) {
                        this.addDico(new Dico(string3));
                    } else {
                        this.addDico(new Dico(string3, string4));
                    }
                }
                if (string2.equals("graph")) {
                    this.addGrammar(new Grammar(string3));
                }
                if (string2.equals("language")) {
                    this.setLanguage(string3);
                }
                if (!string2.equals("locate")) continue;
                this.setLocateGraph(string3);
            }
            return true;
        }
        catch (Exception exception) {
            System.out.println("cannot open project " + string);
            return false;
        }
    }
}

