/*
 * Decompiled with CFR 0.152.
 */
package fr.outilex.process;

import fr.outilex.OutilexEnvironment;
import fr.outilex.config.OutilexParameters;
import fr.outilex.dictionaries.DicoActionListener;
import fr.outilex.process.Command;
import fr.outilex.process.DisplayResultThread;
import fr.outilex.process.ProcessException;
import fr.outilex.projects.ProjectActionListener;
import fr.outilex.texts.TextActionListener;
import fr.outilex.texts.TextFsa;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ProcessInfo
extends JDialog {
    int currentTask;
    String sufexe;
    ArrayList tasks;
    Process currentProcess;
    public JTextArea output;
    JButton ok;
    JButton cancel;
    boolean end;
    OutilexEnvironment env;

    public ProcessInfo(ArrayList arrayList, OutilexEnvironment outilexEnvironment) {
        super((Frame)outilexEnvironment.mainFrame, "Process");
        this.env = outilexEnvironment;
        this.setSize(400, 350);
        this.tasks = arrayList;
        this.end = false;
        this.sufexe = "";
        if (!System.getProperty("os.name").equals("Linux")) {
            this.sufexe = ".exe";
        }
        this.currentProcess = null;
        this.currentTask = 0;
        this.output = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.output);
        jScrollPane.setPreferredSize(new Dimension(400, 270));
        this.output.setLineWrap(true);
        this.ok = new JButton("OK");
        final ProcessInfo processInfo = this;
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ProcessInfo.this.end) {
                    processInfo.setVisible(false);
                }
            }
        });
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ProcessInfo.this.end) {
                    ProcessInfo.this.currentProcess.destroy();
                }
                processInfo.setVisible(false);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.ok);
        jPanel.add(this.cancel);
        Container container = this.getContentPane();
        container.add((Component)jScrollPane, "North");
        container.add((Component)jPanel, "South");
    }

    public void printError(String string) {
        this.output.setForeground(Color.RED);
        this.output.append(string);
        this.output.append("\n");
        this.output.setForeground(Color.BLACK);
    }

    public void print(String string) {
        this.output.setForeground(Color.BLACK);
        this.output.append(string);
    }

    public void println(String string) {
        this.print(string + "\n");
    }

    public void printLogFile(String string) {
        try {
            FileWriter fileWriter = new FileWriter(OutilexParameters.LOGFILE, true);
            fileWriter.write(string + "\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void start() {
        if (this.tasks == null || this.tasks.size() <= 0) {
            return;
        }
        this.setVisible(true);
        new Thread(){

            public void run() {
                try {
                    if (ProcessInfo.this.tasks == null) {
                        return;
                    }
                    ProcessInfo.this.currentTask = 0;
                    while (ProcessInfo.this.currentTask < ProcessInfo.this.tasks.size()) {
                        ProcessInfo.this.launchProcess(ProcessInfo.this.tasks.get(ProcessInfo.this.currentTask));
                        ++ProcessInfo.this.currentTask;
                    }
                    ProcessInfo.this.println("\nThe processing flow is done.");
                    ProcessInfo.this.end = true;
                }
                catch (ProcessException processException) {
                    ProcessInfo.this.end = true;
                }
            }
        }.start();
    }

    public void launchProcess(Object object) throws ProcessException {
        try {
            if (object instanceof Command) {
                Command command = (Command)object;
                if (command.getType() == Command.PROG) {
                    this.launchProgProcess(command);
                    return;
                }
                if (command.getType() == Command.FILE) {
                    this.launchFileProcess(command);
                    return;
                }
                if (command.getType() == Command.OUTILEX) {
                    this.launchOutilexProcess(command);
                    return;
                }
            }
            throw new ProcessException();
        }
        catch (ProcessException processException) {
            throw new ProcessException();
        }
    }

    void copyFile(String[] stringArray) throws ProcessException {
        try {
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(stringArray[1]));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(stringArray[2]));
            while ((n = bufferedInputStream.read()) != -1) {
                bufferedOutputStream.write(n);
            }
            bufferedOutputStream.close();
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            this.printError(stringArray[1] + " cannot be copied into " + stringArray[2]);
            throw new ProcessException();
        }
    }

    void moveFile(String[] stringArray) throws ProcessException {
        File file = new File(stringArray[1]);
        File file2 = new File(stringArray[2]);
        this.println("Moving file...");
        if (!file.renameTo(file2)) {
            this.printError(file.getAbsolutePath() + " cannot be renamed to " + file2.getAbsolutePath());
            throw new ProcessException();
        }
    }

    void deleteFile(String[] stringArray) {
        File file = new File(stringArray[1]);
        this.println("Deleting file " + file.getAbsolutePath() + "...");
        file.delete();
    }

    void createDir(String[] stringArray) throws ProcessException {
        File file = new File(stringArray[1]);
        this.println("Creating directory...");
        if (file.exists()) {
            return;
        }
        if (!file.mkdir()) {
            this.printError("Cannot create directory " + stringArray[1]);
            throw new ProcessException();
        }
    }

    public void launchFileProcess(Command command) throws ProcessException {
        String string = command.getProg();
        this.printLogFile(command.toString());
        try {
            if (string.equals("mv" + this.sufexe)) {
                this.moveFile(command.getCommand());
                return;
            }
            if (string.equals("mkdir" + this.sufexe)) {
                this.createDir(command.getCommand());
                return;
            }
            if (string.equals("cp" + this.sufexe)) {
                this.copyFile(command.getCommand());
                return;
            }
            if (string.equals("rm" + this.sufexe)) {
                this.deleteFile(command.getCommand());
                return;
            }
        }
        catch (ProcessException processException) {
            throw new ProcessException();
        }
    }

    public void tfsaView() {
        Component component = this.env.contentPane.getSelectedComponent();
        if (component instanceof TextFsa) {
            TextFsa textFsa = (TextFsa)component;
            textFsa.setSentenceImage();
            textFsa.validate();
            textFsa.repaint();
        }
    }

    public void launchOutilexProcess(Command command) throws ProcessException {
        String string = command.getProg();
        String[] stringArray = command.getCommand();
        if (string.equals("opendic" + this.sufexe)) {
            DicoActionListener.openDico(stringArray[1], this.env, true);
            return;
        }
        if (string.equals("opentext" + this.sufexe)) {
            TextActionListener.openText(stringArray[1], this.env, true);
            return;
        }
        if (string.equals("opentextfsa" + this.sufexe)) {
            TextActionListener.openTextFsa(stringArray[1], this.env, true);
            return;
        }
        if (string.equals("opentextfsawithoutnewprocessframe" + this.sufexe)) {
            TextActionListener.openTextFsa(stringArray[1], this.env, false);
            return;
        }
        if (string.equals("openreadtext" + this.sufexe)) {
            TextActionListener.openText(stringArray[1], this.env, false);
            return;
        }
        if (string.equals("tfsaview" + this.sufexe)) {
            this.tfsaView();
            return;
        }
        if (string.equals("addtext" + this.sufexe)) {
            TextActionListener.addText(stringArray[1], this.env);
        }
        if (string.equals("browse" + this.sufexe)) {
            ProjectActionListener.browseResource2(this.env, stringArray[1]);
        }
        throw new ProcessException();
    }

    public void launchProgProcess(Command command) throws ProcessException {
        try {
            this.printLogFile(command.toString());
            this.println("Processing with " + command.getProg() + "...");
            this.currentProcess = Runtime.getRuntime().exec(command.getCommand());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.currentProcess.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(this.currentProcess.getErrorStream()));
            new DisplayResultThread(bufferedReader, this).start();
            new DisplayResultThread(bufferedReader2, this).start();
            this.currentProcess.waitFor();
            if (this.currentProcess.exitValue() != 0) {
                this.printError("\n" + this.currentProcess.exitValue() + " is the exit value! ERROR!");
                throw new ProcessException();
            }
            return;
        }
        catch (IOException iOException) {
            this.printError("\nCannot launch process " + command.getProg() + "\n" + iOException.toString());
            throw new ProcessException();
        }
        catch (InterruptedException interruptedException) {
            this.printError("\nProcess " + command.getProg() + " was interrupted");
            throw new ProcessException();
        }
    }
}

