/*
 * Decompiled with CFR 0.152.
 */
package fr.outilex;

import fr.outilex.ConcordPane;
import fr.outilex.DicoResourcePane;
import fr.outilex.GrfResourcePane;
import fr.outilex.LocatePane;
import fr.outilex.OutilexContentPane;
import fr.outilex.OutilexEnvironment;
import fr.outilex.OutilexProcessDialog;
import fr.outilex.OutilexToolBar;
import fr.outilex.process.ProcessActionListener;
import fr.outilex.projects.DataMouseListener;
import fr.outilex.projects.DataPopupMenu;
import fr.outilex.projects.DicoListModel;
import fr.outilex.projects.GrammarListModel;
import fr.outilex.projects.OutilexProject;
import fr.outilex.projects.TextListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class OutilexMainPanel
extends JPanel {
    private int FRAME_WIDTH;
    private int FRAME_HEIGHT;
    private int LEFT_WIDTH;
    private int RIGHT_WIDTH;
    private int LEFT_HEIGHT;
    private int RIGHT_HEIGHT;
    private int SMALL_HEIGHT;
    public OutilexProject project;
    public OutilexContentPane contentPane;
    public JList dicos;
    public JList texts;
    public JList grfs;
    public JList elags;
    public JPanel processPane;
    public LocatePane locatePane;
    public ConcordPane concordPane;
    public GrfResourcePane grfRPane;
    public DicoResourcePane dicoRPane;
    public JScrollPane processPaneScp;
    public JCheckBox clean;
    public JCheckBox normalize;
    public JCheckBox segment;
    public JCheckBox applyDico;
    public JCheckBox applyGrf;
    public JCheckBox elagFSA;
    public JCheckBox viewFSA;
    public JCheckBox locatePattern;
    public JCheckBox buildConcordance;
    private OutilexEnvironment env;

    public OutilexMainPanel(OutilexEnvironment outilexEnvironment) {
        this.env = outilexEnvironment;
        this.init(this.env);
        this.setLayout(new BorderLayout());
        this.createProcessPane();
        this.processPaneScp = new JScrollPane(this.processPane);
        this.processPaneScp.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.processPaneScp, "West");
        this.add((Component)this.contentPane, "Center");
    }

    private void init(OutilexEnvironment outilexEnvironment) {
        this.FRAME_WIDTH = outilexEnvironment.mainFrame.getWidth();
        this.FRAME_HEIGHT = outilexEnvironment.mainFrame.getHeight();
        this.LEFT_WIDTH = this.FRAME_WIDTH / 4;
        this.RIGHT_WIDTH = this.FRAME_WIDTH - this.LEFT_WIDTH - 20;
        this.RIGHT_HEIGHT = this.LEFT_HEIGHT = this.FRAME_HEIGHT - OutilexToolBar.HEIGHT - 60;
        this.SMALL_HEIGHT = this.LEFT_HEIGHT / 6 - 5;
        outilexEnvironment.mainPanel = this;
        outilexEnvironment.project = this.project = new OutilexProject();
        this.texts = new JList(new TextListModel(this.project));
        outilexEnvironment.texts = this.texts;
        this.dicos = new JList(new DicoListModel(this.project));
        outilexEnvironment.dicos = this.dicos;
        this.grfs = new JList(new GrammarListModel(this.project));
        outilexEnvironment.grfs = this.grfs;
        this.elags = new JList();
        outilexEnvironment.elags = this.elags;
        this.processPane = new JPanel();
        this.concordPane = new ConcordPane(outilexEnvironment);
        this.locatePane = new LocatePane(outilexEnvironment);
        this.grfRPane = new GrfResourcePane(outilexEnvironment);
        this.dicoRPane = new DicoResourcePane(outilexEnvironment);
        outilexEnvironment.contentPane = this.contentPane = new OutilexContentPane(outilexEnvironment);
    }

    public void createProcessPane() {
        this.processPane.setLayout(new BorderLayout());
        this.processPane.setPreferredSize(new Dimension(this.LEFT_WIDTH, this.LEFT_HEIGHT));
        JPanel jPanel = this.createTopPanel();
        this.processPane.setMaximumSize(new Dimension(this.LEFT_WIDTH, this.LEFT_HEIGHT / 6));
        this.processPane.add((Component)jPanel, "North");
        this.processPane.add((Component)this.createApplicationPanel(), "Center");
    }

    public JPanel createTopPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createLanguagePanel(), "North");
        jPanel.add((Component)this.createTextsPanel(), "Center");
        return jPanel;
    }

    public JPanel createTextsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Texts"));
        JScrollPane jScrollPane = new JScrollPane(this.texts);
        jPanel.add((Component)jScrollPane, "Center");
        this.texts.setComponentPopupMenu(new DataPopupMenu(this.env, this.texts));
        this.texts.addMouseListener(new DataMouseListener(this.env, this.texts));
        return jPanel;
    }

    public JPanel createLanguagePanel() {
        JPanel jPanel = new JPanel();
        Object[] objectArray = new Object[]{"French", "English"};
        JLabel jLabel = new JLabel("Language:");
        final JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                String string = (String)jComboBox.getSelectedItem();
                if (string != null && !string.equals("")) {
                    OutilexMainPanel.this.project.setLanguage(string);
                }
            }
        });
        jPanel.add(jLabel);
        jPanel.add(jComboBox);
        return jPanel;
    }

    public void initOperations() {
        this.clean = new JCheckBox("Clean old intermediate results");
        this.clean.setAlignmentX(0.0f);
        this.clean.addActionListener(new ProcessActionListener("clean", this.env, this));
        this.normalize = new JCheckBox("Normalization");
        this.normalize.setAlignmentX(0.0f);
        this.normalize.addActionListener(new ProcessActionListener("normalize", this.env, this));
        this.normalize.setToolTipText("normalize text automaton");
        this.segment = new JCheckBox("Segmentation");
        this.segment.setAlignmentX(0.0f);
        this.segment.addActionListener(new ProcessActionListener("segment", this.env, this));
        this.segment.setToolTipText("segmentation in tokens and sentences of the selected text");
        this.applyDico = new JCheckBox("Apply dictionaries");
        this.applyDico.setAlignmentX(0.0f);
        this.applyDico.addActionListener(new ProcessActionListener("applyDico", this.env, this));
        this.applyDico.setToolTipText("application of selected dictionaries on segmented selected text and construction of text automaton");
        this.applyGrf = new JCheckBox("Apply graph cascadus");
        this.applyGrf.setAlignmentX(0.0f);
        this.applyGrf.addActionListener(new ProcessActionListener("applyGrf", this.env, this));
        this.applyGrf.setToolTipText("Apply graphs on text automaton and creation of new transitions for new analyses");
        this.elagFSA = new JCheckBox("Elag text FSA");
        this.elagFSA.setAlignmentX(0.0f);
        this.elagFSA.addActionListener(new ProcessActionListener("elagFSA", this.env, this));
        this.viewFSA = new JCheckBox("View text FSA");
        this.viewFSA.setAlignmentX(0.0f);
        this.viewFSA.addActionListener(new ProcessActionListener("viewFSA", this.env, this));
        this.viewFSA.setToolTipText("Open text automaton of selected text");
        this.locatePattern = new JCheckBox("Locate pattern");
        this.locatePattern.setAlignmentX(0.0f);
        this.locatePattern.addActionListener(new ProcessActionListener("locatePattern", this.env, this));
        this.locatePattern.setToolTipText("Locate pattern represented by a grammar on selected text");
        this.buildConcordance = new JCheckBox("Build concordance");
        this.buildConcordance.setAlignmentX(0.0f);
        this.buildConcordance.addActionListener(new ProcessActionListener("buildConcordance", this.env, this));
    }

    public JPanel createApplicationPanel() {
        JPanel jPanel = new JPanel(null);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder("Text Processing"));
        this.initOperations();
        this.populateOperations(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentX(0.0f);
        JButton jButton = new JButton("GO");
        jButton.addActionListener(new ProcessActionListener("go", this.env, this));
        JButton jButton2 = new JButton("Default");
        jButton2.addActionListener(new ProcessActionListener("default", this.env, this));
        JButton jButton3 = new JButton("Clear");
        jButton3.addActionListener(new ProcessActionListener("clear", this.env, this));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jPanel.add(jPanel2);
        ProcessActionListener.init(this);
        return jPanel;
    }

    private void populateOperations(JPanel jPanel) {
        JCheckBox[] jCheckBoxArray = new JCheckBox[]{this.clean, this.segment, this.applyDico, this.normalize, this.applyGrf, this.locatePattern, this.buildConcordance};
        final JComponent[] jComponentArray = new JComponent[]{null, null, this.dicoRPane, null, this.grfRPane, this.locatePane, this.concordPane};
        final String[] stringArray = new String[]{"", "", "Select dictionaries", "", "Apply graph cascadus", "Locate Pattern", "Concordances"};
        for (int i = 0; i < jCheckBoxArray.length; ++i) {
            final int n = i;
            jPanel.add(jCheckBoxArray[i]);
            if (jComponentArray[i] == null) continue;
            JButton jButton = new JButton("more...");
            jButton.setPreferredSize(new Dimension(15, 15));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OutilexProcessDialog outilexProcessDialog = new OutilexProcessDialog(((OutilexMainPanel)OutilexMainPanel.this).env.mainFrame, jComponentArray[n], stringArray[n]);
                    outilexProcessDialog.setVisible(true);
                }
            });
            jPanel.add(jButton);
        }
    }
}

