#ifndef TYPE_HTML_H
#define TYPE_HTML_H

#include <string>

typedef enum { hisNorm, hisSkip, hisPre } HIS;       // HTML Internal State

// MAX is the higher level that can not be closed by a tag: it is used to
// guarantee that stack will never been empty
// MSO tags defines as a bit more stronger than TYPESET
enum typeblock { NOCLOSE, TYPESET, MSO, TABLE, BLOCKLEVEL, TOPLEVEL, HTML, MAX  };

enum typetag { NOTYPESETTAG,TYPESETTAG,SKIPTAG,LOWLEVELTAG,BLOCKLEVELTAG,SINGLETAG,TOPLEVELTAG,TABLETAG,LISTTAG,SIMPLETAG,INSETTAG,BLOCKMODIFIERTAG,METATAG };

enum CHECK_CODE { BAD, UNSTRICT, CORRECT };

typedef struct {
  const char *nametag;
  typetag ttag;
  int segmentingtag;
  typeblock	leveltag;
  const char * property;
} tagdef;
int findTag(const char *s,tagdef &t); // defined in htmldef.cc

typedef struct {
  const char *nameentity;
  const char *equiventity;
} entitydef;
int findEntity(const char *s,entitydef &t); // defined in htmldef.cc

class SAVE                // property save structure
{
 public:
  SAVE():his(hisNorm),block_name(""),block_level(MAX) {}
  SAVE &operator=(const SAVE &s) {
    pNext=NULL;
    his=s.his;
    block_name=s.block_name;
    block_level=s.block_level;
    bmarkid=s.bmarkid;
    //chp=s.chp;
    return *this;
  }
  SAVE *pNext;             // next save
  HIS his;
  std::string block_name;       // save name of current block
  typeblock block_level;   // and its level to enable unstack non closed tags
  std::string bmarkid;
  tagdef block;            // the type of block itself for more information
  //htmlchp chp;
};

#endif
