#ifndef DOCUMENT_H
#define DOCUMENT_H

#include <libxml/xmlmemory.h>
#include <libxml/parser.h>

#include <string>
#include <map>
#include <list>

#include "htmltype.h"
#include "ParseHTML.h"

#include "CharsetConvert.h"


struct attr {
  std::string name;
  std::string value;
};

class documentHTML {
 public:
  documentHTML(xmlNodePtr r):psave(NULL),current_conv(0),countc(0),par_id(1),root(r),par(NULL),new_ts(false),addedText(0),taghasspace(0),tshasspace(0),subflowid(0),textendingspace(""),wrap_next_newline(true),html_block_tag(false) { newPar(); }
  ~documentHTML() { if(current_conv) delete current_conv; }
  int push_state() {
    SAVE *psaveNew = new SAVE(current);
    if (!psaveNew) return ecHTML_StackOverflow;
    psaveNew -> pNext = psave;
    psave=psaveNew;
    return ecOK;
  }
  CHECK_CODE closetag(const std::string &nblock,typeblock lblock);
  SAVE current;

  // Current stack
  SAVE *psave;

  enum restriction { _both,_source,_target };

  std::map<std::string,int> MapLang;
  void FlushTag(restriction restricted=_both);
  void FlushTs();
  void FlushText();
  void AddTag(const std::string &,bool,restriction restricted=_both,bool block_tag=false);
  //void AddTs(const htmlchp &);
  std::string AddSubFlow(std::string value,bool raw);
  std::string AddBmark(std::list<attr> &la);
  void AddEmark(const std::string &id);
  void AddSpace(const std::string &);
  void AddText(const std::string &,const std::string &lang);
  void newPar();
  void setNoTypesetPar();
  void close();
  inline xmlNodePtr getRoot() { return root; }
  CharsetConvertor *current_conv;
  int countc;
 private:
  int par_id;
  xmlNodePtr root;
  xmlNodePtr par;
  std::string current_tag;
  //htmlchp current_ts;
  bool new_ts;
  std::string current_text;
  int addedText; // count if text has been added in current par
  int taghasspace;
  int tshasspace;
  int subflowid;
  std::string textendingspace; // text is integrated to tag if any
  std::map<std::string,bool> SystranMarkMet;
  bool wrap_next_newline;
  bool html_block_tag;
};

extern documentHTML *pCurrentDocH;

#endif /* #ifdef DOCUMENT_H */


