#include "DocFilters.h"

using namespace std;

Document::Document(const std::string &document) :
  //segmented(_none),
  //translated(_none),
  xmltree(0),
  buffer(document),
  filter_data(0),
  original_filter_data(0)
  //filter(0),
  //original_filter(0)
{ }

Document::~Document() {
  if (xmltree) {
    //cleanDoc(xmltree);
    xmlFreeDoc(xmltree);
  }
}

// generic document format pre- and post-translation filters.

int CreateDocXml(DocumentPtr D) {
  D->xmltree = xmlNewDoc((const xmlChar *)XML_DEFAULT_VERSION);

  xmlCreateIntSubset(
      D->xmltree,
      (const xmlChar *) "document",
      (const xmlChar *) "-//SYSTRAN//DTD XML Internal Format 1.0//EN",
      (const xmlChar *)"http://www.systransoft.com/XML/sts/1.0/SystranInternal.dtd");

  xmlNodePtr root=xmlNewNode (NULL,(const xmlChar *)"document");
  xmlDocSetRootElement(D->xmltree,root);

  if (!D->xmltree || !root) {
    fprintf(stderr,"Error in internal filter (1)\n");
    return 0;
  }

  return 1;
}

DocumentPtr PreFilter(FILE *f, const char *type) {
  stringstream s;

  char buffer[10000];
  int len;
  while (!feof(f)) {
    len = fread(buffer, 1, 10000, f);
    s << buffer;
  }
 
  return PreFilter(s.str().c_str(), type);
}

DocumentPtr PreFilter(const char *input, const char *type) {

  DocumentPtr Doc = new Document(std::string(input,strlen(input)));

  if (!CreateDocXml(Doc)) {
    delete Doc;
    return 0;
  }

  if (!strcmp(type,"html")) return PreFilterHTML(Doc);
  else if(!strcmp(type,"txt")) return PreFilterTXT(Doc);
  else {
    fprintf(stdout,"PreFilter can be of type html or txt\n");
    return NULL;
  }
}

std::string PostFilter(DocumentPtr Doc, const char *type) {

  if (!strcmp(type,"html")) return PostFilterHTML(Doc);
  else if(!strcmp(type,"txt")) return PostFilterTXT(Doc);
  else {
    fprintf(stdout,"PostFilter can be of type html or txt\n");
    return NULL;
  }  
}
