#ifndef CHARSETCONVERT_H
#define CHARSETCONVERT_H

#ifdef __cplusplus

#include <string>

#include <iconv.h>

class InvalidCharset {}; // Exception thrown by CharsetConvertor constructor

class CharsetConvertor {
  /* The CharsetConvertor class is a C++ wrapper for iconv */
  std::string source;
  std::string target;
  iconv_t it;
  unsigned nb_read_bytes;
  unsigned nb_bad_bytes;
  unsigned nb_bad_bytes_last_conversion;
  bool is_ok;
  
  void operator=(const CharsetConvertor &) {}   // No public assignment operator
  CharsetConvertor(const CharsetConvertor &) {} // No public copy constructor

 protected:
  virtual int IncorrectCharacter(const std::string &charset,const char *character,std::string &conversion) = 0;
  
 public:
  CharsetConvertor(const std::string &source_charset,
                   const std::string &target_charset);
  virtual ~CharsetConvertor();
  std::string Convert(const char *to_convert,
                      size_t size=static_cast<size_t>(-1));
  inline std::string Convert(const std::string &s) {
    return Convert(s.data(),s.size());
  }
  inline double GetErrorRatio() const { return static_cast<double>(nb_read_bytes)/nb_bad_bytes; }
  inline unsigned GetBadBytesLastConvert() const { return nb_bad_bytes_last_conversion; }
  inline bool IsOk() const { return is_ok; }
};

class DefaultCharsetConvertor : public CharsetConvertor {
 protected:
  int IncorrectCharacter(const std::string &charset,const char *character,std::string &conversion);

 public:
  DefaultCharsetConvertor(const std::string &source_charset,
                          const std::string &target_charset) : 
                CharsetConvertor(source_charset,target_charset) {}
};

std::string MessagesConvert(const std::string &m);

extern "C" {
  
#endif /* __cplusplus */

const char *MessagesConvert(const char *m);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* CHARSETCONVERT_H */
