
#include "CharsetConvert.h"
#include "EncodingIANA.h"
#include <cstdlib>
//#include "Options.h"


CharsetConvertor::CharsetConvertor(const std::string &source_charset,
                                   const std::string &target_charset)
{
  const char *s=FindISOCharset(source_charset.c_str());
  const char *t=FindISOCharset(target_charset.c_str());

  source=s?s:source_charset;
  target=t?t:target_charset;

  if (source==target) {
    is_ok=true;
    it=0;
 }
  else {
    it=iconv_open(target.c_str(),source.c_str());
    if(it==reinterpret_cast<iconv_t>(-1))
      is_ok=false;
    else
      is_ok=true;
  }
  nb_read_bytes=0;
  nb_bad_bytes=0;
}

CharsetConvertor::~CharsetConvertor()
{
  if(is_ok && it)
    iconv_close(it);
}

std::string CharsetConvertor::Convert(const char *to_convert,
                                      size_t sizei)
{ 
  if(!is_ok || !it)
    return to_convert;

  nb_bad_bytes_last_conversion=0;

  if(sizei==static_cast<size_t>(-1))
    sizei=strlen(to_convert);
  size_t current_buffer_size=sizei*2+5;
  size_t sizeo=current_buffer_size-1;
  char *obuf=(char *)malloc(current_buffer_size*sizeof(char));
  char *refobuf=obuf;
  const char *ibuf=to_convert;
  bool loop_again;
  do {
    loop_again=false;
#if defined(WIN32) || defined (SOLARIS)
    size_t n=iconv(it,&ibuf,&sizei,&obuf,&sizeo);
#else
    size_t n=iconv(it,const_cast<char **>(&ibuf),&sizei,&obuf,&sizeo);
#endif
    if(n==static_cast<size_t>(-1) && sizei) {
      std::string conversion;
      int nb_bytes_to_drop=-1;
      if(sizeo)
        nb_bytes_to_drop=IncorrectCharacter(source,ibuf,conversion);
      while(conversion.size()>=sizeo) {
	sizeo+=current_buffer_size;
	current_buffer_size*=2;
	size_t p=obuf-refobuf;
	refobuf=(char*)realloc((void *)refobuf,current_buffer_size);
	obuf=refobuf+p;
	if(!refobuf)
	  return "";
      }
      if(nb_bytes_to_drop!=-1) {
	strncpy(obuf,conversion.c_str(),conversion.size());
	obuf+=conversion.size();
	sizeo-=conversion.size();

	ibuf+=nb_bytes_to_drop;
	sizei-=nb_bytes_to_drop;

	nb_bad_bytes+=nb_bytes_to_drop;
	nb_bad_bytes_last_conversion+=nb_bytes_to_drop;
      }

      if(sizei)
	loop_again=true;
    }
  } while (loop_again);

  nb_read_bytes+=strlen(to_convert)-sizei; // In case obuf was too small
  *obuf=0;
  // JS: result is constructed using refobuf and its length to support unicode
  std::string result(refobuf,obuf-refobuf);
  free((void*)refobuf);
  return result;
}

int DefaultCharsetConvertor::IncorrectCharacter(const std::string &charset,
                                                const char *character,
						std::string &conversion)
{
  if(charset=="UTF-8") {
    // Target charset not able to reproduce some characters, let's simplify them

    if(!strncmp(character,"…",3)) {
      conversion="...";
      return 3;
    } else if(!strncmp(character,"«",2) || !strncmp(character,"»",2)) {
      conversion="\"";
      return 2;
    } else if(!strncmp(character,"“",3) || !strncmp(character,"„",3)
	   || !strncmp(character,"”",3) || !strncmp(character,"‟",3)
	   || !strncmp(character,"」",3) || !strncmp(character,"「",3)) {
      conversion="\"";
      return 3;
    } else if(!strncmp(character,"』",3) || !strncmp(character,"『",3)
	   || !strncmp(character,"’",3) || !strncmp(character,"‘",3)) {
      conversion="'";
      return 3;
    } else if(!strncmp(character," ",2)) {
      conversion=" ";
      return 2;
    } else
      return 1;
  } else
    // Invalid character
    return 1;
}

std::string MessagesConvert(const std::string &m)
{
  /*  const char *encoding=OptGetValue("MESSAGES_ENCODING");
  
  if(!*encoding)*/
    return m;
    /*else
    return DefaultCharsetConvertor("UTF-8",OptGetValue("MESSAGES_ENCODING")).
    Convert(m);*/
}

const char *MessagesConvert(const char *m)
{
  static std::string res;
  res=MessagesConvert(std::string(m));
  return res.c_str();
}
