#ifndef _CASE_H_
#define _CASE_H_

#include "Unicode.h"
#include <string>

enum _case {
  _cna,
  _cundef,
  _clower,   // service | service area
  _ccapit,   // Service | Service area
  _callcap,  // Service Area
  _cmixed,   // service Area
  _cupper    // SERVICE AREA
};

static char *c_case[]={"na","undef","lower","capit","allcap","mixed","upper"};

enum _case GetCase(const char *utf8);
const char *SetLowerCase(const char *utf8);
const char *SetCapitalized(const char *utf8);
const char *SetUpperCase(const char *utf8);
const char *SetCase(const char *utf8, enum _case c);
int isCapitalized(const char *utf8);
int isUpperCase(const char *utf8);
int QuiteUpperCase_xmlflow(const char *utf8);

const char *RestoreCase(const char *src, const char *tgt);
const char *FullRestoreCase(void *token, const char *tgt);
enum _case MergeCase(enum _case c1, enum _case c2);

int CaseSmallerThan(const char *s1,const char *s2);

enum _case CombineCaseWithUpper(enum _case c1,int position);
  
// std::string Functions
const char *SetCapitalized(const std::string &utf8);
const char *SetUpperCase(const std::string &utf8);
const char *SetLowerCase(const std::string &utf8);
const char *SetCase(const std::string &utf8, _case c);
_case GetCase(const std::string &utf8);
int isCapitalized(const std::string &utf8);
int isUpperCase(const std::string &utf8);
int QuiteUpperCase_xmlflow(const std::string &utf8);
//UBYTE oldlingCapitalization(const std::string &s);
const char *RestoreCase(const std::string &src, const std::string &tgt);
std::string FullRestoreCase(const std::string &src, const std::string &tgt);

#endif //_CASE_H_
