#include <iostream>
#include <boost/filesystem/path.hpp>
#include <outilex/wrtn_pattern.h>
#include <outilex/xml.h>
#include <outilex/xml-names.h>
#include <outilex/xml_format_lexmask.h>
#include <outilex/xml_format_fst.h>

using namespace std;
namespace fs = boost::filesystem;
using namespace xmlnames;

struct wrtn_pattern_xml_formater {

  ling_def * ldef;

  wrtn_pattern_xml_formater(ling_def * l) : ldef(l) {}

  const char * fst_name() { return WRTN_PATTERN_ELEM; }
  
  void read_fst_data(xmlNode * node, wrtn_pattern & T) {
    node = node->children;
    while (node) {
      if (xmlStrcmp(node->name, "name") == 0) {
        char * text = (char * ) xmlNodeGetContent(node);
        T.name = text;
        xmlFree(text);
        return;
      }
      node = node->next;
    }
    cerr << "rtn_pattern: read xml: no name?\n";
  }
  void write_fst_data(xmlwriter & writer, const wrtn_pattern & T) {
    writer.write_element("name", T.name);
  }

  void read_fst_state_data(xmlNode * n, wrtn_pattern & T, int q) {}
  void write_fst_state_data(xmlwriter & writer, const wrtn_pattern & T, int q) {}

  void read_in(xmlNode * node, wrtn_input_type & in) {
    node = node->children;
    while (node) {
      if (node->type == XML_ELEMENT_NODE) {
        in.read_xml(node,ldef);
        return;
      }
      node = node->next;
    }
    cerr << "wrtn_pattern::read_in: no input found?\n";
  }

  void write_in(xmlwriter & writer, const wrtn_input_type & in) {
    in.write_xml(writer);
  }


  void read_out(xmlNode * node, wrtn_output_type & out) {
    out.read_xml(node);
  /*
    cerr << "LA1"<< endl;
    node = node->children;
    while (node) {
      cerr << "OUCH" << endl;
      if (node->type == XML_ELEMENT_NODE) {
        cerr << "ICI"<< endl;
        out.read_xml(node);
        return;
      }
      node = node->next;
    }
    */
  }
  void write_out(xmlwriter & writer, const wrtn_output_type & out) const{
    out.write_xml(writer);
  }

};

wrtn_pattern::wrtn_pattern(const fs::path & path, ling_def * ldef)
  : fst_type(), lingdef(ldef) {

  xml_read_fst(path, *this, wrtn_pattern_xml_formater(ldef));
}


void wrtn_pattern::read(const fs::path & path, ling_def * ldef) {
  clear();
  lingdef = ldef;
  xml_read_fst(path, *this, wrtn_pattern_xml_formater(ldef));
}

void wrtn_pattern::write(const fs::path & path) const {
  xml_write_fst(path, *this, wrtn_pattern_xml_formater(lingdef));
}

void wrtn_pattern::write_xml(xmlwriter & writer) const {
  xml_write_fst(writer, *this, wrtn_pattern_xml_formater(lingdef));
}

void wrtn_pattern::read_xml(xmlNode * node, ling_def * ldef) {
  lingdef = ldef;
  xml_read_fst(node, *this, wrtn_pattern_xml_formater(ldef));
}


