#include <string>
#include <boost/lexical_cast.hpp>

#include <outilex/wrtn_chart.h>
#include <outilex/xml_inl_format_sentence_fsa.h>
#include <outilex/xml_format_chart.h>
#include <outilex/xml.h>
#include <outilex/xml-names.h>

using namespace std;
using namespace boost;
using namespace xmlnames;



void wrtn_match_write_xml(xmlwriter & writer, const wrtn_match & m, int id) {

  writer.start_element(MATCH_ELEM);
  writer.write_attribute(ID_ATTR, lexical_cast<string>(id));
  writer.write_attribute(NAME_ATTR, m.name);
  writer.write_attribute(TO_ATTR, lexical_cast<string>(m.to));
  writer.write_attribute(WEIGHT_ATTR, lexical_cast<string>(m.w));

  writer.start_attribute(PATH_ATTR);
  for (synt_path_type::const_iterator it = m.path.begin(), end = m.path.end();
       it != end; ++it) {
    writer.write_string(lexical_cast<string>(it->qno) + " "
                        + lexical_cast<string>(it->transno) + " ");
  }
  writer.end_attribute();

  for (int i = 0; i < m.out.size(); ++i) {
    writer.write_element(OUT_ELEM, m.out[i]);
  }
  writer.end_element();
}


void wrtn_match_read_xml(xmlNode * node, wrtn_match & m, ling_def * ldef) {

  m.name = xmlGetConstProp(node, NAME_ATTR);
  m.to = lexical_cast<int>(xmlGetConstProp(node, TO_ATTR));
  m.w = lexical_cast<double>(xmlGetConstProp(node, WEIGHT_ATTR));

  m.path.clear();
  m.out.clear();

  istringstream is(xmlGetConstProp(node, PATH_ATTR));
  int qno, transno;
  while (is >> qno) {
    is >> transno;
    m.path.push_back(syntref(qno, transno));
  }

  node = node->children;
  while (node) {
    if (xmlStrcmp(node->name, OUT_ELEM) == 0) {
     char * text = (char *) xmlNodeGetContent(node);
     m.out.push_back(text);
     xmlFree(text);
    }
  }
}


namespace {

void chart_node_write_xml(xmlwriter & writer, const wrtn_chart & chart, int q) {

  writer.start_element(NODE_ELEM);
  writer.write_attribute(ID_ATTR, lexical_cast<string>(q));

  wrtn_chart::const_match_iterator it = chart[q].begin(), end = chart[q].end();
  for (int i = 1; it != end; ++it, ++i) {
    wrtn_match_write_xml(writer, *it, i);
  }
  writer.end_element();
}

} // namespace ""

void wrtn_chart_write_xml(xmlwriter & writer, const wrtn_chart & chart) {

  writer.start_element(CHART_ELEM);

  sentence_fsa_write_inline_xml(writer, chart.fsa);

  int size = chart.size();
  writer.start_element(TABLE_ELEM);
  writer.write_attribute(SIZE_ATTR, lexical_cast<string>(size));
 
  for (int i = 0; i < size; ++i) {
    chart_node_write_xml(writer, chart, i);
  }
  writer.end_element();

  writer.end_element();
}

