#include <boost/lexical_cast.hpp>

#include <outilex/xml.h>
#include <outilex/xml-names.h>
#include <outilex/wrtn_pattern.h>
#include <outilex/generic_fst.h>

using namespace std;
using namespace boost;
using namespace xmlnames;

namespace fs = boost::filesystem;


wrtn_pattern::wrtn_pattern(const generic_fst & fst, ling_def * ldef)
  : fst_type(), lingdef(ldef) {

  name = fst.name;

  int size = fst.size();
  clear();
  resize(size);

  for (int i = 0; i < size; ++i) {

    set_final(i, fst.final(i));

    if (final(i)) {
      const generic_fst::outputs_type & outputs = fst.final_outputs(i);
      for (generic_fst::outputs_type::const_iterator it = outputs.begin();
           it != outputs.end(); ++it) {
        final_outputs(i).insert(output_type(*it));
      }
    }

    for (generic_fst::transitions::const_iterator tr = fst.trans_begin(i);
         tr != fst.trans_end(i); ++tr) {
      try {
        add_trans(i, input_type(tr->in(), lingdef), output_type(tr->out()), tr->to());
      } catch (exception & e) {
        cerr << "error: bad label: " << tr->in() << ": " << e.what() << endl;
      }
    }
  }
}

