#include <outilex/wrtn_output_type.h>
#include <outilex/xml-names.h>
#include <boost/lexical_cast.hpp>

using namespace std;
using namespace boost;
using namespace xmlnames;


wrtn_output_type::wrtn_output_type(const std::string & s){

  int slash = s.rfind("/");

  label = s.substr(0,slash);

  if (slash == string::npos || slash == s.size() - 1) {
    weight = 0.0;
  } else {
    weight = lexical_cast<double>(s.substr(slash + 1));
  }
}


void wrtn_output_type::write_xml(xmlwriter & writer) const {
  writer.write_attribute(WRTN_WEIGHT_ATTR,lexical_cast<string>(weight));
  writer.write_string(label);
}


void wrtn_output_type::read_xml(xmlNodePtr node){
 // cout << "ICI" << "\n";  
  weight = lexical_cast<double>(xmlGetProp(node,WRTN_WEIGHT_ATTR));
  label = (char *) xmlNodeGetContent(node);
}

