#include <iostream>
#include <fstream>
#include <stdexcept>
#include <sstream>
#include <vector>

#include <boost/lexical_cast.hpp>
#include <boost/filesystem/path.hpp>
#include <boost/filesystem/fstream.hpp>

#include <outilex/wrtn_grammar.h>
#include <outilex/fsa-determinize.h>


namespace {

using namespace std;
using namespace boost;
namespace fs = boost::filesystem;

char * progname;


void usage() {
  cerr << "usage: " << progname << " <rtn> [-maxdepth <N>]\n";
  exit(1);
}


}; // namespace ""


int main(int argc, char ** argv) try {

  fs::path lingdefpath, rtnpath;
  int maxdepth = numeric_limits<int>::max();

  char * text = getenv("LINGDEF");
  if (text) {
    lingdefpath = fs::path(text, fs::native);
  }


  progname = *argv;

  argv++, argc--;

  while (argc) {
    
    string arg = *argv;
    
    if (arg == "-l") {
      
      argv++, argc--;
      if (argc == 0) { usage(); }
      lingdefpath = fs::path(*argv, fs::native);
    
    } else if (arg == "-rtn") {
      
      argv++, argc--;
      if (argc == 0) { usage(); }
      rtnpath = fs::path(*argv, fs::native);
    
    } else if (arg == "-depth") {

      argv++, argc--;
      if (argc == 0) { usage(); }
      maxdepth = lexical_cast<int>(*argv);
 
    } else if (arg == "-h") {
    
      usage();
    
    } else {

      rtnpath = fs::path(arg, fs::native);
    }

    argv++, argc--;
  }

  if (lingdefpath.empty() || rtnpath.empty()) { usage(); }

  ling_def lingdef(lingdefpath);

  wrtn_grammar gram(rtnpath, & lingdef);

  cout << "flattening " << rtnpath.string() << "...\n";
  bool ok = flatten(gram, maxdepth);



  if (ok) {
    cout << "done. the resulting grammar is an equivalent FST.\n";  
  } else {
    cout << "done. the resulting grammar is an RTN.\n";
  }

#if 0
  cout << "determinization\n";
  fsa_determinize(gram.patterns[0]);
#endif
  gram.write(rtnpath);
  return 0;

} catch (exception & e) {

  cerr << "exception caught :" << e.what() << endl; exit(1);
}
