#ifndef _XML_TEXT_RTN_CHART_H_
#define _XML_TEXT_RTN_CHART_H_

#include <boost/filesystem/path.hpp>

#include <outilex/xml.h>
#include <outilex/xmlReader.h>


class ling_def;
class wrtn_chart;

class xml_ichart {

  boost::filesystem::path path;
  xmlreader reader;
  ling_def * lingdef;

  int size_;
  int pos;

public:

  xml_ichart(const boost::filesystem::path & path_, ling_def * ldef)
    : path(), reader(), lingdef(ldef), size_(-1), pos(-1) { open(path_); }

  ~xml_ichart() { close(); }

  void open(const boost::filesystem::path & path);
  void close();

  int size() const { return size_; }

  bool ok() const { return reader && pos != -1; }

  bool read_next(wrtn_chart & chart);

  bool seek(int pos);
  void rewind();
  int tell() const { return pos; }
};

inline xml_ichart & operator>>(xml_ichart & in, wrtn_chart & chart) {
  in.read_next(chart); return in;
}



class xml_ochart {

  xmlwriter writer;
  int size_;

public:
  xml_ochart(const boost::filesystem::path & path, int size = -1, int compression = 0) 
    : writer(), size_(size) { open(path, size, compression); }
  //xml_ochart(std::ostream & os, int size = -1) : writer() { open(os, size); }

  ~xml_ochart() { close(); }

  void open(const boost::filesystem::path & path, int size = -1, int compression = 0);
  void open(std::ostream & os, int size = -1);

  void close();

  void write(const wrtn_chart & chart);

  void flush() { return writer.flush(); }

  bool ok() const { return writer; }

  int size() const { return size_; }
};


inline xml_ochart & operator<<(xml_ochart & out, const wrtn_chart & chart) {
  out.write(chart); return out;
}

#endif
