#ifndef _WRTN_PARSER_H_
#define _WRTN_PARSER_H_

#include <vector>
#include <set>
#include <iostream>

#include <outilex/unique_sequence.h>
#include <outilex/syntref.h>
#include <outilex/wrtn_grammar.h>


/* EARLEY parser for WRTN local grammars */


class sentence_fsa;
class wrtn_chart;


class wrtn_parser {

public:


  // optimisation flags
  static const int IGNORE_DIFF_PATHS   = 1;
  static const int IGNORE_DIFF_OUTPUTS = 2;
  static const int SURF_PARSING        = 4;

  typedef wrtn_grammar::input_type  input_type;
  typedef wrtn_grammar::output_type output_type;


  wrtn_parser(const wrtn_grammar & grm, int f = 0) : gram(grm), pchart(NULL), agenda(), flags(f) {}
  ~wrtn_parser() {}


  /* return 0 on success
   * -1 when parsing was interupted because it took too much time (> maxtime seconds)
   *
   * if maxtime == 0 (default) there is no limit in time, (always return 0)
   */
  int parse(wrtn_chart & res, double maxtime = 0.);


public:

  /* internal data structures */

  struct e_item {

    const wrtn_pattern * pfst;
    int q;
    int from, to;
    mutable std::vector<std::string> out;
    mutable double weight;
    mutable synt_path_type path;

    e_item(const wrtn_pattern & fst_, int q_, int from_, int to_,
           const std::vector<std::string> & out_, const synt_path_type & path_, double weight_)
      : pfst(& fst_), q(q_), from(from_), to(to_), out(out_), weight(weight_),path(path_) {}


    bool operator<(const e_item & item) const {
      if (pfst != item.pfst) { return pfst < item.pfst; }
      if (q != item.q) { return q < item.q; }
      if (from != item.from) { return from < item.from; }
      if (to != item.to) { return to < item.to; }
      return false;
      // optimisation :
      //if (weight != item.weight) {return weight < item.weight; }
      //if (out != item.out) { return out < item.out; }
      //return path < item.path;
    }

    void dump(std::ostream & os) const;
  };

  struct compare_items {

   int flags;

   compare_items(int f) : flags(f) {}

   bool operator()(const e_item & a, const e_item & b) const {
     
     if (a.pfst != b.pfst) { return a.pfst < b.pfst; }
     if (a.q != b.q) { return a.q < b.q; }
     if (a.from != b.from) { return a.from < b.from; }
     if (a.to != b.to) { return a.to < b.to; }

     if (!(flags & IGNORE_DIFF_OUTPUTS)) {
       if (a.out != b.out) { return a.out < b.out; }
     }

     if (!(flags & IGNORE_DIFF_PATHS)) {
       if (a.path != b.path) { return a.path < b.path; }
     }
     return false;
     // ignore weight in comparison
   }
  };

  typedef unique_sequence<e_item, compare_items> earley_stack;
  typedef std::vector<earley_stack> e_agenda;

  const wrtn_grammar & gram;
  wrtn_chart * pchart;
  const sentence_fsa * ptxt;
  e_agenda agenda;
  int flags;

protected:

  void ENQUEUE(int pos, const e_item & item);
  void PREDICTOR(int pos, const std::string & syntname);
  void COMPLETER(int pos, const e_item & item);
  double add_weight(double a,double b);
};


inline std::ostream & operator<<(std::ostream & os, const wrtn_parser::e_item & item) {
  item.dump(os); return os;
}


#endif
