#ifndef _WRTN_INPUT_TYPE_H_
#define _WRTN_INPUT_TYPE_H_

#include <string>
#include <boost/variant.hpp>

#include <outilex/xml.h>
#include <outilex/lexical_mask.h>


struct wrtn_input_type {

  enum noname { EPSILON, LEXMASK, SUBCALL } type;
  boost::variant<std::string, lexical_mask> v;

  wrtn_input_type() : type(EPSILON), v(std::string()) {}

  /* construct from a text description */
  wrtn_input_type(const std::string & text, ling_def * ldef);


  /* free standing constructors */
  static inline wrtn_input_type epsilon() { return wrtn_input_type(); }
  static wrtn_input_type subcall(const std::string & name);
  static wrtn_input_type lexmask(const lexical_mask & m);


  void write_xml(xmlwriter & writer) const;
  void read_xml(xmlNodePtr node, ling_def * lingdef);

  void dump(std::ostream & os) const;

#if 0
  bool operator<(const wrtn_input_type & b) const {
    if (type != b.type) { return type < b.type; }
    if (type == EPSILON) {
      return false;
    }
    if (type == LEXMASK) {
      return 
    }
  }
#endif
};



inline std::ostream & operator<<(std::ostream & os, const wrtn_input_type & in) {
  in.dump(os); return os;
}

#endif
