#ifndef TEXT_TRANSDUCTION_H
#define TEXT_TRANSDUCTION_H

#include <iostream>
#include <string>

class wrtn_chart;

enum txt_trans_mode_type { IGNORE, MERGE, REPLACE };

enum txt_trans_output_type { TEXT, HTML };

int wchart_text_transduct(const wrtn_chart & chart, std::ostream & os,
                          const std::string & axiom,
                          txt_trans_mode_type transmode, txt_trans_output_type outmode);


struct wchart_text_transducer {

  std::ostream & os;
  const std::string & axiom;
  txt_trans_mode_type transmode;
  txt_trans_output_type outmode;
  int nbmatch;

  wchart_text_transducer(std::ostream & os_, const std::string & axiom_,
                         txt_trans_mode_type tmode, txt_trans_output_type omode)
    : os(os_), axiom(axiom_), transmode(tmode), outmode(omode), nbmatch(0) {}

  void operator()(const wrtn_chart & chart, int res) {
    nbmatch += wchart_text_transduct(chart, os, axiom, transmode, outmode);
  }
};

#endif
