#ifndef FSA_DECORATION_H
#define FSA_DECORATION_H

#include <string>
#include <iostream>
#include <boost/progress.hpp>

#include <outilex/wrtn_chart.h>
#include <outilex/text_fsa.h>


int decore_fsa(wrtn_chart & chart, const std::string & axiom, bool verbose = false);



struct fsa_decorizer {

  otext_fsa & otext;
  const std::string & axiom;
  int nbmatch;
  bool verbose;

  fsa_decorizer(otext_fsa & otext_, const std::string & axiom_, bool verbose_ = false)
    : otext(otext_), axiom(axiom_), nbmatch(0), verbose(verbose_) {}
 
  void operator()(wrtn_chart & chart, int res) {
    nbmatch += decore_fsa(chart, axiom, verbose);
    otext << chart.fsa;
  }
};


#endif
