#ifndef CONCORDANCES_H
#define CONCORDANCES_H


#include <iostream>
#include <string>

class wrtn_chart;

static const int CONCORD_SHOW_TAGS = 1;     // output morphosyntactic tags
static const int CONCORD_SHOW_TREE = 2;     // output syntactic tree
static const int CONCORD_LONGEST_MATCH = 4; // output only longest matches
static const int CONCORD_SHOW_OUTPUTS = 8;  // output grammar's outputs
static const int CONCORD_SHOW_WEIGHTS = 16; // output weights


int wchart_make_concordances_index(const wrtn_chart & chart, std::ostream & os,
                                   const std::string & axiom, int flags);

struct wchart_concordancer {

  std::ostream & os;
  const std::string & axiom;
  int flags;
  int nbmatch;

  wchart_concordancer(std::ostream & out, const std::string & axiom_, int f)
    : os(out), axiom(axiom_), flags(f), nbmatch(0) {}

  void operator()(const wrtn_chart & chart, int res) {
    nbmatch += wchart_make_concordances_index(chart, os, axiom, flags);
  }
};

#endif
