#include <outilex/wrtn_grammar.h>


using namespace std;
using namespace boost;


namespace {


template<typename OutputIterator>
void lookup_subcalls(const wrtn_pattern & pat, OutputIterator out) {

  for (int q = 0; q < pat.size(); ++q) {
  
    for (wrtn_pattern::const_trans_iterator tr = pat.trans_begin(q), end = pat.trans_end(q);
         tr != end; ++tr) {
    
      if (tr->in().type == wrtn_input_type::SUBCALL) {
      
        *out = boost::get<string>(tr->in().v);
        ++out;
      }
    }
  }
}


int flatten(wrtn_pattern & dest, const wrtn_pattern & src, int to) {

  const int init = dest.size();

  /* if src is empty, create a useless state */

  if (src.empty()) {
    dest.resize(init + 1);
    return init;
  }

  dest.resize(init + src.size());

  for (int q = 0; q < src.size(); ++q) {

    for (wrtn_pattern::const_trans_iterator tr = src.trans_begin(q), end = src.trans_end(q);
         tr != end; ++tr) {
      dest.add_trans(init + q, tr->in(), tr->out(), init + tr->to());
    }
 
    if (src.final(q)) {
      dest.add_trans(init + q, wrtn_input_type::epsilon(), wrtn_output_type(), to);
    }
  }
  return init;
}

} //namespace ""


bool flatten(wrtn_grammar & gram, int maxdepth) {

  assert(gram.start() == 0);

  wrtn_pattern fst = gram[gram.start()];

  int oldsize = 0, size = fst.size();

  while (maxdepth && oldsize < size) { // can add a max rec depth condition here

    for (int q = oldsize; q < size; ++q) {

      for (int trno = 0; trno != fst.trans_size(q); ++trno) {

        wrtn_pattern::transition & tr = fst.get_trans(q, trno);

        if (tr.in().type == wrtn_input_type::SUBCALL) {

          int idx = gram.get_pat_idx(boost::get<string>(tr.in().v));
          if (idx == -1) {
            cerr << "error : subgraph " << boost::get<string>(tr.in().v) << " not found\n";
            continue;
          }
          int to = flatten(fst, gram[idx], tr.to());
        
          /* we retrieve a new ref to tr because flatten may have change its adress ... (sigh) */
          wrtn_pattern::transition & tr2 = fst.get_trans(q, trno);
          tr2.to() = to;
          tr2.in() = wrtn_input_type::epsilon();
        }
      }

    }
    oldsize = size;
    size = fst.size();
    --maxdepth;
  }


  vector<wrtn_pattern> npatterns;
  map<string, int> npat_map;

  npat_map[fst.name] = 0;
  npatterns.resize(1);
  npatterns[0].swap(fst);

  if (oldsize != size) { // max depth reached retrieve remaining subgraphs

    vector<string> stack;
    lookup_subcalls(npatterns[0], back_inserter(stack));

    while (! stack.empty()) {
 
      string name = stack.back(); stack.pop_back();
      
      if (npat_map.find(name) != npat_map.end()) { continue; }

      int idx = gram.get_pat_idx(name); 
      if (idx == -1) { continue; }
    
      int size = npatterns.size();

      npatterns.resize(size + 1);
      npatterns[size].swap(gram[idx]);
 
      npat_map[name] = size;

      lookup_subcalls(npatterns[size], back_inserter(stack));
    }
  }

  gram.patterns.swap(npatterns);
  gram.pat_map.swap(npat_map);
  gram.axiom = 0;

  return (oldsize == size);
}


