/*
 * example template of a program which parse a text fsa with a wrtn grammar
 * and apply a 'do-nothing' functor to the resulting chart
 * 
 * you can copy and edit this file to make it use our custom wchart functor.
 */


#include <iostream>
#include <stdexcept>

#include <boost/progress.hpp>
#include <boost/scoped_ptr.hpp>
#include <boost/filesystem/path.hpp>
#include <boost/filesystem/convenience.hpp>
#include <boost/filesystem/fstream.hpp>

#include <outilex/text_fsa.h>
#include <outilex/wrtn_grammar.h>

#include <outilex/wparsing_helper.h>

/* include your custom functor header here */
//#include <outilex/wchart_custom_functor.h>

/* "do nothing" functor */
typedef wchart_null_functor custom_functor;


using namespace std;
using namespace boost;
namespace fs = boost::filesystem;



namespace {

char * progname;

void usage(ostream & os, int ret) {
  os << "usage: " << progname
    << " -l <lingdef> -gram <fst> [-longest-match][-ipath][-iout][-dontsurf][-o <outputres>] <txtfsa>\n";
  exit(ret);
}

void usage() { usage(cout, 0); }
void bad_args() { cerr << "\nbad arguments.\n\n"; usage(cerr, 1); }

}; // namespace ""


int main(int argc, char ** argv) try {

  fs::path txtpath, lingdefpath, grampath, opath;
  bool longest_match = false;

  char * text = getenv("LINGDEF");
  if (text) {
    lingdefpath = fs::path(text, fs::native);
  }


  /* defaut to surf parsing */
  int PARSER_FLAGS = wrtn_parser::SURF_PARSING;

  progname = *argv;

  argv++, argc--;

  if (argc == 0) { usage(); }

  while (argc) {
    
    string arg = *argv;
    
    if (arg == "-l") {
      
      argv++, argc--;
      if (argc == 0) { bad_args(); }
      lingdefpath = fs::path(*argv, fs::native);
    
    } else if (arg == "-o") {
      
      argv++, argc--;
      if (argc == 0) { bad_args(); }
      opath = fs::path(*argv, fs::native);
    
    } else if (arg == "-gram") {
      
      argv++, argc--;
      if (argc == 0) { bad_args(); }
      grampath = fs::path(*argv, fs::native);
 
    } else if (arg == "-ipath") {
    
      PARSER_FLAGS |= wrtn_parser::IGNORE_DIFF_PATHS;

    } else if (arg == "-iout") {
    
      PARSER_FLAGS |= wrtn_parser::IGNORE_DIFF_OUTPUTS;

    } else if (arg == "-dontsurf") {
    
      PARSER_FLAGS &= ~(wrtn_parser::SURF_PARSING);

    } else if (arg == "-longest-match") {
 
      longest_match = true;

    } else if (arg == "-h") {
    
      usage();
    
    } else {

      txtpath = fs::path(arg, fs::native);
    }

    argv++, argc--;
  }

  if (txtpath.empty() || lingdefpath.empty() || grampath.empty()) { bad_args(); }

  /* opath is unused in this example */
  if (opath.empty()) {
    opath = txtpath.branch_path() / (txtpath.leaf() + ".out");
  }


  ling_def lingdef(lingdefpath);

  scoped_ptr<itext_fsa> p_itext(new_itext_fsa(txtpath, & lingdef));
  itext_fsa & itext = *p_itext;

  wrtn_grammar gram(grampath, & lingdef);


  int total = itext.size();

  /* modify the following line to make it use your custom functor */
  custom_functor functor;
  /* output a nice progress bar */
  progress_displayer<custom_functor> displayer(functor, total);


  boost::timer tmr;

  /* this is where the black magic lies.
   */
  int nbsentence = wrtn_parse(itext, gram, displayer, PARSER_FLAGS, longest_match);


  cout << "done. " << nbsentence << "/" << total << " sentences parsed. "
    << tmr.elapsed() << "s.\n"
    << "result in " << opath.string() << ".\n";

  return 0;

} catch (exception & e) {

  cerr << "fatal error :" << e.what() << endl; exit(1);

} catch (...) { cerr << "caught an OVNI?\n"; exit(1); }

