#include <boost/lexical_cast.hpp>
#include <outilex/xml_format_fst.h>
#include <outilex/wfst.h>

using namespace std;
using namespace boost;
namespace fs = boost::filesystem;

struct wfst_xml_formater {

  wfst_xml_formater() {}

  const char * fst_name() { return "wfst"; }

  void read_fst_data(xmlNode * node, wfst & T) {}
  void write_fst_data(xmlwriter & writer, const wfst & T) {}

  void read_fst_state_data(xmlNode * n, wfst & T, int q) {}
  void write_fst_state_data(xmlwriter & writer, const wfst & T, int q) {}

  void read_in(xmlNode * node, int & in) {
    node = node->children;
    while (node) {
      if (node->type == XML_ELEMENT_NODE) {
        char * text = (char *) xmlGetProp(node, "label");
        in = lexical_cast<int>(text);
        xmlFree(text);
        return;
      }
      node = node->next;
    }
    cerr << "wfst::read_in: no input found?\n";
  }

  void write_in(xmlwriter & writer, const int & in) {
    writer.start_element("in");
    writer.write_attribute("label", lexical_cast<string>(in));
    writer.end_element();
  }


  void read_out(xmlNode * node, wfst_output & out) {
    out.read_xml(node);
  }
  void write_out(xmlwriter & writer, const wfst_output & out) {
    out.write_xml(writer);
  }

};

wfst::wfst(const fs::path & path)
  : fst_type() {

  xml_read_fst(path, *this, wfst_xml_formater());
}
  
void wfst::read(const fs::path & path) {
  clear();
  xml_read_fst(path, *this, wfst_xml_formater());
}

void wfst::write(const fs::path & path) const {
  xml_write_fst(path, *this, wfst_xml_formater());
}

void wfst::write_xml(xmlwriter & writer) const {
  xml_write_fst(writer, *this, wfst_xml_formater());
}

void wfst::read_xml(xmlNode * node) {
  xml_read_fst(node, *this, wfst_xml_formater());
}

