#include <boost/filesystem/fstream.hpp>
#include <iostream>
#include <sstream>
#include <stdexcept>
#include <outilex/wfst_symbols.h>

using namespace std;
namespace fs = boost::filesystem;

wfst_symbols::wfst_symbols(const fs::path & path) : tree(), tab() {

  fs::ifstream is(path);

  string line;

  while (getline(is, line)) {

    std::string label;
    int idx;
    istringstream iss(line); 
    iss.exceptions(ios_base::failbit | ios_base::badbit);
    iss >> label >> idx;

    if (idx < 0 
        || tree.lookup_idx(label) != -1
        || (tab.size() > idx && ! tab[idx].empty())) {
      throw runtime_error("bad sym file");
    }

    if (tab.size() <= idx) { tab.resize(idx + 1); }
    tab[idx] = label;
    tree.insert(label, idx);    
  }
}

