#include <boost/lexical_cast.hpp>
#include <outilex/wfst.h>

using namespace std;
using namespace boost;

wfst_output::wfst_output(const string& text, const wfst_symbols & alph) {

  string::size_type colon = text.rfind(':'); 

  if (colon == string::npos) {
    out = alph[text];
    weight = 0;
  }  else {
    out = alph[text.substr(0, colon)];
    weight = lexical_cast<double>(text.substr(colon + 1));
  }
}

wfst_output::wfst_output(const string& text) {

  string::size_type colon = text.rfind(':'); 

  if (colon == string::npos) {
    out = lexical_cast<int>(text);
    weight = 0;
  }  else {
    out = lexical_cast<int>(text.substr(0, colon));
    weight = lexical_cast<double>(text.substr(colon + 1));
  }
}

void wfst_output::write_xml(xmlwriter & writer) const {
  writer.start_element("out");
  writer.write_attribute("label", lexical_cast<string>(out));
  writer.write_attribute("cost", lexical_cast<string>(weight));
  writer.end_element();
}

void wfst_output::read_xml(xmlNode * node) {
  node = node->children;
  while (node) {
    if (node->type == XML_ELEMENT_NODE) {
      char * text = (char *) xmlGetProp(node, "label");
      out = lexical_cast<int>(text);
      xmlFree(text);
      text = (char *) xmlGetProp(node, "cost");
      out = lexical_cast<int>(text);
      xmlFree(text);
      return;
    }
    node = node->next;
  }
  cerr << "wfst::read_out: no input found?\n";
}



void wfst::load(const generic_fst & fst, const wfst_symbols & alph) {

  int size = fst.size();
  clear();
  resize(size);

  for (int i = 0; i < size; ++i) {

    set_final(i, fst.final(i));

    if (final(i)) {
    /*
      const generic_fst::outputs_type & outputs = fst.final_outputs(i);
      for (generic_fst::outputs_type::const_iterator it = outputs.begin();
           it != outputs.end(); ++it) {
        final_outputs(i).insert(output_type(*it));
      }
      */
      if (! fst.final_outputs(i).empty()) {
        cerr << "warning : final outputs\n";
      }
    }

    for (generic_fst::transitions::const_iterator tr = fst.trans_begin(i);
         tr != fst.trans_end(i); ++tr) {
      try {
        int in = alph[tr->in()];
        add_trans(i, in, output_type(tr->out(), alph), tr->to());
      } catch (exception & e) {
        cerr << "error: bad label: '" << tr->in() << "/" << tr->out() << "': " << e.what() << endl;
      }
    }
  }
}

void wfst::load(const generic_fst & fst) {

  int size = fst.size();
  clear();
  resize(size);

  for (int i = 0; i < size; ++i) {

    set_final(i, fst.final(i));

    if (final(i)) {
    /*
      const generic_fst::outputs_type & outputs = fst.final_outputs(i);
      for (generic_fst::outputs_type::const_iterator it = outputs.begin();
           it != outputs.end(); ++it) {
        final_outputs(i).insert(output_type(*it));
      }
      */
      if (! fst.final_outputs(i).empty()) {
        cerr << "warning : final outputs\n";
      }
    }

    for (generic_fst::transitions::const_iterator tr = fst.trans_begin(i);
         tr != fst.trans_end(i); ++tr) {
      try {
        int in = lexical_cast<int>(tr->in());
        add_trans(i, in, output_type(tr->out()), tr->to());
      } catch (exception & e) {
        cerr << "error: bad label: '" << tr->in() << "/" << tr->out() << "': " << e.what() << endl;
      }
    }
  }
}
