#include <iostream>
#include <boost/filesystem/path.hpp>
#include <boost/filesystem/convenience.hpp>
#include <outilex/wfst.h>
#include <outilex/generic_fst.h>

using namespace std;
namespace fs = boost::filesystem;

char * progname;
void usage() {
  cout << "usage: " << progname << "[-alph <alph>] <genfst>\n";
  exit(0);
}

int main(int argc, char ** argv) try {

  fs::path ipath, opath, alphpath;
  progname = *argv;
  argv++, argc--;

  while (argc) {
    string arg = *argv;
    if (arg == "-alph") {
      argv++, argc--;
      if (! argc) { cerr << "bad args\n"; exit(1); }
      alphpath = *argv;
    } else if (arg == "-h") {
      usage();
    } else {
      ipath = *argv;
    }
    argv++, argc--;
  }
  
  if (ipath.empty()) { usage(); }

  opath = fs::change_extension(ipath, ".wfst");

  wfst fst;

  generic_fst gfst(ipath);
  if (alphpath.empty()) {
    fst.load(gfst);
  } else {
    wfst_symbols alph(alphpath);
    fst.load(gfst, alph);
  }

  fst.write(opath);
} catch (exception & e) {
  cerr << "fatal error : " << e.what() << endl;
  exit(1);
}


