#ifndef _WFST_SYMBOLS_H_
#define _WFST_SYMBOLS_H_

#include <boost/filesystem/path.hpp>
#include <vector>
#include <outilex/lexico_tree.h>

class wfst_symbols {
public:

  wfst_symbols(const boost::filesystem::path& path);

  int operator[](const std::string & text) const {
    return tree.lookup_idx(text);
  }
 
 
  const std::string & operator[](int idx) const {
    return tab[idx];
  }

  lexico_tree<> tree;
  std::vector<std::string> tab;
};

#endif
